#!/bin/sh
#
# @package      hubzero-tigervnc-java
# @file         jtigervncviewer.sh
# @copyright    Copyright (c) 2014-2020 The Regents of the University of California.
# @license      http://www.gnu.org/licenses/gpl-2.0.html GPLv2+
#
# Copyright (c) 2014-2020 The Regents of the University of California.
#
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

if [ "$1" = "--help" ] || [ "$1" = "-help" ] ; then
    echo "USAGE: jtigervncviewer HOST[:(DISPLAY#|:PORT#)]"
    exit 0
fi

PT=$(echo "$1" | grep "::")
if [ -n "$PT" ] ; then
    HOST=$(echo "$PT" | sed -e "s/::.*//;")
    PORT=$(echo "$PT" | sed -e "s/.*:://;")
else
    PT=$(echo "$1" | grep ":")
    if [ -n "$PT" ] ; then 
	HOST=$(echo "$PT" | sed -e "s/:.*//;")
	P=$(echo "$PT" | sed -e "s/.*://;")
	PORT=$(echo "5900+$P" | bc)
    else
	HOST="$1"
	PORT=5900
    fi
fi

echo $HOST $PORT

export CLASSPATH=/usr/share/java/tigervncviewer.jar

java VncViewer HOST $HOST PORT $PORT
