#!/bin/bash -l
#
# File:     moab_submit.sh
#
# Author:   Gideon Juve (gideon@isi.edu)
# Author:   David Rebatto (david.rebatto@mi.infn.it)
# Author:   Keith Sephton (kms@doc.ic.ac.uk)
#
# Description: Submit a Moab job
#
# Copyright 2015 University of Southern California.
# Copyright (c) Members of the EGEE Collaboration. 2004.
# See http://www.eu-egee.org/partners/ for details on the copyright
# holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

. $(dirname $0)/blah_common_submit_functions.sh

bls_parse_submit_options "$@"

# Condor doesn't pass classads for these args, so I didn't implement them
# Arg         Variable                    ClassAd
# -n          bls_opt_mpinodes            NodeNumber (int)
# -N          bls_opt_hostsmpsize         HostSMPSize (int)
# -z          bls_opt_wholenodes          WholeNodes (boolean)
# -h          bls_opt_hostnumber          HostNumber (int)
# -S          bls_opt_smpgranularity      SMPGranularity (int)
# -a          bls_opt_xtra_args           BatchExtraSubmitArgs (string)

bls_setup_all_files

cat > $bls_tmp_file << end_of_preamble
#!/bin/bash
# Moab job wrapper generated by $(basename $0) on $(/bin/date)
#
# stgcmd = $bls_opt_stgcmd
# proxy_string = $bls_opt_proxy_string
# proxy_local_file = $bls_proxy_local_file
#
#MSUB -S /bin/bash
#MSUB -o /dev/null
#MSUB -e /dev/null
#MSUB -m n
end_of_preamble

# Write queue attribute if specified by +BatchQueue in submit file
if [ -n "$bls_opt_queue" ]; then
    echo "#MSUB -q $bls_opt_queue" >> $bls_tmp_file
fi

#local batch system-specific file output must be added to the submit file
bls_local_submit_attributes_file=${blah_libexec_directory}/moab_local_submit_attributes.sh
if [ -r "$bls_local_submit_attributes_file" ]; then
    echo \#\!/bin/sh > $bls_opt_tmp_req_file
    if [ -n $bls_opt_req_file ]; then
        cat $bls_opt_req_file >> $bls_opt_tmp_req_file
    fi
    echo "source $bls_local_submit_attributes_file" >> $bls_opt_tmp_req_file
    chmod +x $bls_opt_tmp_req_file
    $bls_opt_tmp_req_file >> $bls_tmp_file 2> /dev/null
    rm -f $bls_opt_tmp_req_file
fi

bls_add_job_wrapper

# Submit job (this is how bls_opt_xtra_args should be done)
jobID=$(${moab_binpath}/msub $bls_tmp_file)
retcode=$?
if [ "$retcode" != "0" ]; then
    rm -f $bls_tmp_file
    exit 1
fi

# Construct blah job ID. Seems blah needs 3 components, so I put in some foo.
blahp_jobID="moab/foo/$jobID"
echo "BLAHP_JOBID_PREFIX$blahp_jobID"

# Add job to registry if configured
if [ -n "$job_registry" ]; then
    now=$(date +%s)
    let now=$now-1
    ${blah_sbin_directory}/blah_job_registry_add "$blahp_jobID" "$jobID" 1 $now "$bls_opt_creamjobid" "$bls_proxy_local_file" "$bls_opt_proxyrenew_numeric" "$bls_opt_proxy_subject"
fi

bls_wrap_up_submit

exit $retcode

