<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("16.4. Monitoring");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="api.php">API Reference</a></span> &gt; <span class="breadcrumb-node">Monitoring</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="rest-api-monitoring"></a>16.4. Monitoring</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="rest-api-monitoring.php#idm10014">16.4.1. Resource Definition</a></span></dt>
<dt><span class="section"><a href="rest-api-monitoring.php#section-endpoints">16.4.2. Endpoints</a></span></dt>
<dt><span class="section"><a href="rest-api-monitoring.php#querying">16.4.3. Querying</a></span></dt>
<dt><span class="section"><a href="rest-api-monitoring.php#ordering">16.4.4. Ordering</a></span></dt>
<dt><span class="section"><a href="rest-api-monitoring.php#idm11036">16.4.5. Examples</a></span></dt>
</dl></div>
<p>Monitoring REST API allows developers to query a Pegasus workflow's
    STAMPEDE database.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm10014"></a>16.4.1. Resource Definition</h3></div></div></div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-root-workflow"></a>16.4.1.1. Root Workflow</h4></div></div></div>
<pre class="programlisting">{
    "wf_id"             : &lt;int:wf_id&gt;,
    "wf_uuid"           : &lt;string:wf_uuid&gt;,
    "submit_hostname"   : &lt;string:submit_hostname&gt;,
    "submit_dir"        : &lt;string:submit_dir&gt;,
    "planner_arguments" : &lt;string:planner_arguments&gt;,
    "planner_version"   : &lt;string:planner_version&gt;,
    "user"              : &lt;string:user&gt;,
    "grid_dn"           : &lt;string:grid_dn&gt;,
    "dax_label"         : &lt;string:dax_label&gt;,
    "dax_version"       : &lt;string:dax_version&gt;,
    "dax_file"          : &lt;string:dax_file&gt;,
    "dag_file_name"     : &lt;string:dag_file_name&gt;,
    "timestamp"         : &lt;int:timestamp&gt;,
    "workflow_state"    : &lt;object:workflow_state&gt;,
    "_links"            : {
        "workflow" : &lt;href:workflow&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-workflow"></a>16.4.1.2. Workflow</h4></div></div></div>
<pre class="programlisting">{
    "wf_id"             : &lt;int:wf_id&gt;,
    "root_wf_id"        : &lt;int:root_wf_id&gt;,
    "parent_wf_id"      : &lt;int:parent_wf_id&gt;,
    "wf_uuid"           : &lt;string:wf_uuid&gt;,
    "submit_hostname"   : &lt;string:submit_hostname&gt;,
    "submit_dir"        : &lt;string:submit_dir&gt;,
    "planner_arguments" : &lt;string:planner_arguments&gt;,
    "planner_version"   : &lt;string:planner_version&gt;,
    "user"              : &lt;string:user&gt;,
    "grid_dn"           : &lt;string:grid_dn&gt;,
    "dax_label"         : &lt;string:dax_label&gt;,
    "dax_version"       : &lt;string:dax_version&gt;,
    "dax_file"          : &lt;string:dax_file&gt;,
    "dag_file_name"     : &lt;string:dag_file_name&gt;,
    "timestamp"         : &lt;int:timestamp&gt;,
    "_links"            : {
        "workflow_meta"  : &lt;href:workflow_meta&gt;,
        "workflow_state" : &lt;href:workflow_state&gt;,
        "job"            : &lt;href:job&gt;,
        "task"           : &lt;href:task&gt;,
        "host"           : &lt;href:host&gt;,
        "invocation"     : &lt;href:invocation&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-workflow-metadata"></a>16.4.1.3. Workflow Metadata</h4></div></div></div>
<pre class="programlisting">{
    "key"    : &lt;string:key&gt;,
    "value"  : &lt;string:value&gt;,
    "_links" : {
        "workflow" : &lt;href:workflow&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-workflow-files"></a>16.4.1.4. Workflow Files</h4></div></div></div>
<pre class="programlisting">{
    "wf_id"  : &lt;int:wf_id&gt;,
    "lfn_id" : &lt;string:lfn_id&gt;,
    "lfn"    : &lt;string:lfn&gt;,
    "pfns"   : [
         {
            "pfn_id" : &lt;int:pfn_id&gt;,
            "pfn"    : &lt;string:pfn&gt;,
            "site"   : &lt;string:site&gt;
         }
    ],
    "meta" : [
         {
            "meta_id" : &lt;int:meta_id&gt;,
            "key"     : &lt;string:key&gt;,
            "value"   : &lt;string:value&gt;
         }
    ],
    "_links"      : {
        "workflow" : &lt;href:workflow&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-workflow-state"></a>16.4.1.5. Workflow State</h4></div></div></div>
<pre class="programlisting">{
    "wf_id"         : int:wf_id,
    "state"         : &lt;string:state&gt;,
    "status"        : &lt;int:status&gt;,
    "restart_count" : &lt;int:restart_count&gt;,
    "timestamp"     : &lt;datetime:timestamp&gt;,
    "_links"        : {
        "workflow" : "&lt;href:workflow&gt;"
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-job"></a>16.4.1.6. Job</h4></div></div></div>
<pre class="programlisting">{
    "job_id"      : &lt;int: job_id&gt;,
    "exec_job_id" : &lt;string: exec_job_id&gt;,
    "submit_file" : &lt;string: submit_file&gt;,
    "type_desc"   : &lt;string: type_desc&gt;,
    "max_retries" : &lt;int: max_retries&gt;,
    "clustered"   : &lt;bool: clustered&gt;,
    "task_count"  : &lt;int: task_count&gt;,
    "executable"  : &lt;string: executable&gt;,
    "argv"        : &lt;string: argv&gt;,
    "task_count"  : &lt;int:task_count&gt;,
    "_links"      : {
        "workflow"     : &lt;href:workflow&gt;,
        "task"         : &lt;href:task&gt;,
        "job_instance" : &lt;href:job_instance&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-host"></a>16.4.1.7. Host</h4></div></div></div>
<pre class="programlisting">{
    "host_id"      : &lt;int:host_id&gt;,
    "site_name"    : &lt;string:site_name&gt;,
    "hostname"     : &lt;string:hostname&gt;,
    "ip"           : &lt;string:ip&gt;,
    "uname"        : &lt;string:uname&gt;,
    "total_memory" : &lt;string:total_memory&gt;,
    "_links"       : {
        "workflow" : &lt;href:workflow&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-job-state"></a>16.4.1.8. Job State</h4></div></div></div>
<pre class="programlisting">{
    "job_instance_id"     : &lt;int:job_instance_id&gt;,
    "state"               : &lt;string:state&gt;,
    "jobstate_submit_seq" : &lt;int:jobstate_submit_seq&gt;,
    "timestamp"           : &lt;int:timestamp&gt;,
    "_links"              : {
        "job_instance" : "href:job_instance"
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-task"></a>16.4.1.9. Task</h4></div></div></div>
<pre class="programlisting">{
    "task_id"        : &lt;int:task_id&gt;,
    "abs_task_id"    : &lt;string:abs_task_id&gt;,
    "type_desc"      : &lt;string: type_desc&gt;,
    "transformation" : &lt;string:transformation&gt;,
    "argv"           : &lt;string:argv&gt;,
    "_links"         : {
        "workflow"  : &lt;href:workflow&gt;,
        "job"       : &lt;href:job&gt;,
        "task_meta" : &lt;href:task_meta&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-task-metadata"></a>16.4.1.10. Task Metadata</h4></div></div></div>
<pre class="programlisting">{
    "key"    : &lt;string:key&gt;,
    "value"  : &lt;string:value&gt;,
    "_links" : {
        "task" : &lt;href:task&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-job-instance"></a>16.4.1.11. Job Instance</h4></div></div></div>
<pre class="programlisting">{
    "job_instance_id"   : &lt;int:job_instance_id&gt;,
    "host_id"           : &lt;int:host_id&gt;,
    "job_submit_seq"    : &lt;int:job_submit_seq&gt;,
    "sched_id"          : &lt;string:sched_id&gt;,
    "site_name"         : &lt;string:site_name&gt;,
    "user"              : &lt;string:user&gt;,
    "work_dir"          : &lt;string:work_dir&gt;,
    "cluster_start"     : &lt;int:cluster_start&gt;,
    "cluster_duration"  : &lt;int:cluster_duration&gt;,
    "local_duration"    : &lt;int:local_duration&gt;,
    "subwf_id"          : &lt;int:subwf_id&gt;,
    "stdout_text"       : &lt;string:stdout_text&gt;,
    "stderr_text"       : &lt;string:stderr_text&gt;,
    "stdin_file"        : &lt;string:stdin_file&gt;,
    "stdout_file"       : &lt;string:stdout_file&gt;,
    "stderr_file"       : &lt;string:stderr_file&gt;,
    "multiplier_factor" : &lt;int:multiplier_factor&gt;,
    "exitcode"          : &lt;int:exitcode&gt;,
    "_links"            : {
        "job_state"  : &lt;href:job_state&gt;,
        "host"       : &lt;href:host&gt;,
        "invocation" : &lt;href:invocation&gt;,
        "job"        : &lt;href:job&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="resource-invocation"></a>16.4.1.12. Invocation</h4></div></div></div>
<pre class="programlisting">{
    "invocation_id"   : &lt;int:invocation_id&gt;,
    "job_instance_id" : &lt;int:job_instance_id&gt;,
    "abs_task_id"     : &lt;string:abs_task_id&gt;,
    "task_submit_seq" : &lt;int:task_submit_seq&gt;,
    "start_time"      : &lt;int:start_time&gt;,
    "remote_duration" : &lt;int:remote_duration&gt;,
    "remote_cpu_time" : &lt;int:remote_cpu_time&gt;,
    "exitcode"        : &lt;int:exitcode&gt;,
    "transformation"  : &lt;string:transformation&gt;,
    "executable"      : &lt;string:executable&gt;,
    "argv"            : &lt;string:argv&gt;,
    "_links"          : {
        "workflow"     : &lt;href:workflow&gt;,
        "job_instance" : &lt;href:job_instance&gt;
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10055"></a>16.4.1.13. RC LFN</h4></div></div></div>
<pre class="programlisting">{
    "lfn_id" : &lt;int:pfn_id&gt;,
    "lfn"    : &lt;string:pfn&gt;
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10059"></a>16.4.1.14. RC PFN</h4></div></div></div>
<pre class="programlisting">{
    "pfn_id" : &lt;int:pfn_id&gt;,
    "pfn"    : &lt;string:pfn&gt;,
    "site"   : &lt;string:site&gt;
}</pre>
<div class="section">
<div class="titlepage"><div><div><h5 class="title">
<a name="idm10063"></a>16.4.1.14.1. RC Metadata</h5></div></div></div>
<pre class="programlisting">{
    "meta_id" : &lt;int:meta_id&gt;,
    "key"     : &lt;string:key&gt;,
    "value"   : &lt;string:value&gt;
}</pre>
</div>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="section-endpoints"></a>16.4.2. Endpoints</h3></div></div></div>
<p>All URIs are prefixed by<span class="bold"><strong>/api/v1/user/&lt;string:user&gt;</strong></span>.</p>
<p>All endpoints return response with content-type as
      application/json.</p>
<p>All endpoints support <span class="bold"><strong>`pretty-print`</strong></span> query argument, to return a
      formatted JSON response.</p>
<p>All endpoints return status code <span class="bold"><strong>401
      </strong></span> for<span class="bold"><strong>Authentication
      failure</strong></span>.</p>
<p>All endpoints return status code <span class="bold"><strong>403
      </strong></span> for<span class="bold"><strong>Authorization
      failure</strong></span>.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10080"></a>16.4.2.1. GET /root OR POST /root/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-root-workflow" title="16.4.1.1. Root Workflow">Root Workflow</a> resource.</p>
<div class="table">
<a name="idm10085"></a><p class="title"><b>Table 16.5. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10107"></a><p class="title"><b>Table 16.6. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflows found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10123"></a>16.4.2.2. GET /root/&lt;m_wf_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-root-workflow" title="16.4.1.1. Root Workflow">Root
        Workflow</a> resource identified by m_wf_id.</p>
<div class="table">
<a name="idm10128"></a><p class="title"><b>Table 16.7. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10141"></a>16.4.2.3. GET /root/&lt;m_wf_id&gt;/workflow OR POST
        /root/&lt;m_wf_id&gt;/workflow/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-workflow" title="16.4.1.2. Workflow">Workflow</a> resource.</p>
<div class="table">
<a name="idm10146"></a><p class="title"><b>Table 16.8. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10168"></a><p class="title"><b>Table 16.9. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflows found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10184"></a>16.4.2.4. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-workflow" title="16.4.1.2. Workflow">Workflow</a>
        resource identified by m_wf_id, wf_id.</p>
<div class="table">
<a name="idm10189"></a><p class="title"><b>Table 16.10. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10202"></a>16.4.2.5. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/meta OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/meta/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-workflow-metadata" title="16.4.1.3. Workflow Metadata">WorkflowMetadata</a>
        resource.</p>
<div class="table">
<a name="idm10207"></a><p class="title"><b>Table 16.11. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10229"></a><p class="title"><b>Table 16.12. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflows found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10245"></a>16.4.2.6. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/files OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/files/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-workflow-files" title="16.4.1.4. Workflow Files">WorkflowFiles</a>
        resource.</p>
<div class="table">
<a name="idm10250"></a><p class="title"><b>Table 16.13. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10272"></a><p class="title"><b>Table 16.14. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflows found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10288"></a>16.4.2.7. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/state[;recent=true] OR
        POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/state[;recent=true]/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-workflow-state" title="16.4.1.5. Workflow State">Workflow State</a>
        resource.</p>
<div class="table">
<a name="idm10293"></a><p class="title"><b>Table 16.15. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
<tr>
                <td>recent</td>

                <td>Get most recent results. See <a class="link" href="rest-api-monitoring.php#recent" title="16.4.3.3. Recent">Recent</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10319"></a><p class="title"><b>Table 16.16. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflow-state found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10335"></a>16.4.2.8. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/host OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/host/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-host" title="16.4.1.7. Host">Host</a> resource.</p>
<div class="table">
<a name="idm10340"></a><p class="title"><b>Table 16.17. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10362"></a><p class="title"><b>Table 16.18. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no hosts found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10378"></a>16.4.2.9. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/host/&lt;host_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-host" title="16.4.1.7. Host">Host</a> resource
        identified by m_wf_id, wf_id, host_id.</p>
<div class="table">
<a name="idm10383"></a><p class="title"><b>Table 16.19. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10396"></a>16.4.2.10. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/task OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/task/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-task" title="16.4.1.9. Task">Task</a> resource.</p>
<div class="table">
<a name="idm10401"></a><p class="title"><b>Table 16.20. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10423"></a><p class="title"><b>Table 16.21. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no tasks found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10439"></a>16.4.2.11. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/task/&lt;task_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-task" title="16.4.1.9. Task">Task</a> resource
        identified by m_wf_id, wf_id, task_id.</p>
<div class="table">
<a name="idm10444"></a><p class="title"><b>Table 16.22. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10457"></a>16.4.2.12. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/task/&lt;task_id&gt;/meta
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/task/&lt;task_id&gt;/meta/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-task-metadata" title="16.4.1.10. Task Metadata">TaskMetadata</a> resource.</p>
<div class="table">
<a name="idm10462"></a><p class="title"><b>Table 16.23. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10484"></a><p class="title"><b>Table 16.24. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no workflows found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10500"></a>16.4.2.13. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/invocation OR
        POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/invocation/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-invocation" title="16.4.1.12. Invocation">Invocation</a> resource.</p>
<div class="table">
<a name="idm10505"></a><p class="title"><b>Table 16.25. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10527"></a><p class="title"><b>Table 16.26. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no invocations found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10543"></a>16.4.2.14. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/invocation/&lt;invocation_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-invocation" title="16.4.1.12. Invocation">Invocation</a>
        resource identified by m_wf_id, wf_id, invocation_id.</p>
<div class="table">
<a name="idm10548"></a><p class="title"><b>Table 16.27. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10561"></a>16.4.2.15. GET /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-job" title="16.4.1.6. Job">Job</a> resource.</p>
<div class="table">
<a name="idm10566"></a><p class="title"><b>Table 16.28. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10588"></a><p class="title"><b>Table 16.29. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no jobs found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10604"></a>16.4.2.16. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-job" title="16.4.1.6. Job">Job</a> resource
        identified by m_wf_id, wf_id, job_id.</p>
<div class="table">
<a name="idm10609"></a><p class="title"><b>Table 16.30. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not foun</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10622"></a>16.4.2.17. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/task
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/task/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-task" title="16.4.1.9. Task">Task</a> resource.</p>
<div class="table">
<a name="idm10627"></a><p class="title"><b>Table 16.31. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10649"></a><p class="title"><b>Table 16.32. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no tasks found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10665"></a>16.4.2.18. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance[;recent=true]
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance[;recent=true]/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-job-instance" title="16.4.1.11. Job Instance">Job Instance</a> resource.</p>
<div class="table">
<a name="idm10670"></a><p class="title"><b>Table 16.33. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
<tr>
                <td>recent</td>

                <td>Get most recent results. See <a class="link" href="rest-api-monitoring.php#recent" title="16.4.3.3. Recent">Recent</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10696"></a><p class="title"><b>Table 16.34. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no job-instances found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10712"></a>16.4.2.19. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance/&lt;job_instance_id&gt;</h4></div></div></div>
<p>Returns a <a class="link" href="rest-api-monitoring.php#resource-job-instance" title="16.4.1.11. Job Instance">Job
        Instance</a> resource identified by m_wf_id, wf_id, job_id,
        job_instance_id.</p>
<div class="table">
<a name="idm10717"></a><p class="title"><b>Table 16.35. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>404</td>

                <td>Not found</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10730"></a>16.4.2.20. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance/&lt;job_instance_id&gt;/state[;recent=true]
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance/&lt;job_instance_id&gt;/state[;recent=true]/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-job-state" title="16.4.1.8. Job State">Job State</a> resource.</p>
<div class="table">
<a name="idm10735"></a><p class="title"><b>Table 16.36. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
<tr>
                <td>recent</td>

                <td>Get most recent results. See <a class="link" href="rest-api-monitoring.php#recent" title="16.4.3.3. Recent">Recent</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10761"></a><p class="title"><b>Table 16.37. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no job-state found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10777"></a>16.4.2.21. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance/&lt;job_instance_id&gt;/invocation
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;job_id&gt;/job-instance/&lt;job_instance_id&gt;/invocation/query</h4></div></div></div>
<p>Returns a collection of the <a class="link" href="rest-api-monitoring.php#resource-invocation" title="16.4.1.12. Invocation">Invocation</a> resource.</p>
<div class="table">
<a name="idm10782"></a><p class="title"><b>Table 16.38. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10804"></a><p class="title"><b>Table 16.39. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no invocations found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10820"></a>16.4.2.22. POST /batch</h4></div></div></div>
<p>Returns an array of responses; one entry for each
        request.</p>
<p><span class="bold"><strong>Batch Request</strong></span></p>
<pre class="programlisting">[
    {
        "method" : &lt;string:method&gt;,
        "path"   : &lt;string:path&gt;,
        "body"   : &lt;dict:body&gt;
    },
    {
        "method" : &lt;string:method&gt;,
        "path"   : &lt;string:path&gt;,
        "body"   : &lt;dict:body&gt;
    }
]</pre>
<p><span class="bold"><strong>Batch Response</strong></span></p>
<pre class="programlisting">[
    {
        "status"   : &lt;int:status_code&gt;,
        "response" : &lt;string:response&gt;
    },
    {
        "status"   : &lt;int:status_code&gt;,
        "response" : &lt;string:response&gt;
    }
]</pre>
<div class="table">
<a name="idm10830"></a><p class="title"><b>Table 16.40. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody><tr>
                <td>207</td>

                <td>Multi status</td>
              </tr></tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10840"></a>16.4.2.23. GET
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;[running|successful|failed|failing]&gt;
        OR POST
        /root/&lt;m_wf_id&gt;/workflow/&lt;wf_id&gt;/job/&lt;[running|successful|failed|failing]&gt;/query</h4></div></div></div>
<p>Returns a collection of running, successful, failed, or failing
        <a class="link" href="rest-api-monitoring.php#resource-job" title="16.4.1.6. Job">Job</a> resource.</p>
<p><span class="bold"><strong>Note:</strong></span> Queries, Sorting can
        include fields from Job and JobInstance resource.</p>
<div class="table">
<a name="idm10847"></a><p class="title"><b>Table 16.41. Options</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Argument</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>start-index</td>

                <td>Return results starting from record &lt;start-index&gt; (0
                indexed)</td>
              </tr>
<tr>
                <td>max-results</td>

                <td>Return a maximum of &lt;max-results&gt; records</td>
              </tr>
<tr>
                <td>query</td>

                <td>Search criteria. See <a class="link" href="rest-api-monitoring.php#querying" title="16.4.3. Querying">Querying</a>.</td>
              </tr>
<tr>
                <td>order</td>

                <td>Order criteria. See <a class="link" href="rest-api-monitoring.php#ordering" title="16.4.4. Ordering">Ordering</a>.</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<div class="table">
<a name="idm10869"></a><p class="title"><b>Table 16.42. Returns</b></p>
<div class="table-contents"><table frame="box" rules="all">
<thead><tr align="center">
                <th>Status Code</th>

                <th>Description</th>
              </tr></thead>
<tbody>
<tr>
                <td>200</td>

                <td>OK</td>
              </tr>
<tr>
                <td>204</td>

                <td>No content; when no jobs found.</td>
              </tr>
<tr>
                <td>400</td>

                <td>Bad request</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="querying"></a>16.4.3. Querying</h3></div></div></div>
<p>Querying is supported through query string argument <span class="bold"><strong>`query`</strong></span>.</p>
<p>Querying is supported only on endpoints returning
      collections.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10890"></a>16.4.3.1. Syntax</h4></div></div></div>
<p>Query clauses are rudimentary and must follow some rules.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>Supported comparators are =, !=, &lt;, &lt;=, &gt;, &gt;=,
            LIKE, IN.</p></li>
<li class="listitem"><p>Supported operators are AND, OR.</p></li>
<li class="listitem"><p>Comparision clauses must have the form &lt;FIELDNAME&gt;
            SPACE &lt;COMPARATOR&gt; SPACE &lt;STRING LITERAL OR INTEGER
            LITERAL OR FLOAT LITERAL&gt;</p></li>
<li class="listitem"><p>&lt;FIELDNAME&gt; must be prefixed with resource query
            prefix Example: <span class="bold"><strong><span class="bold"><strong>r.</strong></span>wf_id</strong></span> is valid, but <span class="bold"><strong>wf_id</strong></span> is not.</p></li>
<li class="listitem"><p>&lt;FIELDNAMES&gt; which can be used in a query caluse
            depends on the resource being queries. Example: For endpoint
            /api/v1/user/user-a/root/1/<span class="bold"><strong>workflow</strong></span>/1/<span class="bold"><strong>job</strong></span>/2/<span class="bold"><strong>state</strong></span> query clause can only contain fields
            from the <a class="link" href="rest-api-monitoring.php#resource-job-state" title="16.4.1.8. Job State">Job State</a>
            resource. </p></li>
<li class="listitem">
<p>Only exceptions for the previous rules are</p>
<p>Querying Root Workflow where fields from both <a class="link" href="rest-api-monitoring.php#resource-root-workflow" title="16.4.1.1. Root Workflow">Root Workflow</a> and <a class="link" href="rest-api-monitoring.php#resource-workflow-state" title="16.4.1.5. Workflow State">Workflow State</a> can be
            included.</p>
<p>Querying the /api/v1/user/user-a/root/1/workflow/1/files
            where fields from RC LFN, RC PFN, an RC Metadata can be
            included.</p>
<p>Views endpoint
            /api/v1/user/user-a/root/1/workflow/1/job/&lt;[running|successful|failed|failing]&gt;
            where fields from <a class="link" href="rest-api-monitoring.php#resource-job" title="16.4.1.6. Job">Job</a> and
            <a class="link" href="rest-api-monitoring.php#resource-job-instance" title="16.4.1.11. Job Instance">JobInstance</a> resource
            can be included.</p>
</li>
</ul></div>
<p><span class="bold"><strong>Example</strong></span></p>
<pre class="programlisting"><span class="bold"><strong><span class="bold"><strong>For Root Workflow https://www.domain.com/api/v1/user/user-a/root?query&lt;QUERY&gt;

Where QUERY can be( r.wf_id &gt;= 5 AND r.planner_version LIKE '4.5%' ) OR ( r.wf_id IN ( 1, 2 ) )
</strong></span></strong></span></pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm10926"></a>16.4.3.2. Resource - Query Prefix</h4></div></div></div>
<div class="table">
<a name="idm10929"></a><p class="title"><b>Table 16.43. Query Prefix</b></p>
<div class="table-contents"><table frame="box" rules="all">Query Prefix<thead><tr align="center">
                <th>Resource</th>

                <th>Query Prefix</th>

                <th>Example</th>
              </tr></thead>
<tbody>
<tr>
                <td><span class="bold"><strong>Root Workflow</strong></span></td>

                <td>r</td>

                <td>r.wf_id</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Workflow</strong></span></td>

                <td>w</td>

                <td>w.wf_uuid</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Workflow Metadata</strong></span></td>

                <td>wm</td>

                <td>wm.key</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Workflow Files</strong></span></td>

                <td>wf</td>

                <td>wf.lfn</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Workflow State</strong></span></td>

                <td>ws</td>

                <td>ws.state</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Job</strong></span></td>

                <td>j</td>

                <td>j.type_desc</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Host</strong></span></td>

                <td>h</td>

                <td>h.site</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Job State</strong></span></td>

                <td>js</td>

                <td>js.state</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Task</strong></span></td>

                <td>t</td>

                <td>t.abs_task_id</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Task Metadata</strong></span></td>

                <td>tm</td>

                <td>tm.value</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Job Instance</strong></span></td>

                <td>ji</td>

                <td>ji.exitcode</td>
              </tr>
<tr>
                <td><span class="bold"><strong>Job</strong></span></td>

                <td>i</td>

                <td>i.argv</td>
              </tr>
<tr>
                <td><span class="bold"><strong>RC LFN</strong></span></td>

                <td>l</td>

                <td>l.lfn</td>
              </tr>
<tr>
                <td><span class="bold"><strong>RC PFN</strong></span></td>

                <td>p</td>

                <td>p.pfn</td>
              </tr>
<tr>
                <td><span class="bold"><strong>RC Metadata</strong></span></td>

                <td>rm</td>

                <td>rm.key</td>
              </tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="recent"></a>16.4.3.3. Recent</h4></div></div></div>
<p>Workflow State, Job State, and Job Instance resources have
        historical records.</p>
<p>For use cases where developers need to get the most recent
        record, we set <span class="bold"><strong>path</strong></span> argument
        <span class="bold"><strong>`recent` </strong></span> to true. Recent argument is
        always true when requesting for root-workflow's resource.</p>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="ordering"></a>16.4.4. Ordering</h3></div></div></div>
<p>Ordering is supported through query string argument <span class="bold"><strong>`order`</strong></span>.</p>
<p>Ordering is supported only on endpoints returning
      collections.</p>
<p>Order clause can only contain fields which are part of the
      resource being returned. Fields may or may not be prefixed by the
      Resource Query Prefix</p>
<p><span class="bold"><strong>Example:</strong></span> Order clause for an
      endpoint returning a <a class="link" href="rest-api-monitoring.php#resource-workflow" title="16.4.1.2. Workflow">Workflow</a>
      resource can only contain fields that are part of the <a class="link" href="rest-api-monitoring.php#resource-workflow" title="16.4.1.2. Workflow">Workflow</a> resource.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11029"></a>16.4.4.1. Syntax</h4></div></div></div>
<p>Order clause consists of one or more field names optionally
        followed by order direction (ASC or DESC), separated by commas.</p>
<pre class="programlisting"><span class="bold"><strong><span class="bold"><strong>https://www.domain.com/api/v1/user/user-a/root?order=r.submit_hostname ASC, wf_id DESC
</strong></span></strong></span></pre>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm11036"></a>16.4.5. Examples</h3></div></div></div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11038"></a>16.4.5.1. Resource - Single</h4></div></div></div>
<pre class="programlisting"><span class="bold"><strong>$ curl --request GET \
       --user user-a:user-a-password \
       https://www.domain.com/api/v1/user/user-a/root/1/workflow/1?pretty-print=true
                    </strong></span>

HTTP/1.1 200 OK

{
    "wf_id"             : 1,
    "root_wf_id"        : 1,
    "parent_wf_id"      : null,
    "wf_uuid"           : "7193de8c-a28d-4eca-b576-1b1c3c4f668b",
    "submit_hostname"   : "isis.isi.edu",
    "submit_dir"        : "/home/tutorial/submit/",
    "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
    "planner_version"   : "4.5.0dev",
    "user"              : "user-a",
    "grid_dn"           : null,
    "dax_label"         : "hello_world",
    "dax_version"       : "3.5",
    "dax_file"          : "/home/tutorial/hello-world.xml",
    "dag_file_name"     : "hello_world-0.dag",
    "timestamp"         : 1421432530.0,
    "_links"            : {
        "workflow_state" : "/user/user-a/root/1/workflow/1/state",
        "job"            : "/user/user-a/root/1/workflow/1/job",
        "task"           : "/user/user-a/root/1/workflow/1/task",
        "host"           : "/user/user-a/root/1/workflow/1/host",
        "invocation"     : "/user/user-a/root/1/workflow/1/job"
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11042"></a>16.4.5.2. Resource - Collection</h4></div></div></div>
<pre class="programlisting"><span class="bold"><strong>$ curl --request POST \
       --user user-a:user-a-password \
       --data 'pretty-print=true' \
       https://www.domain.com/api/v1/user/user-a/root/1/workflow/query
                    </strong></span>
HTTP/1.1 200 OK

{
    "records" : [
        {
            "wf_id"             : 1,
            "root_wf_id"        : 1,
            "parent_wf_id"      : null,
            "wf_uuid"           : "7193de8c-a28d-4eca-b576-1b1c3c4f668b",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150116T102210-0800",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags  --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1421432530.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/1/workflow/1/state",
                "job"            : "/user/user-a/root/1/workflow/1/job",
                "task"           : "/user/user-a/root/1/workflow/1/task",
                "host"           : "/user/user-a/root/1/workflow/1/host",
                "invocation"     : "/user/user-a/root/1/workflow/1/job"
            }
        },
        {
            "wf_id"             : 2,
            "root_wf_id"        : 2,
            "parent_wf_id"      : null,
            "wf_uuid"           : "41920a57-7882-4990-854e-658b7a797745",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150330T165231-0700",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1427759551.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/2/workflow/1/state",
                "job"            : "/user/user-a/root/2/workflow/1/job",
                "task"           : "/user/user-a/root/2/workflow/1/task",
                "host"           : "/user/user-a/root/2/workflow/1/host",
                "invocation"     : "/user/user-a/root/2/workflow/1/job"
            }
        },
        {
            "wf_id"             : 3,
            "root_wf_id"        : 3,
            "parent_wf_id"      : null,
            "wf_uuid"           : "fce67b41-df67-4b3c-8fa4-d77e6e2b9769",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150330T170228-0700",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1427760148.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/3/workflow/1/state",
                "job"            : "/user/user-a/root/3/workflow/1/job",
                "task"           : "/user/user-a/root/3/workflow/1/task",
                "host"           : "/user/user-a/root/3/workflow/1/host",
                "invocation"     : "/user/user-a/root/3/workflow/1/job"
            }

        }
    ],
    "_meta"   : {
        "records_total"    : 3,
        "records_filtered" : 3
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11046"></a>16.4.5.3. Querying</h4></div></div></div>
<pre class="programlisting"><span class="bold"><strong>$ curl --request GET \
       --get \
       --data-urlencode "pretty-print=true" \
       --data-urlencode "query=w.wf_uuid = '41920a57-7882-4990-854e-658b7a797745'" \
       --user user-a:user-a-password \
       https://www.domain.com/api/v1/user/user-a/root/1/workflow
                    </strong></span>
HTTP/1.1 200 OK

{
    "records" : [
        {
            "wf_id"             : 2,
            "root_wf_id"        : 2,
            "parent_wf_id"      : null,
            "wf_uuid"           : "41920a57-7882-4990-854e-658b7a797745",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150330T165231-0700",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1427759551.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/2/workflow/1/state",
                "job"            : "/user/user-a/root/2/workflow/1/job",
                "task"           : "/user/user-a/root/2/workflow/1/task",
                "host"           : "/user/user-a/root/2/workflow/1/host",
                "invocation"     : "/user/user-a/root/2/workflow/1/job"
            }
        }
    ],
    "_meta"   : {
        "records_total"    : 3,
        "records_filtered" : 1
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11050"></a>16.4.5.4. Ordering</h4></div></div></div>
<pre class="programlisting"><span class="bold"><strong>$ curl --request GET \
       --user user-a:user-a-password \
       https://www.domain.com/api/v1/user/user-a/root/1/workflow?pretty-print=true&amp;order=wf_id desc
                    </strong></span>
HTTP/1.1 200 OK

{
    "records" : [
        {
            "wf_id"             : 3,
            "root_wf_id"        : 3,
            "parent_wf_id"      : null,
            "wf_uuid"           : "fce67b41-df67-4b3c-8fa4-d77e6e2b9769",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150330T170228-0700",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1427760148.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/3/workflow/1/state",
                "job"            : "/user/user-a/root/3/workflow/1/job",
                "task"           : "/user/user-a/root/3/workflow/1/task",
                "host"           : "/user/user-a/root/3/workflow/1/host",
                "invocation"     : "/user/user-a/root/3/workflow/1/job"
            }
        },
        {
            "wf_id"             : 2,
            "root_wf_id"        : 2,
            "parent_wf_id"      : null,
            "wf_uuid"           : "41920a57-7882-4990-854e-658b7a797745",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150330T165231-0700",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1427759551.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/2/workflow/1/state",
                "job"            : "/user/user-a/root/2/workflow/1/job",
                "task"           : "/user/user-a/root/2/workflow/1/task",
                "host"           : "/user/user-a/root/2/workflow/1/host",
                "invocation"     : "/user/user-a/root/2/workflow/1/job"
            }
        },
        {
            "wf_id"             : 1,
            "root_wf_id"        : 1,
            "parent_wf_id"      : null,
            "wf_uuid"           : "7193de8c-a28d-4eca-b576-1b1c3c4f668b",
            "submit_hostname"   : "isis.isi.edu",
            "submit_dir"        : "/home/tutorial/dags/20150116T102210-0800",
            "planner_arguments" : "--conf pegasusrc --sites condorpool --output-site local --dir dags  --dax dax.xml --submit",
            "planner_version"   : "4.5.0dev",
            "user"              : "user-a",
            "grid_dn"           : null,
            "dax_label"         : "hello_world",
            "dax_version"       : "3.5",
            "dax_file"          : "/home/tutorial/hello-world.xml",
            "dag_file_name"     : "hello_world-0.dag",
            "timestamp"         : 1421432530.0,
            "_links"            : {
                "workflow_state" : "/user/user-a/root/1/workflow/1/state",
                "job"            : "/user/user-a/root/1/workflow/1/job",
                "task"           : "/user/user-a/root/1/workflow/1/task",
                "host"           : "/user/user-a/root/1/workflow/1/host",
                "invocation"     : "/user/user-a/root/1/workflow/1/job"
            }
        }
    ],
    "_meta"   : {
        "records_total"    : 3,
        "records_filtered" : 3
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11055"></a>16.4.5.5. Recent</h4></div></div></div>
<pre class="programlisting"><span class="bold"><strong>$ curl --request GET \
       --user user-a:user-a-password \
       https://www.domain.com/api/v1/user/user-a/root/1/workflow/1/state;recent=true?pretty-print=true
                    </strong></span>
HTTP/1.1 200 OK

{
    "records": [
        {
            "wf_id": 1,
            "state": "WORKFLOW_TERMINATED",
            "status": 1,
            "restart_count": 3,
            "timestamp": 1421885063.0,
            "_links": {
                "workflow": "/api/v1/user/user-a/root/1/workflow/1"
            }
        }
    ],
    "_meta": {
        "records_total": 8,
        "records_filtered": 1
    }
}</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm11060"></a>16.4.5.6. Batch Request</h4></div></div></div>
<p><span class="bold"><strong>Example</strong></span></p>
<pre class="programlisting"><span class="bold"><strong>$ curl --request POST \
       --user user-a:user-a-password \
       --header "Content-Type: application/json" \
       --data '[
            {
                "path"   : "/api/v1/user/user-a/root?query=r.wf_id = 1&amp;pretty-print=True",
                "method" : "GET"
            },
            {
                "path"   : "/api/v1/user/user-a/root",
                "method" : "POST",
                "body"   : {
                    "query"        : "r.wf_id = 2",
                    "pretty-print" : "True"
                }
            }
       ]' \
       https://www.domain.com/api/v1/user/user-a/batch</strong></span>

[
    {
        "status"   : 200,
        "response" : {
            "records" : [
                {
                    "wf_id"             : 1,
                    "wf_uuid"           : "7193de8c-a28d-4eca-b576-1b1c3c4f668b",
                    ..
                    "_links"            : {
                        "workflow" : "/api/v1/user/user-a/root/1/workflow"
                    }
                }
            ],
            "_meta"   : {
                "records_total"    : 5,
                "records_filtered" : 1
            }
        }
    },
    {
        "status"   : 200,
        "response" : {
            "records" : [
                {
                    "wf_id"             : 2,
                    "wf_uuid"           : "41920a57-7882-4990-854e-658b7a797745",
                    ..
                    "_links"            : {
                        "workflow" : "/api/v1/user/user-a/root/2/workflow"
                    }
                }
            ],
            "_meta"   : {
                "records_total"    : 5,
                "records_filtered" : 1
            }
        }
    }
]

</pre>
</div>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="dax_no_api.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="api.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">16.3. DAX Generator without a Pegasus DAX API </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 17. Command Line Tools</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
