<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("14.3. Kickstart XML Record");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="submit_directory.php">Submit Directory Details</a></span> &gt; <span class="breadcrumb-node">Kickstart XML Record</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="kickstart_xml_record"></a>14.3. Kickstart XML Record</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="kickstart_xml_record.php#idm9026">14.3.1. Reading a Kickstart Output File</a></span></dt></dl></div>
<p>Kickstart is a light weight C executable that is shipped with the
    pegasus worker package. All jobs are launced via Kickstart on the remote
    end, unless explicitly disabled at the time of running
    pegasus-plan.</p>
<p>Kickstart does not work with:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Condor Standard Universe Jobs</p></li>
<li class="listitem"><p>MPI Jobs</p></li>
</ol></div>
<p>Pegasus automatically disables kickstart for the above jobs.</p>
<p>Kickstart captures useful runtime provenance information about the
    job launched by it on the remote note, and puts in an XML record that it
    writes to its own stdout. The stdout appears in the workflow submit
    directory as &lt;job&gt;.out.00n . The following information is captured
    by kickstart and logged:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>The exitcode with which the job it launched exited.</p></li>
<li class="listitem"><p>The duration of the job</p></li>
<li class="listitem"><p>The start time for the job</p></li>
<li class="listitem"><p>The node on which the job ran</p></li>
<li class="listitem"><p>The stdout and stderr of the job</p></li>
<li class="listitem"><p>The arguments with which it launched the job</p></li>
<li class="listitem"><p>The environment that was set for the job before it was
        launched.</p></li>
<li class="listitem"><p>The machine information about the node that the job ran
        on</p></li>
</ol></div>
<p>Amongst the above information, the dagman.out file gives a coarser
    grained estimate of the job duration and start time.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm9026"></a>14.3.1. Reading a Kickstart Output File</h3></div></div></div>
<p>The kickstart file below has the following fields
      highlighted:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>The host on which the job executed and the ipaddress of that
          host</p></li>
<li class="listitem"><p>The duration and start time of the job. The time here is in
          reference to the clock on the remote node where the job is
          executed.</p></li>
<li class="listitem"><p>The exitcode with which the job executed</p></li>
<li class="listitem"><p>The arguments with which the job was launched.</p></li>
<li class="listitem"><p>The directory in which the job executed on the remote
          site</p></li>
<li class="listitem"><p>The stdout of the job</p></li>
<li class="listitem"><p>The stderr of the job</p></li>
<li class="listitem"><p>The environment of the job</p></li>
</ol></div>
<pre class="programlisting">&lt;?xml version="1.0" encoding="ISO-8859-1"?&gt;

&lt;invocation xmlns="http://pegasus.isi.edu/schema/invocation" \
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" \
       xsi:schemaLocation="http://pegasus.isi.edu/schema/invocation http://pegasus.isi.edu/schema/iv-2.0.xsd" \
       version="2.0" start="2009-01-30T19:17:41.157-06:00" duration="0.321" transformation="pegasus::dirmanager"\
      derivation="pegasus::dirmanager:1.0" resource="cobalt" wf-label="scb" \
      wf-stamp="2009-01-30T17:12:55-08:00"<span class="bold"><strong> hostaddr="141.142.30.219" hostname="co-login.ncsa.uiuc.edu"</strong></span>\
      pid="27714" uid="29548" user="vahi" gid="13872" group="bvr" umask="0022"&gt;

<span class="bold"><strong>&lt;mainjob start="2009-01-30T19:17:41.426-06:00" duration="0.052" pid="27783"&gt;
</strong></span>
&lt;usage utime="0.036" stime="0.004" minflt="739" majflt="0" nswap="0" nsignals="0" nvcsw="36" nivcsw="3"/&gt;

<span class="bold"><strong>&lt;status raw="0"&gt;&lt;regular exitcode="0"/&gt;&lt;/status&gt;</strong></span>

&lt;statcall error="0"&gt;
&lt;!-- deferred flag: 0 --&gt;
&lt;file name="/u/ac/vahi/SOFTWARE/pegasus/default/bin/dirmanager"&gt;23212F7573722F62696E2F656E762070&lt;/file&gt;
&lt;statinfo mode="0100755" size="8202" inode="85904615883" nlink="1" blksize="16384" \
    blocks="24" mtime="2008-09-22T18:52:37-05:00" atime="2009-01-30T14:54:18-06:00" \
    ctime="2009-01-13T19:09:47-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;/statcall&gt;

<span class="bold"><strong>&lt;argument-vector&gt;
&lt;arg nr="1"&gt;--create&lt;/arg&gt;
&lt;arg nr="2"&gt;--dir&lt;/arg&gt;
&lt;arg nr="3"&gt;/u/ac/vahi/globus-test/EXEC/vahi/pegasus/scb/run0001&lt;/arg&gt;
&lt;/argument-vector&gt;</strong></span>

&lt;/mainjob&gt;<span class="bold"><strong>

&lt;cwd&gt;/u/ac/vahi/globus-test/EXEC&lt;/cwd&gt;</strong></span>

&lt;usage utime="0.012" stime="0.208" minflt="4232" majflt="0" nswap="0" nsignals="0" nvcsw="15" nivcsw="74"/&gt;
&lt;machine page-size="16384" provider="LINUX"&gt;
&lt;stamp&gt;2009-01-30T19:17:41.157-06:00&lt;/stamp&gt;
&lt;uname system="linux" nodename="co-login" release="2.6.16.54-0.2.5-default" machine="ia64"&gt;#1 SMP Mon Jan 21\
         13:29:51 UTC 2008&lt;/uname&gt;
&lt;ram total="148299268096" free="123371929600" shared="0" buffer="2801664"/&gt;
&lt;swap total="1179656486912" free="1179656486912"/&gt;
&lt;boot idle="1315786.920"&gt;2009-01-15T10:19:50.283-06:00&lt;/boot&gt;
&lt;cpu count="32" speed="1600" vendor=""&gt;&lt;/cpu&gt;
&lt;load min1="3.50" min5="3.50" min15="2.60"/&gt;
&lt;proc total="841" running="5" sleeping="828" stopped="5" vmsize="10025418752" rss="2524299264"/&gt;
&lt;task total="1125" running="6" sleeping="1114" stopped="5"/&gt;
&lt;/machine&gt;
&lt;statcall error="0" id="stdin"&gt;
&lt;!-- deferred flag: 0 --&gt;
&lt;file name="/dev/null"/&gt;
&lt;statinfo mode="020666" size="0" inode="68697" nlink="1" blksize="16384" blocks="0" \
     mtime="2007-05-04T05:54:02-05:00" atime="2007-05-04T05:54:02-05:00" \
   ctime="2009-01-15T10:21:54-06:00" uid="0" user="root" gid="0" group="root"/&gt;
&lt;/statcall&gt;

<span class="bold"><strong>&lt;statcall error="0" id="stdout"&gt;
&lt;temporary name="/tmp/gs.out.s9rTJL" descriptor="3"/&gt;
&lt;statinfo mode="0100600" size="29" inode="203420686" nlink="1" blksize="16384" blocks="128" \
 mtime="2009-01-30T19:17:41-06:00" atime="2009-01-30T19:17:41-06:00"\
 ctime="2009-01-30T19:17:41-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;data&gt;mkdir finished successfully.
&lt;/data&gt;
&lt;/statcall&gt;
&lt;statcall error="0" id="stderr"&gt;
&lt;temporary name="/tmp/gs.err.kobn3S" descriptor="5"/&gt;
&lt;statinfo mode="0100600" size="0" inode="203420689" nlink="1" blksize="16384" blocks="0" \
 mtime="2009-01-30T19:17:41-06:00" atime="2009-01-30T19:17:41-06:00" \
ctime="2009-01-30T19:17:41-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;/statcall&gt;
</strong></span>
&lt;statcall error="0" id="gridstart"&gt;
&lt;!-- deferred flag: 0 --&gt;
&lt;file name="/u/ac/vahi/SOFTWARE/pegasus/default/bin/kickstart"&gt;7F454C46020101000000000000000000&lt;/file&gt;
&lt;statinfo mode="0100755" size="255445" inode="85904615876" nlink="1" blksize="16384" blocks="504" \
  mtime="2009-01-30T18:06:28-06:00" atime="2009-01-30T19:17:41-06:00"\
 ctime="2009-01-30T18:06:28-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;/statcall&gt;
&lt;statcall error="0" id="logfile"&gt;
&lt;descriptor number="1"/&gt;
&lt;statinfo mode="0100600" size="0" inode="53040253" nlink="1" blksize="16384" blocks="0" \
 mtime="2009-01-30T19:17:39-06:00" atime="2009-01-30T19:17:39-06:00" \
ctime="2009-01-30T19:17:39-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;/statcall&gt;
&lt;statcall error="0" id="channel"&gt;
&lt;fifo name="/tmp/gs.app.Ien1m0" descriptor="7" count="0" rsize="0" wsize="0"/&gt;
&lt;statinfo mode="010640" size="0" inode="203420696" nlink="1" blksize="16384" blocks="0" \
  mtime="2009-01-30T19:17:41-06:00" atime="2009-01-30T19:17:41-06:00" \
ctime="2009-01-30T19:17:41-06:00" uid="29548" user="vahi" gid="13872" group="bvr"/&gt;
&lt;/statcall&gt;

<span class="bold"><strong>&lt;environment&gt;
&lt;env key="GLOBUS_GRAM_JOB_CONTACT"&gt;https://co-login.ncsa.uiuc.edu:50001/27456/1233364659/&lt;/env&gt;
&lt;env key="GLOBUS_GRAM_MYJOB_CONTACT"&gt;URLx-nexus://co-login.ncsa.uiuc.edu:50002/&lt;/env&gt;
&lt;env key="GLOBUS_LOCATION"&gt;/usr/local/prews-gram-4.0.7-r1/&lt;/env&gt;
....
&lt;/environment&gt;
</strong></span>
&lt;resource&gt;
&lt;soft id="RLIMIT_CPU"&gt;unlimited&lt;/soft&gt;
&lt;hard id="RLIMIT_CPU"&gt;unlimited&lt;/hard&gt;
&lt;soft id="RLIMIT_FSIZE"&gt;unlimited&lt;/soft&gt;
....
&lt;/resource&gt;
&lt;/invocation&gt;</pre>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="condor_dagman_file.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="submit_directory.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="jobstate_log_file.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">14.2. Condor DAGMan File </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 14.4. Jobstate.Log File</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
