<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-sc-converter");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-sc-converter</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-sc-converter"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-sc-converter — A client to convert site catalog from one format to another format.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-sc-converter_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-sc-converter</strong></span> [<span class="strong"><strong>-v</strong></span>] [<span class="strong"><strong>-V</strong></span>] [<span class="strong"><strong>-h</strong></span>] [<span class="strong"><strong>-Dproperty</strong></span>=<span class="emphasis"><em>value</em></span>…]<br>
                     [<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>fmt</em></span>] [<span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>fmt</em></span>]<br>
                     <span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…] <span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>outfile</em></span></p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-sc-converter_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-sc-converter</strong></span> program is used to convert the site catalog
from one format to another.</p>
<p>Currently, the following formats of site catalog exist.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>XML4</strong></span>
</span></dt>
<dd>
<p class="simpara">
This format is a superset of previous formats.  All information about a
site that can be described about a site can be described in this format.
In addition, the user has finer grained control over the specification
of directories and FTP servers that are accessible at the <span class="strong"><strong>head node</strong></span>
and the <span class="strong"><strong>worker node</strong></span>. The user can also specify which different file-servers for read/write operations
</p>
<p class="simpara">A sample entry in this format looks as follows</p>
<pre class="screen">&lt;site handle="osg" arch="x86" os="LINUX" osrelease="" osversion="" glibc=""&gt;
        &lt;grid  type="gt2" contact="viz-login.isi.edu/jobmanager-pbs" scheduler="PBS" jobtype="compute"/&gt;
        &lt;grid  type="gt2" contact="viz-login.isi.edu/jobmanager-fork" scheduler="Fork" jobtype="auxillary"/&gt;

        &lt;directory path="/tmp" type="local-scratch"&gt;
                &lt;file-server operation="put" url="file:///tmp"/&gt;
        &lt;/directory&gt;

        &lt;profile namespace="pegasus" key="style"&gt;condor&lt;/profile&gt;
        &lt;profile namespace="condor" key="universe"&gt;vanilla&lt;/profile&gt;
&lt;/site&gt;</pre>
<p class="simpara">This format conforms to the  XML schema found at
<a class="ulink" href="http://pegasus.isi.edu/schema/sc-4.0.xsd" target="_top">http://pegasus.isi.edu/schema/sc-4.0.xsd</a>.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>XML3</strong></span>
</span></dt>
<dd>
<p class="simpara">
This format is a superset of previous formats.  All information about a
site that can be described about a site can be described in this format.
In addition, the user has finer grained control over the specification
of directories and FTP servers that are accessible at the <span class="strong"><strong>head node</strong></span>
and the <span class="strong"><strong>worker node</strong></span>.
</p>
<p class="simpara">A sample entry in this format looks as follows</p>
<pre class="screen">&lt;site  handle="local" arch="x86" os="LINUX"&gt;
  &lt;grid  type="gt2" contact="viz-login.isi.edu/jobmanager-pbs" scheduler="PBS" jobtype="compute"/&gt;
  &lt;grid  type="gt2" contact="viz-login.isi.edu/jobmanager-fork" scheduler="Fork" jobtype="auxillary"/&gt;
  &lt;head-fs&gt;
    &lt;scratch&gt;
      &lt;shared&gt;
        &lt;file-server protocol="gsiftp" url="gsiftp://viz-login.isi.edu" mount-point="/scratch"&gt;
        &lt;/file-server&gt;
        &lt;internal-mount-point mount-point="/scratch" free-size="null" total-size="null"/&gt;
      &lt;/shared&gt;
    &lt;/scratch&gt;
    &lt;storage&gt;
      &lt;shared&gt;
        &lt;file-server protocol="gsiftp" url="gsiftp://viz-login.isi.edu" mount-point="/scratch"&gt;
        &lt;/file-server&gt;
        &lt;internal-mount-point mount-point="/scratch" free-size="null" total-size="null"/&gt;
      &lt;/shared&gt;
    &lt;/storage&gt;
  &lt;/head-fs&gt;
  &lt;replica-catalog  type="LRC" url="rlsn://smarty.isi.edu"&gt;
  &lt;/replica-catalog&gt;
  &lt;profile namespace="env" key="GLOBUS_LOCATION" &gt;/nfs/software/globus/default&lt;/profile&gt;
  &lt;profile namespace="env" key="LD_LIBRARY_PATH" &gt;/nfs/software/globus/default/lib&lt;/profile&gt;
  &lt;profile namespace="env" key="PEGASUS_HOME" &gt;/nfs/software/pegasus/default&lt;/profile&gt;
&lt;/site&gt;</pre>
<p class="simpara">This format conforms to the  XML schema found at
<a class="ulink" href="http://pegasus.isi.edu/schema/sc-3.0.xsd" target="_top">http://pegasus.isi.edu/schema/sc-3.0.xsd</a>.</p>
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-sc-converter_options"></a><h2>Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…]
, </span><span class="term">
<span class="strong"><strong>--input</strong></span> <span class="emphasis"><em>infile</em></span>[,<span class="emphasis"><em>infile</em></span>,…]
</span>
</dt>
<dd>
The comma separated list of input files that need to be converted to a
file in the format specified by <span class="strong"><strong>--oformat</strong></span> option.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>outfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--output</strong></span> <span class="emphasis"><em>outfile</em></span>
</span>
</dt>
<dd>
The output file to which the output needs to be written out to.
</dd>
</dl></div>
<div class="refsect2">
<a name="pegasus-sc-converter_other_options"></a><h3>Other Options</h3>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>fmt</em></span>
, </span><span class="term">
<span class="strong"><strong>--oformat</strong></span> <span class="emphasis"><em>fmt</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The output format of the output file.
</p>
<p class="simpara">Valid values for the output format is <span class="strong"><strong>XML3</strong></span>, <span class="strong"><strong>XML4</strong></span>.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
Increases the verbosity of messages about what is going on.
</p>
<p class="simpara">By default, all FATAL ERROR, ERROR , WARNINGS and INFO messages are
logged.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Displays the current version number of the  Pegasus Workflow Planner
Software.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Displays all the options to the <span class="strong"><strong>pegasus-plan</strong></span> command.
</dd>
</dl></div>
</div>
</div>
<div class="refsect1">
<a name="pegasus-sc-converter_example"></a><h2>Example</h2>
<pre class="screen">pegasus-sc-converter -i sites.xml -o sites.xml.new -O XML3 -vvvvv</pre>
</div>
<div class="refsect1">
<a name="pegasus-sc-converter_authors"></a><h2>Authors</h2>
<p>Karan Vahi <code class="literal">&lt;vahi at isi dot edu&gt;</code></p>
<p>Gaurang Mehta <code class="literal">&lt;gmehta at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-s3.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-service.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-s3 </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-service</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
