<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-em");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-em</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-em"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-em — Submit and monitor ensembles of workflows</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-em_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-em</strong></span> <span class="emphasis"><em>COMMAND</em></span> [options] [ARGUMENT…]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-em_commands"></a><h2>Commands</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>server</strong></span> [-d]
</span></dt>
<dd>
    Start the ensemble manager server.
</dd>
<dt><span class="term">
<span class="strong"><strong>ensembles</strong></span>
</span></dt>
<dd>
    List ensembles.
</dd>
<dt><span class="term">
<span class="strong"><strong>create</strong></span> <span class="emphasis"><em>ENSEMBLE</em></span> [-R <span class="emphasis"><em>MAX_RUNNING</em></span>] [-P <span class="emphasis"><em>MAX_PLANNING</em></span>]
</span></dt>
<dd>
    Create an ensemble.
</dd>
<dt><span class="term">
<span class="strong"><strong>pause</strong></span> <span class="emphasis"><em>ENSEMBLE</em></span>
</span></dt>
<dd>
    Pause ensemble.
</dd>
<dt><span class="term">
<span class="strong"><strong>activate</strong></span> <span class="emphasis"><em>ENSEMBLE</em></span>
</span></dt>
<dd>
    Activate a paused ensemble.
</dd>
<dt><span class="term">
<span class="strong"><strong>config</strong></span> <span class="emphasis"><em>ENSEMBLE</em></span> [-R <span class="emphasis"><em>MAX_RUNNING</em></span>] | [-P <span class="emphasis"><em>MAX_PLANNING</em></span>]
</span></dt>
<dd>
    Configure an ensemble.
</dd>
<dt><span class="term">
<span class="strong"><strong>submit</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span> <span class="emphasis"><em>plan_command</em></span> [ARGUMENT…]
</span></dt>
<dd>
    Submit a workflow. The command is either <span class="strong"><strong>pegasus-plan</strong></span>, or
    a shell script that calls <span class="strong"><strong>pegasus-plan</strong></span>. The output of
    <span class="emphasis"><em>plan_command</em></span> must contain the output of <span class="strong"><strong>pegasus-plan</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>workflows</strong></span> <span class="emphasis"><em>ENSEMBLE</em></span> [-l]
</span></dt>
<dd>
    List the workflows in an ensemble.
</dd>
<dt><span class="term">
<span class="strong"><strong>replan</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span>
</span></dt>
<dd>
    Replan a failed workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>rerun</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span>
</span></dt>
<dd>
    Rerun a failed workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>status</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span>
</span></dt>
<dd>
    Display the status of a workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>analyze</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span>
</span></dt>
<dd>
    Analyze the current state of a workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>priority</strong></span> <span class="emphasis"><em>ENSEMBLE.WORKFLOW</em></span> -p <span class="emphasis"><em>PRIORITY</em></span>
</span></dt>
<dd>
    Alter the priority of a workflow.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-em_common_options"></a><h2>Common Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
    Print help message
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span>
</span>
</dt>
<dd>
    Enable debugging
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-em_create_and_config_options"></a><h2>Create and Config Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-R</strong></span> <span class="emphasis"><em>N</em></span>
, </span><span class="term">
<span class="strong"><strong>--max-running</strong></span> <span class="emphasis"><em>N</em></span>
</span>
</dt>
<dd>
    Maximum number of concurrently running workflows.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-P</strong></span> <span class="emphasis"><em>N</em></span>
, </span><span class="term">
<span class="strong"><strong>--max-planning</strong></span> <span class="emphasis"><em>N</em></span>
</span>
</dt>
<dd>
    Maximum number of workflows being planned simultaneously.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-em_workflows_options"></a><h2>Workflows Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-l</strong></span>
, </span><span class="term">
<span class="strong"><strong>--long</strong></span>
</span>
</dt>
<dd>
    Use long listing format.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-em_authors"></a><h2>Authors</h2>
<p>Pegasus Team <code class="literal">&lt;pegasus@isi.edu&gt;</code></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-db-admin.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-exitcode.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-db-admin </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-exitcode</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
