<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("10.5. Output Mappers");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="data_management.php">Data Management</a></span> &gt; <span class="breadcrumb-node">Output Mappers</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="ref_output_mapper"></a>10.5. Output Mappers</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="ref_output_mapper.php#idm4789">10.5.1. Effect of pegasus.dir.storage.deep</a></span></dt></dl></div>
<p>Starting 4.3 release, Pegasus has support for output mappers, that
    allow users fine grained control over how the output files on the output
    site are laid out. By default, Pegasus stages output products to the
    storage directory specified in the site catalog for the output site.
    Output mappers allow users finer grained control over where the output
    files are placed on the output site.</p>
<p>To configure the output mapper, you need to specify the following
    property</p>
<pre class="programlisting">pegasus.dir.storage.mapper  &lt;name of the mapper to use&gt;</pre>
<p>The following mappers are supported currently</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>Flat</strong></span> : By default, Pegasus will
        place the output files in the storage directory specified in the site
        catalog for the output site.</p></li>
<li class="listitem">
<p><span class="bold"><strong>Fixed</strong></span> : This mapper allows
        users to specify an externally accesible url to the storage directory
        in their properties file. To use this mapper, the following property
        needs to be set.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p>pegasus.dir.storage.mapper.fixed.url an externally
            accessible URL to the storage directory on the output site e.g.
            gsiftp://outputs.isi.edu/shared/outputs</p></li></ul></div>
<p>Note: For hierarchal workflows, the above property needs to be
        set separately for each dax job, if you want the sub workflow outputs
        to goto a different directory.</p>
</li>
<li class="listitem"><p><span class="bold"><strong>Hashed</strong></span> : This mapper results in
        the creation of a deep directory structure on the output site, while
        populating the results. The base directory on the remote end is
        determined from the site catalog. Depending on the number of files
        being staged to the remote site a Hashed File Structure is created
        that ensures that only 256 files reside in one directory. To create
        this directory structure on the storage site, Pegasus relies on the
        directory creation feature of the underlying file servers such as
        theGrid FTP server, which appeared in globus 4.0.x</p></li>
<li class="listitem">
<p><span class="bold"><strong>Replica:</strong></span> This mapper determines
        the path for an output file on the output site by querying an output
        replica catalog. The output site is one that is passed on the command
        line. The output replica catalog can be configured by specifying the
        following properties.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>pegasus.dir.storage.mapper.replica Regex|File</p></li>
<li class="listitem"><p>pegasus.dir.storage.mapper.replica.file the RC file at the
            backend to use</p></li>
</ul></div>
<p>Please note that the output replica catalog ( even though the
        formats are the same) is logically different from the input replica
        catalog, where you specify the locations for the input files. You
        cannot specify the locations for the output files to be used by the
        mapper in the DAX. The format for the File based replica catalog is
        described <a class="link" href="replica.php#rc-FILE" title="4.2.1. File">here</a>, while for the Regex it
        is <a class="link" href="replica.php#rc-regex" title="4.2.2. Regex">here</a>.</p>
</li>
</ol></div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm4789"></a>10.5.1. Effect of pegasus.dir.storage.deep</h3></div></div></div>
<p>For Flat and Hashed output mappers, the base directory to which
      the add on component is added is determined by the property
      pegasus.dir.storage.deep . The output directory on the output site is
      determined from the site catalog.</p>
<p>If pegasus.dir.storage.deep is set to true, then to this base
      directory, a relative directory is appended i.e. $storage_base = $base +
      $relative_directory. The relative directory is computed on the basis of
      the --relative-dir option. If that is not set, then defaults to the
      relative submit directory for the workflow ( usually
      $user/$vogroup/$label/runxxxx ).This is the base directory that is
      passed to the storage mappers.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="ref_staging_mapper.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="data_management.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="data_cleanup.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">10.4. Staging Mappers </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 10.6. Data Cleanup</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
