<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("16.3. DAX Generator without a Pegasus DAX API");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="api.php">API Reference</a></span> &gt; <span class="breadcrumb-node">DAX Generator without a Pegasus DAX API</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="dax_no_api"></a>16.3. DAX Generator without a Pegasus DAX API</h2></div></div></div>
<p>If you are using some other scripting or programming environment,
    you can directly write out the DAX format using the provided schema using
    any language. For instance, LIGO, the Laser Interferometer Gravitational
    Wave Observatory, generate their DAX files as XML using their own Python
    code, not using our provided API.</p>
<p>If you write your own XML, you <span class="emphasis"><em>must</em></span> ensure that
    the generated XML is well formed and valid with respect to the DAX schema.
    You can use the <span class="command"><strong>pegasus-dax-validator</strong></span> to verify the
    validity of your generated file. Typically, you generate a smallish test
    file to, validate that your generator creates valid XML using the
    validator, and then ramp it up to produce the full workflow(s) you want to
    run. At this point the <span class="command"><strong>pegasus-dax-validator</strong></span> is a very
    simple program that will only take exactly one argument, the name of the
    file to check.The following snippet checks a black-diamond file that uses
    an improper <span class="emphasis"><em>osversion</em></span> attribute in its
    <span class="emphasis"><em>executable</em></span> element:</p>
<pre class="screen"><code class="prompt">$</code> <span class="command"><strong>pegasus-dax-validator <em class="replaceable"><code>blackdiamond.dax</code></em></strong></span>
ERROR: cvc-pattern-valid: Value '2.6.18-194.26.1.el5' is not facet-valid
 with respect to pattern '[0-9]+(\.[0-9]+(\.[0-9]+)?)?' for type 'VersionPattern'.
ERROR: cvc-attribute.3: The value '2.6.18-194.26.1.el5' of attribute 'osversion'
 on element 'executable' is not valid with respect to its type, 'VersionPattern'.

0 warnings, 2 errors, and 0 fatal errors detected.</pre>
<p>We are working on improving this program, e.g. provide output with
    regards to the line number where the issue occurred. However, it will
    return with a non-zero exit code whenever errors were detected.</p>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="dax_generator_api.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="api.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="rest-api-monitoring.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">16.2. DAX Generator API </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 16.4. Monitoring</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
