<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("8.2. Configuring Workflows To Use Containers");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="containers.php">Containers</a></span> &gt; <span class="breadcrumb-node">Configuring Workflows To Use Containers</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="container-configuration"></a>8.2. Configuring Workflows To Use Containers</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="container-configuration.php#tc-container">8.2.1. Containerized Applications in the Transformation
        Catalog</a></span></dt></dl></div>
<p>Containers currently can only be specified in the Transformation
    Catalog. Users have the option of either using a different container for
    each executable or same container for all executables. In the case, where
    you wants to use a container that does not have your executable
    pre-installed, you can mark the executable as STAGEABLE and Pegasus will
    stage the executable into the container, as part of executable
    staging.</p>
<p>The DAX API extensions don't support references for
    containers.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="tc-container"></a>8.2.1. Containerized Applications in the Transformation
        Catalog</h3></div></div></div>
<p>Users can specify what container they want to use for running
        their application in the Transformation Catalog using the multi line
        text based format described in this section. Users can specify an
        optional attribute named container that refers to the container to be
        used for the application.</p>
<pre class="programlisting">tr example::keg:1.0 { 

  #specify profiles that apply for all the sites for the transformation 
  #in each site entry the profile can be overriden 

  profile env "APP_HOME" "/tmp/myscratch"
  profile env "JAVA_HOME" "/opt/java/1.6"

  site isi {
    # environment to be set when the job is run in the container
    # overrides env profiles specified in the container
    profile env "HELLo" "WORLD"
    profile env "JAVA_HOME" "/bin/java.1.6"
    
    profile condor "FOO" "bar"
    
    pfn "/path/to/keg
    arch "x86"
    os "linux"
    osrelease "fc"
    osversion "4"
      
    # INSTALLED means pfn refers to path in the container.
    # STAGEABLE means the executable can be staged into the container
    type "INSTALLED" 

    #optional attribute to specify the container to use
    container "centos-pegasus"
  }
}

cont centos-pegasus{
     # can be either docker or singularity
     type "docker"

     # URL to image in a docker|singularity hub OR
     # URL to an existing docker image exported as a tar file or singularity image
     image "docker:///rynge/montage:latest" 

     # optional site attribute to tell pegasus which site tar file
     # exists. useful for handling file URL's correctly
     image_site "optional site"
  
     # environment to be set when the job is run in the container
     # only env profiles are supported
     profile env "JAVA_HOME" "/opt/java/1.6"	    
}</pre>
<p>The container itself is defined using the cont entry. Multiple
        transformations can refer to the same container.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>cont</strong></span> cont - A container
            identifier.</p></li>
<li class="listitem"><p><span class="bold"><strong>image</strong></span> - URL to image in a
            docker|singularity hub or URL to an existing docker image exported
            as a tar file or singularity image. Example of a docker hub URL is
            docker:///rynge/montage:latest, while for singularity
            shub://pegasus-isi/fedora-montage</p></li>
<li class="listitem"><p><span class="bold"><strong>image_site</strong></span> - The site
            identifier for the site where the container is available</p></li>
<li class="listitem"><p><span class="bold"><strong>Profiles</strong></span> - One or many
            profiles can be attached to a transformation for all sites or to a
            transformation on a particular site. For containers, only env
            profiles are supported.</p></li>
</ol></div>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>Containerized Applications can only be specified in the
          transformation catalog, not via the DAX API.</p>
</div>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="containers.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="containers.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="container-exec-model.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 8. Containers </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 8.3. Container Execution Model</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
