<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-tc-client");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-tc-client</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-tc-client"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-tc-client — A full featured generic client to handle adds, deletes and queries to the Transformation Catalog (TC).</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-tc-client_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-tc-client</strong></span> [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>…] [<span class="emphasis"><em>-h</em></span>] [<span class="emphasis"><em>-v</em></span>] [<span class="emphasis"><em>-V</em></span>]<br>
                  <span class="emphasis"><em>OPERATION</em></span> <span class="emphasis"><em>TRIGGERS</em></span> [<span class="emphasis"><em>OPTIONS</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-tc-client</strong></span> command is a generic client that performs the three
basic operation of adding, deleting and querying of any Transformation Catalog
implemented to the TC API. The client implements all the operations supported
by the TC API. It is up to the TC implementation whether they support all
operations or modes.</p>
<p>The following 3 operations are supported by the <span class="strong"><strong>pegasus-tc-client</strong></span>. One of these
operations have to be specified to run the client.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>ADD</strong></span>
</span></dt>
<dd>
This operation allows the client to add or update entries in the Transformation
Catalog. Entries can be added one by one on the command line or in bulk by
using the <span class="emphasis"><em>BULK</em></span> Trigger and providing a file with the necessary entries. Also
Profiles can be added to either the logical transformation or the physical
transformation.
</dd>
<dt><span class="term">
<span class="strong"><strong>DELETE</strong></span>
</span></dt>
<dd>
This operation allows the client to delete entries from the Transformation
Catalog. Entries can be deleted based on logical transformation, by resource,
by transformation type as well as the transformation system information.
Also Profiles associated with the logical or physical transformation can
be deleted.
</dd>
<dt><span class="term">
<span class="strong"><strong>QUERY</strong></span>
</span></dt>
<dd>
This operation allows the client to query for entries from the Transformation
Catalog. Queries can be made for printing all the contents of the Catalog or
for specific entries, for all the logical transformations or resources etc.
</dd>
</dl></div>
<p>See the <a class="link" href="cli-pegasus-tc-client.php#TRIGGERS" title="Triggers"><span class="strong"><strong>TRIGGERS</strong></span></a> and <a class="link" href="cli-pegasus-tc-client.php#VALID_COMBINATIONS" title="Valid Combinations"><span class="strong"><strong>VALID COMBINATIONS</strong></span></a>
section for more details.</p>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_operations"></a><h2>Operations</h2>
<p>To select one of the 3 operations.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-a, --add</strong></span>
</span></dt>
<dd>
Perform addition operations on the TC.
</dd>
<dt><span class="term">
<span class="strong"><strong>-d, --delete</strong></span>
</span></dt>
<dd>
Perform delete operations on the TC.
</dd>
<dt><span class="term">
<span class="strong"><strong>-q, --query</strong></span>
</span></dt>
<dd>
Perform query operations on the TC.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="TRIGGERS"></a><h2>Triggers</h2>
<p>Triggers modify the behavior of an <span class="strong"><strong>OPERATION</strong></span>. For example, if you want to
perform a bulk operation you would use a <span class="emphasis"><em>BULK</em></span> Trigger or if you want to
perform an operation on a Logical Transformation then you would use the
<span class="emphasis"><em>LFN</em></span> Trigger.</p>
<p>The following 7 Triggers are available. See the <a class="link" href="cli-pegasus-tc-client.php#VALID_COMBINATIONS" title="Valid Combinations"><span class="strong"><strong>VALID COMBINATIONS</strong></span></a> section for the correct grouping and usage.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-B</strong></span>
</span></dt>
<dd>
Triggers a bulk operation.
</dd>
<dt><span class="term">
<span class="strong"><strong>-L</strong></span>
</span></dt>
<dd>
Triggers an operation on a logical transformation.
</dd>
<dt><span class="term">
<span class="strong"><strong>-P</strong></span>
</span></dt>
<dd>
Triggers an operation on a physical transformation
</dd>
<dt><span class="term">
<span class="strong"><strong>-R</strong></span>
</span></dt>
<dd>
Triggers an operation on a resource.
</dd>
<dt><span class="term">
<span class="strong"><strong>-E</strong></span>
</span></dt>
<dd>
Triggers an operation on a Profile.
</dd>
<dt><span class="term">
<span class="strong"><strong>-T</strong></span>
</span></dt>
<dd>
Triggers an operation on a Type.
</dd>
<dt><span class="term">
<span class="strong"><strong>-S</strong></span>
</span></dt>
<dd>
Triggers an operation on a System information.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_options"></a><h2>Options</h2>
<p>The following options are applicable for all the operations.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
The -D options allows an experienced user to override certain properties
which influence the program execution, among them the default location of
the user’s properties file and the PEGASUS home location. One may set
several CLI properties by giving this option multiple times. The <span class="strong"><strong>-D</strong></span>
option(s) must be the first option on the command line. A CLI property
take precedence over the properties file property of the same key.
</dd>
<dt><span class="term">
<span class="strong"><strong>-l, --lfn</strong></span> <span class="emphasis"><em>logical</em></span>
</span></dt>
<dd>
The logical transformation to be added. The format is:
<span class="strong"><strong>NAMESPACE::NAME:VERSION</strong></span>. The name is always required, namespace and
version are optional.
</dd>
<dt><span class="term">
<span class="strong"><strong>-p, --pfn</strong></span> <span class="emphasis"><em>physical</em></span>
</span></dt>
<dd>
The physical transformation to be added. For INSTALLED executables its
a local file path, for all others its a url.
</dd>
<dt><span class="term">
<span class="strong"><strong>-t, --type</strong></span> <span class="emphasis"><em>type</em></span>
</span></dt>
<dd>
The type of physical transformation. Valid values are: INSTALLED,
STATIC_BINARY, DYNAMIC_BINARY, SCRIPT, SOURCE, PACMAN_PACKAGE.
</dd>
<dt><span class="term">
<span class="strong"><strong>-r, --resource</strong></span> <span class="emphasis"><em>resource</em></span>
</span></dt>
<dd>
The resourceID where the transformation is located.
</dd>
<dt><span class="term">
<span class="strong"><strong>-e, --profile</strong></span> <span class="emphasis"><em>profiles</em></span>
</span></dt>
<dd>
The profiles for the transformation. Multiple profiles of same namespace
can be added simultaneously by separating them with a comma <span class="strong"><strong>","</strong></span>. Each
profile section is written as <span class="strong"><strong>NAMESPACE::KEY=VALUE,KEY2=VALUE2</strong></span>
e.g. <code class="literal">ENV::JAVA_HOME=/usr/bin/java2,PEGASUS_HOME=/usr/local/pegasus</code>. To
add multiple namespaces you need to repeat the -e option for each namespace.
e.g. <code class="literal">-e ENV::JAVA_HOME=/usr/bin/java -e GLOBUS::JobType=MPI,COUNT=10</code>
</dd>
<dt><span class="term">
<span class="strong"><strong>-s, --system</strong></span> <span class="emphasis"><em>systeminfo</em></span>
</span></dt>
<dd>
The architecture, os, osversion and glibc if any for the executable. Each
system info is written in the form <span class="strong"><strong>ARCH::OS:OSVER:GLIBC</strong></span>
</dd>
<dt><span class="term">
<span class="strong"><strong>-v, --verbose</strong></span>
</span></dt>
<dd>
Displays the output in verbose mode (Lots of Debugging info).
</dd>
<dt><span class="term">
<span class="strong"><strong>-V, --version</strong></span>
</span></dt>
<dd>
Displays the Pegasus version.
</dd>
<dt><span class="term">
<span class="strong"><strong>-h, --help</strong></span>
</span></dt>
<dd>
Generates help
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_other_options"></a><h2>Other Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-o, --oldformat</strong></span>
</span></dt>
<dd>
Generates the output in the old single line format
</dd>
<dt><span class="term">
<span class="strong"><strong>-c, --conf</strong></span>
</span></dt>
<dd>
path to property file
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="VALID_COMBINATIONS"></a><h2>Valid Combinations</h2>
<p>The following are valid combinations of <span class="strong"><strong>OPERATIONS, TRIGGERS, OPTIONS</strong></span>
for the <span class="strong"><strong>pegasus-tc-client</strong></span>.</p>
<div class="refsect2">
<a name="pegasus-tc-client_add"></a><h3>ADD</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>Add TC Entry</strong></span>
</span></dt>
<dd>
<p class="simpara">
-a -l <span class="emphasis"><em>lfn</em></span> -p <span class="emphasis"><em>pfn</em></span> -t <span class="emphasis"><em>type</em></span> -r <span class="emphasis"><em>resource</em></span> -s <span class="emphasis"><em>system</em></span> [-e <span class="emphasis"><em>profiles</em></span>…]
</p>
<p class="simpara">Adds a single entry into the transformation catalog.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Add PFN Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-a -P -E -p <span class="emphasis"><em>pfn</em></span> -t <span class="emphasis"><em>type</em></span> -r <span class="emphasis"><em>resource</em></span> -e <span class="emphasis"><em>profiles</em></span> …
</p>
<p class="simpara">Adds profiles to a specified physical transformation on a given resource
and of a given type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Add LFN Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-a -L -E -l <span class="emphasis"><em>lfn</em></span> -e <span class="emphasis"><em>profiles</em></span> …
</p>
<p class="simpara">Adds profiles to a specified logical transformation.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Add Bulk Entries</strong></span>
</span></dt>
<dd>
<p class="simpara">
-a -B -f <span class="emphasis"><em>file</em></span>
</p>
<p class="simpara">Adds entries in bulk mode by supplying a file containing the entries. The
format of the file contains 6 columns. E.g.</p>
<pre class="screen">#RESOURCE   LFN         PFN      TYPE      SYSINFO      PROFILES
#
isi NS::NAME:VER  /bin/date  INSTALLED  ARCH::OS:OSVERS:GLIBC  NS::KEY=VALUE,KEY=VALUE;NS2::KEY=VALUE,KEY=VALUE</pre>
</dd>
</dl></div>
</div>
<div class="refsect2">
<a name="pegasus-tc-client_delete"></a><h3>DELETE</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>Delete all TC</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -BPRELST
</p>
<p class="simpara">Deletes the entire contents of the TC.</p>
<p class="simpara"><span class="strong"><strong>WARNING : USE WITH CAUTION.</strong></span></p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete by LFN</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -L -l <span class="emphasis"><em>lfn</em></span> [-r <span class="emphasis"><em>resource</em></span>] [-t <span class="emphasis"><em>type</em></span>]
</p>
<p class="simpara">Deletes entries from the TC for a particular logical transformation and
additionally a resource and or type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete by PFN</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -P -l <span class="emphasis"><em>lfn</em></span> -p <span class="emphasis"><em>pfn</em></span> [-r <span class="emphasis"><em>resource</em></span>] [-t <span class="emphasis"><em>type</em></span>]
</p>
<p class="simpara">Deletes entries from the TC for a given logical and physical transformation
and additionally on a particular resource and or of a particular type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete by Type</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -T -t <span class="emphasis"><em>type</em></span> [-r <span class="emphasis"><em>resource</em></span>]
</p>
<p class="simpara">Deletes entries from TC of a specific type and/or on a specific resource.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete by Resource</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -R -r <span class="emphasis"><em>resource</em></span>
</p>
<p class="simpara">Deletes the entries from the TC on a particular resource.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete by SysInfo</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -S -s <span class="emphasis"><em>sysinfo</em></span>
</p>
<p class="simpara">Deletes the entries from the TC for a particular system information type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete Pfn Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -P -E -p <span class="emphasis"><em>pfn</em></span> -r <span class="emphasis"><em>resource</em></span> -t <span class="emphasis"><em>type</em></span> [-e <span class="emphasis"><em>profiles</em></span> ..]
</p>
<p class="simpara">Deletes all or specific profiles associated with a physical transformation.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Delete Lfn Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-d -L -E -l <span class="emphasis"><em>lfn</em></span> -e <span class="emphasis"><em>profiles</em></span> ….
</p>
<p class="simpara">Deletes all or specific profiles associated with a logical transformation.</p>
</dd>
</dl></div>
</div>
<div class="refsect2">
<a name="pegasus-tc-client_query"></a><h3>QUERY</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>Query Bulk</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -B
</p>
<p class="simpara">Queries for all the contents of the TC. It produces a file format TC which
can be added to another TC using the bulk option.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Query LFN</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -L [-r <span class="emphasis"><em>resource</em></span>] [-t <span class="emphasis"><em>type</em></span>]
</p>
<p class="simpara">Queries the TC for logical transformation and/or on a particular resource
and/or of a particular type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Query PFN</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -P -l <span class="emphasis"><em>lfn</em></span> [-r <span class="emphasis"><em>resource</em></span>] [-t <span class="emphasis"><em>type</em></span>]
</p>
<p class="simpara">Queries the TC for physical transformations for a give logical transformation
and/or on a particular resource and/or of a particular type.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Query Resource</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -R -l <span class="emphasis"><em>lfn</em></span> [-t <span class="emphasis"><em>type</em></span>]
</p>
<p class="simpara">Queries the TC for resources that are registered and/or resources
registered for a specific type of transformation.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Query LFN Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -L -E -l <span class="emphasis"><em>lfn</em></span>
</p>
<p class="simpara">Queries for profiles associated with a particular logical transformation</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>Query Pfn Profile</strong></span>
</span></dt>
<dd>
<p class="simpara">
-q -P -E -p <span class="emphasis"><em>pfn</em></span> -r <span class="emphasis"><em>resource</em></span> -t <span class="emphasis"><em>type</em></span>
</p>
<p class="simpara">Queries for profiles associated with a particular physical transformation</p>
</dd>
</dl></div>
</div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_properties"></a><h2>Properties</h2>
<p>These are the properties you will need to set to use either the <span class="strong"><strong>File</strong></span> or
<span class="strong"><strong>Database</strong></span> TC.</p>
<p>For more details please check the <span class="strong"><strong>$PEGASUS_HOME/etc/sample.properties</strong></span> file.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.transformation</strong></span>
</span></dt>
<dd>
Identifies what impelemntation of TC will be used. If relative name is used
then the path org.griphyn.cPlanner.tc is prefixed to the name and used as the
class name to load. The default value if <span class="strong"><strong>Text</strong></span>. Other supported mode is <span class="strong"><strong>File</strong></span>
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.transformation.file</strong></span>
</span></dt>
<dd>
The file path where the text based TC is located. By default the path
<span class="strong"><strong>$PEGASUS_HOME/var/tc.data</strong></span> is used.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_files"></a><h2>Files</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/var/tc.data</strong></span>
</span></dt>
<dd>
is the suggested location for the file corresponding to the Transformation
Catalog
</dd>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/properties</strong></span>
</span></dt>
<dd>
is the location to specify properties to change what Transformation Catalog
Implementation to use and the implementation related <span class="strong"><strong>PROPERTIES</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.jar</strong></span>
</span></dt>
<dd>
contains all compiled Java bytecode to run the Pegasus planner.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_environment_variables"></a><h2>Environment Variables</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>PEGASUS_HOME</strong></span>
</span></dt>
<dd>
Path to the PEGASUS installation directory.
</dd>
<dt><span class="term">
<span class="strong"><strong>JAVA_HOME</strong></span>
</span></dt>
<dd>
Path to the JAVA 1.4.x installation directory.
</dd>
<dt><span class="term">
<span class="strong"><strong>CLASSPATH</strong></span>
</span></dt>
<dd>
The classpath should be set to contain all necessary PEGASUS files for the
execution environment. To automatically add the <span class="emphasis"><em>CLASSPATH</em></span> to you
environment, in the <span class="emphasis"><em>$PEGASUS_HOME</em></span> directory run the script
<span class="emphasis"><em>source setup-user-env.csh</em></span> or <span class="emphasis"><em>source setup-user-env.sh</em></span>.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-tc-client_authors"></a><h2>Authors</h2>
<p>Gaurang Mehta <code class="literal">&lt;gmehta at isi dot edu&gt;</code></p>
<p>Karan Vahi <code class="literal">&lt;vahi at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-submitdir.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-tc-converter.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-submitdir </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-tc-converter</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
