import logging

from Pegasus.db.admin.admin_loader import *
from Pegasus.db.admin.versions.base_version import BaseVersion
from Pegasus.db.schema import *
from sqlalchemy.exc import *

DB_VERSION = 7

log = logging.getLogger(__name__)

class Version(BaseVersion):

    def __init__(self, connection):
        super(Version, self).__init__(connection)

    def update(self, force=False):
        """

        :param force:
        :return:
        """
        log.info("Updating to version %s" % DB_VERSION)
        try:
            log.info("Updating workflowstate...")
            self.db.execute("ALTER TABLE workflowstate ADD reason TEXT NULL")
        except (OperationalError, ProgrammingError):
            pass
        except Exception, e:
            self.db.rollback()
            log.exception(e)
            raise Exception(e)

        try:
            log.info("Updating jobstate...")
            self.db.execute("ALTER TABLE jobstate ADD reason TEXT NULL")
        except (OperationalError, ProgrammingError):
            pass
        except Exception, e:
            self.db.rollback()
            log.exception(e)
            raise Exception(e)

        self.db.commit()

    def downgrade(self, force=False):
        "Downgrade is not necessary as reason accepts NULL values"
        pass
