<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-plan.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-rc-client.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-plots">
<a name="cli-pegasus-plots"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-plots — A tool to generate graphs and charts to visualize workflow run.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-plots_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-plots</strong></span> [<span class="strong"><strong>-h</strong></span>|<span class="strong"><strong>--help</strong></span>]<br>
              [<span class="strong"><strong>-o</strong></span>|<span class="strong"><strong>--output</strong></span> <span class="emphasis"><em>outdir</em></span>]<br>
              [<span class="strong"><strong>-c</strong></span>|<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propfile</em></span>]<br>
              [<span class="strong"><strong>-m</strong></span>|<span class="strong"><strong>--max-graph-nodes</strong></span> <span class="emphasis"><em>max</em></span>]<br>
              [<span class="strong"><strong>-p</strong></span>|<span class="strong"><strong>--plotting-level</strong></span> <span class="emphasis"><em>level</em></span>]<br>
              [<span class="strong"><strong>-i</strong></span>|<span class="strong"><strong>--ignore-db-inconsistency</strong></span>]<br>
              [<span class="strong"><strong>-v</strong></span>|<span class="strong"><strong>--verbose</strong></span>]<br>
              [<span class="strong"><strong>-q</strong></span>|<span class="strong"><strong>--quiet</strong></span>]<br>
              [<span class="emphasis"><em>submitdir</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-plots_description"></a><h2>Description</h2>
<p>pegasus-plots generates graphs and charts to visualize workflow run. It
generates workflow execution Gantt chart, job over time chart, time chart,
dax and dag graph. It uses executable 'dot\' to generate graphs.
pegasus-plots looks for the executable in your path and generates
graphs based on it’s availability .</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-plots_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>outdir</em></span>
, </span><span class="term">
<span class="strong"><strong>--output</strong></span> <span class="emphasis"><em>outdir</em></span>
</span>
</dt>
<dd>
Writes the output to the given directory
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>propfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propfile</em></span>
</span>
</dt>
<dd>
The properties file to use. This option overrides all other property files.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span> <span class="emphasis"><em>max</em></span>
, </span><span class="term">
<span class="strong"><strong>--max-graph-nodes</strong></span> <span class="emphasis"><em>max</em></span>
</span>
</dt>
<dd>
Maximum limit on the number of tasks/jobs in the dax/dag up to which the
graph should be generated. The default value is 100.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>level</em></span>
, </span><span class="term">
<span class="strong"><strong>--plotting-level</strong></span> <span class="emphasis"><em>level</em></span>
</span>
</dt>
<dd>
<p class="simpara">
Specifies the charts and graphs to generate. Valid levels are: <span class="strong"><strong>all</strong></span>,
<span class="strong"><strong>all_charts</strong></span>, <span class="strong"><strong>all_graphs</strong></span>, <span class="strong"><strong>dax_graph</strong></span>, <span class="strong"><strong>dag_graph</strong></span>, <span class="strong"><strong>gantt_chart</strong></span>,
<span class="strong"><strong>host_chart</strong></span>, <span class="strong"><strong>time_chart</strong></span>, <span class="strong"><strong>breakdown_chart</strong></span>. Default is <span class="strong"><strong>all_charts</strong></span>.
The output generated by <span class="strong"><strong>pegasus-plots</strong></span> is based on the <span class="emphasis"><em>level</em></span> set:
</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<span class="strong"><strong>all</strong></span>: generates all charts and graphs.
</li>
<li class="listitem">
<span class="strong"><strong>all_charts</strong></span>: generates all charts.
</li>
<li class="listitem">
<span class="strong"><strong>all_graphs</strong></span>: generates all graphs.
</li>
<li class="listitem">
<span class="strong"><strong>dax_graph</strong></span>: generates dax graph.
</li>
<li class="listitem">
<span class="strong"><strong>dag_graph</strong></span>: generates dag graph.
</li>
<li class="listitem">
<span class="strong"><strong>gantt_chart</strong></span>: generates the workflow execution Gantt chart.
</li>
<li class="listitem">
<span class="strong"><strong>host_chart</strong></span>: generates the host over time chart.
</li>
<li class="listitem">
<span class="strong"><strong>time_chart</strong></span>: generates the time chart which shows the job
instance/invocation count and runtime over time.
</li>
<li class="listitem">
<span class="strong"><strong>breakdown_chart</strong></span>: generates the breakdown chart which shows the invocation
count and runtime grouped by transformation name.
</li>
</ul></div>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span>
, </span><span class="term">
<span class="strong"><strong>--ignore-db-inconsistency</strong></span>
</span>
</dt>
<dd>
Turn off the the check for database consistency.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Increases the log level. If omitted, the default level will be set to
WARNING. When this option is given, the log level is changed to INFO.
If this option is repeated, the log level will be changed to DEBUG.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
Decreases the log level.  If omitted, the default level will be set to
WARNING. When this option is given, the log level is changed to ERROR.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-plots_example"></a><h2>Example</h2>
<p>Runs pegasus-plots and writes the output to the given directory:</p>
<pre class="screen">pegasus-plots  -o /scratch/plot /scratch/grid-setup/run0001</pre>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-plots_authors"></a><h2>Authors</h2>
<p>Prasanth Thomas</p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-plan.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-rc-client.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-plan </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-rc-client</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
