<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="funding_citing_usage.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="glossary.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="17.2. Usage Statistics Collection">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="usage_statistics"></a>17.2. Usage Statistics Collection</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="usage_statistics.php#usage_stats_purpose">17.2.1. Purpose</a></span></dt>
<dt><span class="section"><a href="usage_statistics.php#usage_stats_overview">17.2.2. Overview</a></span></dt>
<dt><span class="section"><a href="usage_statistics.php#usage_stats_configuration">17.2.3. Configuration</a></span></dt>
<dt><span class="section"><a href="usage_statistics.php#usage_metrics_collected">17.2.4. Metrics Collected</a></span></dt>
</dl></div>
<div class="section" title="17.2.1. Purpose">
<div class="titlepage"><div><div><h3 class="title">
<a name="usage_stats_purpose"></a>17.2.1. Purpose</h3></div></div></div>
<p>Pegasus WMS is primarily a NSF funded project as part of the
      <a class="ulink" href="http://www.nsf.gov/funding/pgm_summ.jsp?pims_id=504817" target="_top">NSF
      SI2</a> track. The SI2 program focuses on robust, reliable, usable
      and sustainable software infrastructure that is critical to the CIF21
      vision. As part of the requirements of being funded under this program,
      Pegasus WMS is required to gather usage statistics of Pegasus WMS and
      report it back to NSF in annual reports. The metrics will also enable us
      to improve our software as they will include errors encountered during
      the use of our software.</p>
</div>
<div class="section" title="17.2.2. Overview">
<div class="titlepage"><div><div><h3 class="title">
<a name="usage_stats_overview"></a>17.2.2. Overview</h3></div></div></div>
<p>We plan to instrument and augment the following clients in our
      distribution to report the metrics.</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p>pegasus-plan</p></li>
<li class="listitem"><p>pegasus-transfer</p></li>
<li class="listitem"><p>pegasus-monitord</p></li>
</ul></div>
<p>For the Pegasus WMS 4.2 release, only the pegasus-plan client has
      been instrumented to send metrics.</p>
<p>All the metrics are sent in JSON format to a server at USC/ISI
      over HTTP. The data reported is as generic as possible and is listed in
      detail in the section titled <a class="link" href="usage_statistics.php#usage_metrics_collected" title="17.2.4. Metrics Collected">"Metrics Collected"</a>.</p>
</div>
<div class="section" title="17.2.3. Configuration">
<div class="titlepage"><div><div><h3 class="title">
<a name="usage_stats_configuration"></a>17.2.3. Configuration</h3></div></div></div>
<p>By default, the clients will report usage metrics to a server at
      ISI. However, users have an option to configure the report by setting
      the following environment variables</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<p>PEGASUS_METRICS</p>
<p>A boolean value ( true | false ) indicating whether metrics
          reporting is turned ON/OFF</p>
</li>
<li class="listitem">
<p>PEGASUS_USER_METRICS_SERVER</p>
<p>A comma separated list of URLs of the servers to which to
          report the metrics in addition to the default server.</p>
</li>
</ul></div>
</div>
<div class="section" title="17.2.4. Metrics Collected">
<div class="titlepage"><div><div><h3 class="title">
<a name="usage_metrics_collected"></a>17.2.4. Metrics Collected</h3></div></div></div>
<p>All metrics are sent in JSON format and the metrics sent by the
      various clients include the following data</p>
<div class="table">
<a name="idp36736432"></a><p class="title"><b>Table 17.1. Common Data Sent By Pegasus WMS Clients</b></p>
<div class="table-contents"><table summary="Common Data Sent By Pegasus WMS Clients" border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">JSON KEY</th>
<th align="center">DESCRIPTION</th>
</tr></thead>
<tbody>
<tr>
<td>client</td>
<td>the name of the client ( e.g "pegasus-plan")</td>
</tr>
<tr>
<td>version</td>
<td>the version of the client</td>
</tr>
<tr>
<td>type</td>
<td>type of data - "metrics" | "error"</td>
</tr>
<tr>
<td>start_time</td>
<td>start time of the client ( in epoch seconds with
              millisecond precision )</td>
</tr>
<tr>
<td>end_time</td>
<td>end time of the client ( in epoch seconds with
              millisecond precision)</td>
</tr>
<tr>
<td>duration</td>
<td>the duration of the client</td>
</tr>
<tr>
<td>exitcode</td>
<td>the exitcode with which the client exited</td>
</tr>
<tr>
<td>wf_uuid</td>
<td>the uuid of the executable workflow. It is generated by
              pegasus-plan at planning time.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="section" title="17.2.4.1. Pegasus Planner Metrics">
<div class="titlepage"><div><div><h4 class="title">
<a name="usage_planner_metrics"></a>17.2.4.1. Pegasus Planner Metrics</h4></div></div></div>
<p>The metrics messages sent by the planner in addition include the
        following data</p>
<div class="table">
<a name="idp35402368"></a><p class="title"><b>Table 17.2. Metrics Data Sent by pegasus-plan</b></p>
<div class="table-contents"><table summary="Metrics Data Sent by pegasus-plan" border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">JSON KEY</th>
<th align="center">DESCRIPTION</th>
</tr></thead>
<tbody>
<tr>
<td>root_wf_uuid</td>
<td>the root workflow uuid. For non hierarchal workflows
                the root workflow uuid is the same as the workflow
                uuid.</td>
</tr>
<tr>
<td>data_config</td>
<td>the data configuration mode of pegasus</td>
</tr>
<tr>
<td>compute_tasks</td>
<td>the number of compute tasks in the workflow</td>
</tr>
<tr>
<td>dax_tasks</td>
<td>the number of dax tasks in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>dag_tasks</td>
<td>the number of dag tasks in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>total_tasks</td>
<td>the number of the total tasks in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>dax_input_files</td>
<td>the number of input files in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>dax_inter_files</td>
<td>the number of intermediate files in the abstract
                workflow (DAX)</td>
</tr>
<tr>
<td>dax_output_files</td>
<td>the number of output files in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>dax_total_files</td>
<td>the number of total files in the abstract workflow
                (DAX)</td>
</tr>
<tr>
<td>compute_jobs</td>
<td>the number of compute jobs in the executable
                workflow</td>
</tr>
<tr>
<td>clustered_jobs</td>
<td>the number of clustered jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>si_tx_jobs</td>
<td>the number of data stage-in jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>so_tx_jobs</td>
<td>the number of data stage-out jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>inter_tx_jobs</td>
<td>the number of inter site data transfer jobs in the
                executable workflow.</td>
</tr>
<tr>
<td>reg_job</td>
<td>the number of registration jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>cleanup_jobs</td>
<td>the number of cleanup jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>create_dir_jobs</td>
<td>the number of create directory jobs in the executable
                workflow.</td>
</tr>
<tr>
<td>dax_jobs</td>
<td>the number of sub workflows corresponding to dax tasks
                in the executable workflow.</td>
</tr>
<tr>
<td>dag_jobs</td>
<td>the number of sub workflows corresponding to dag tasks
                in the executable workflow.</td>
</tr>
<tr>
<td>chmod_jobs</td>
<td>the number of jobs that set the xbit of the staged
                executables</td>
</tr>
<tr>
<td>total_jobs</td>
<td>the total number of jobs in the workflow</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>In addition if pegasus-plan encounters an error during the
        planning process the metrics message has an additional field in
        addition to the fields listed above.</p>
<div class="table">
<a name="idp35013712"></a><p class="title"><b>Table 17.3. Error Message sent by pegasus-plan</b></p>
<div class="table-contents"><table summary="Error Message sent by pegasus-plan" border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">JSON KEY</th>
<th align="center">DESCRIPTION</th>
</tr></thead>
<tbody><tr>
<td>error</td>
<td>the error payload is the stack trace of errors caught
                during planning</td>
</tr></tbody>
</table></div>
</div>
<br class="table-break"><div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>pegasus-plan leaves a copy of the metrics sent in the workflow
          submit directory in the file ending with ".metrics" extension. As a
          user you will always have access to the metrics sent.</p>
</div>
</div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="funding_citing_usage.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="funding_citing_usage.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="glossary.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 17. Funding, citing, and anonymous usage statistics </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 18. Glossary</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
