<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-sc-converter.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-status.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-statistics">
<a name="cli-pegasus-statistics"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-statistics — A tool to generate statistics about the workflow run.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-statistics_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-statistics</strong></span> [<span class="strong"><strong>-h</strong></span>|<span class="strong"><strong>--help</strong></span>]<br>
                   [<span class="strong"><strong>-o</strong></span>|<span class="strong"><strong>--output</strong></span> <span class="emphasis"><em>dir</em></span>]<br>
                   [<span class="strong"><strong>-c</strong></span>|<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propfile</em></span>]<br>
                   [<span class="strong"><strong>-p</strong></span>|<span class="strong"><strong>--statistics-level</strong></span> <span class="emphasis"><em>level</em></span>]<br>
                   [<span class="strong"><strong>-t</strong></span>|<span class="strong"><strong>--time-filter</strong></span> <span class="emphasis"><em>filter</em></span>]<br>
                   [<span class="strong"><strong>-i</strong></span>|<span class="strong"><strong>--ignore-db-inconsistency</strong></span>]<br>
                   [<span class="strong"><strong>-v</strong></span>|<span class="strong"><strong>--verbose</strong></span>]<br>
                   [<span class="strong"><strong>-q</strong></span>|<span class="strong"><strong>--quiet</strong></span>]<br>
                   [<span class="strong"><strong>-m</strong></span>|<span class="strong"><strong>--multiple-wf</strong></span>]<br>
                   [<span class="strong"><strong>-p</strong></span>|<span class="strong"><strong>--ispmc</strong></span>]<br>
                   [<span class="strong"><strong>-u</strong></span>|<span class="strong"><strong>--isuuid</strong></span>]<br>
                   [[<span class="emphasis"><em>submitdir ..</em></span>] | [<span class="emphasis"><em>workflow_uuid ..</em></span>]]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-statistics_description"></a><h2>Description</h2>
<p>pegasus-statistics generates statistics about the workflow run like total
jobs/tasks/sub workflows ran, how many succeeded/failed etc. It generates
job instance statistics like run time, condor queue delay etc. It generates
invocation statistics information grouped by transformation name. It also
generates job instance and invocation statistics information grouped by
time and host.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-statistics_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>dir</em></span>
, </span><span class="term">
<span class="strong"><strong>--output</strong></span>  <span class="emphasis"><em>dir</em></span>
</span>
</dt>
<dd>
Writes the output to the given directory.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>propfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--conf</strong></span>  <span class="emphasis"><em>propfile</em></span>
</span>
</dt>
<dd>
The properties file to use. This option overrides all other property files.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>level</em></span>
, </span><span class="term">
<span class="strong"><strong>--statistics-level</strong></span> <span class="emphasis"><em>level</em></span>
</span>
</dt>
<dd>
<p class="simpara">
Specifies the statistics information to generate. Valid levels are: <span class="strong"><strong>all</strong></span>,
<span class="strong"><strong>summary</strong></span>, <span class="strong"><strong>wf_stats</strong></span>, <span class="strong"><strong>jb_stats</strong></span>, <span class="strong"><strong>tf_stats</strong></span>, and <span class="strong"><strong>ti_stats</strong></span>. Default is
<span class="strong"><strong>summary</strong></span>. The output generated by pegasus-statistics is based on the the
<span class="emphasis"><em>level</em></span> set:
</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<span class="strong"><strong>all</strong></span>: generates all the statistics information.
</li>
<li class="listitem">
<span class="strong"><strong>summary</strong></span>: generates the workflow statistics summary. In the case of a
hierarchical workflow the summary is across all sub workflows.
</li>
<li class="listitem">
<span class="strong"><strong>wf_stats</strong></span>: generates the workflow statistics information of each
individual workflow. In case of a hierarchical workflow the workflow
statistics are created for each sub workflow.
</li>
<li class="listitem">
<span class="strong"><strong>jb_stats</strong></span>: generates the job statistics information of each individual
workflow. In case of hierarchical workflow the job statistics is created
for each sub workflows. Note: Not supported when generating statistics
over multiple workflows.
</li>
<li class="listitem">
<span class="strong"><strong>tf_stats</strong></span>: generates the invocation statistics information of each
individual workflow grouped by transformation name .In case of hierarchical
workflow the transformation statistics is created for each sub workflows.
</li>
<li class="listitem">
<span class="strong"><strong>ti_stats</strong></span>: generates the job instance and invocation statistics like total
count and runtime grouped by time and host.
</li>
</ul></div>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span> <span class="emphasis"><em>filter</em></span>
, </span><span class="term">
<span class="strong"><strong>--time-filter</strong></span> <span class="emphasis"><em>filter</em></span>
</span>
</dt>
<dd>
Specifies the time filter to group the time statistics. Valid <span class="emphasis"><em>filter</em></span> values
are: <span class="strong"><strong>month</strong></span>, <span class="strong"><strong>week</strong></span>, <span class="strong"><strong>day</strong></span>, <span class="strong"><strong>hour</strong></span>. Default is <span class="strong"><strong>day</strong></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span>
, </span><span class="term">
<span class="strong"><strong>--ignore-db-inconsistency</strong></span>
</span>
</dt>
<dd>
Turn off the the check for database consistency.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Increases the log level.  If omitted, the default level will be set to
WARNING.  When this option is given, the log level is changed to INFO.
If this option is repeated, the log level will be changed to DEBUG.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
Decreases the log level.  If omitted, the default level will be set to
WARNING.  When this option is given, the log level is changed to ERROR.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span>
, </span><span class="term">
<span class="strong"><strong>--multiple-wf</strong></span>
</span>
</dt>
<dd>
Set this option when generating statistics over more than one workflow.
The tool automatically sets this flag if multiple submit directories or
multiple workflow UUIDs are provided. This option would need to be set
explicitly only to generate statistics over all workflows in a single
STAMPEDE database.
NOTE: When workflows are specified as UUIDs the --conf options
needs to be set for the tool to determine the STAMPEDE database
URL.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span>
, </span><span class="term">
<span class="strong"><strong>--ispmc</strong></span>
</span>
</dt>
<dd>
Set this flag to generate statistics for workflows which are run with
PMC clustering enabled. It is recommended that this option be used when
calculating statistics over multiple workflow runs.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-u</strong></span>
, </span><span class="term">
<span class="strong"><strong>--isuuid</strong></span>
</span>
</dt>
<dd>
Set this option if the positional argument are workflow UUIDs.
NOTE: When workflows are specified as UUIDs the --conf options
needs to be set for the tool to determine the STAMPEDE database
URL.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-statistics_example"></a><h2>Example</h2>
<p>Runs pegasus-statistics and writes the output to the given directory:</p>
<pre class="screen">$ pegasus-statistics  -o /scratch/statistics /scratch/grid-setup/run0001</pre>
<p>Runs pegasus-statistics over a workflow run identified by a single workflow UUID:</p>
<pre class="screen">$ pegasus-statistics  --conf pegasusrc --isuuid 316f2986-7754-44ec-8b38-fcd0cb602ce0</pre>
<p>Runs pegasus-statistics over a workflow run identified by a multiple workflow UUID:</p>
<pre class="screen">$ pegasus-statistics  --conf pegasusrc --isuuid 316f2986-7754-44ec-8b38-fcd0cb602ce0 \
7ef77af8-4eb2-45ca-b37d-c5a02186133a</pre>
<p>Runs pegasus-statistics over all workflows in the STAMPEDE database:</p>
<pre class="screen">$ pegasus-statistics  --conf pegasusrc --multiple-wf</pre>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-statistics_authors"></a><h2>Authors</h2>
<p>Prasanth Thomas
Rajiv Mayani</p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-sc-converter.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="reference.php#cli">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-status.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-sc-converter </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-status</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
