#!/bin/bash
#
# @package      hubzero-submit-monitors
# @file         genuserpki.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2015-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
trap onerror ERR

onerror() {
   if [ "${lock}" != "" ] ; then
      rm -f ${lock}
   fi
   exit 1
}

if [ $# -ne 2 ] ; then
   echo "usage: $0 jobKeyFile"
   exit 64
fi

exitStatus=0

jobKeyFile=$1
submitHost=`hostname -f`

pki=""
lock=""

if [ ! -d ${HOME}/.ssh ] ; then
   mkdir ${HOME}/.ssh
   chmod 700 ${HOME}/.ssh
fi
cd ${HOME}/.ssh

START=`date +"%s"`
while [ -f ${jobKeyFile}.lock ] ; do
   sleep 2
   NOW=`date +"%s"`
   ELAPSED=$(( ${NOW} - ${START} ))
   if [ ${ELAPSED} -gt 60 ] ; then
      rm ${jobKeyFile}.lock
   fi
done
lock=${PWD}/${jobKeyFile}.lock
touch ${lock}

if [ -f authorized_keys ] ; then
   KEYCOUNT=`grep "${jobKeyFile}@${submitHost}" authorized_keys | wc -l`
   if [ ${KEYCOUNT} -ne 1 ] ; then
      rm -f ${jobKeyFile} ${jobKeyFile}.pub
   fi
fi

if [ -f ${jobKeyFile} ] ; then
   if [ ! -f ${jobKeyFile}.pub ] ; then
      rm ${jobKeyFile}
   fi
fi
if [ -f ${jobKeyFile}.pub ] ; then
   if [ ! -f ${jobKeyFile} ] ; then
      rm ${jobKeyFile}.pub
   fi
fi
if [ -f ${jobKeyFile} ] ; then
   pki=${HOME}/.ssh/${jobKeyFile}
else
   if [ -f authorized_keys ] ; then
      sed -e "/${jobKeyFile}@${submitHost}/d" authorized_keys >  authorized_keys.${jobKeyFile}
      echo -e '\n'                                            >> authorized_keys.${jobKeyFile}
      cat -s authorized_keys.${jobKeyFile} > authorized_keys
      rm -f authorized_keys.${jobKeyFile}
   fi
   ssh-keygen -N "" -f ${jobKeyFile} -C "${jobKeyFile}@${submitHost}" > /dev/null
   chmod 600 ${jobKeyFile}.pub
   echo -n 'from="'${submitHost}'" ' >> authorized_keys
   cat ${jobKeyFile}.pub             >> authorized_keys
   pki=${HOME}/.ssh/${jobKeyFile}
fi
rm -f ${lock}

echo ${pki}

exit ${exitStatus}
