#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis2/killJob.py
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import sys
import json

from TapisAPI import TapisAPI
from TapisAPI import HTTPError

exitStatus = 0

tapisAPI = TapisAPI()

jobId = sys.argv[1]

body = json.loads("""{
                       "title": "AgavePy JobOperationRequest schema",
                       "action": "stop"
                     }
                  """)
#print(body)

try:
   job = tapisAPI.jobs.manage(body=body,jobId=jobId)
except HTTPError as err:
   exitStatus = 1
   sys.stderr.write(err.strerror)
   sys.stderr.write("\n")
except Exception as err:
   exitStatus = 1
   sys.stderr.write(str(err))
   sys.stderr.write("\n")

sys.exit(exitStatus)
