#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis/downloadJobOutputFile.py
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import sys
import os
import time

from TapisAPI import TapisAPI

MAXDOWNLOADFAILURES = 4

def downloadFile(uri,
                 localPath,
                 reTry=False):
   success = False
   nFail = 0
   while not success and nFail < MAXDOWNLOADFAILURES:
      try:
         response = tapisAPI.download_uri(uri=uri,local_path=localPath)
         success = True
      except:
         nFail += 1
         time.sleep(30)
      if not reTry:
         break

   return success


exitStatus = 0

tapisAPI = TapisAPI()

jobId         = sys.argv[1]
jobOutputFile = sys.argv[2]

success = False
nFail = 0
while not success and nFail < MAXDOWNLOADFAILURES:
   jobOutputs = tapisAPI.getJobOutputFilesList(jobId)
   if jobOutputs:
      success = True
   else:
      nFail += 1
      sys.stderr.write("Output list acquisition failed(%d) for job %s.\n" % (nFail,jobId))
      time.sleep(30)

#print(jobOutputs)
if jobOutputs:
   requestedJobOutputExists = False
   for jobOutput in jobOutputs:
      outputType = jobOutput['type']
      outputPath = jobOutput['path'].lstrip('/')
      outputURI  = jobOutput['_links']['self']['href']
#     print(outputPath,outputType,outputURI)
      if outputType == 'file':
         if outputPath == jobOutputFile:
            requestedJobOutputExists = True
            success = downloadFile(outputURI,os.path.basename(outputPath),reTry=True)
            if not success:
               exitStatus = 1
               sys.stderr.write("Download of %s failed.\n" % (outputPath))
            break
   if not requestedJobOutputExists:
      exitStatus = 1
      sys.stderr.write("Job output %s does not exist for job %s.\n" % (jobOutputFile,jobId))
else:
   exitStatus = 1
   sys.stderr.write("Job outputs for %s are not available.\n" % (jobId))

sys.exit(exitStatus)
