# @package      hubzero-submit-distributor
# @file         GroupMembership.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
"""Functions for determining if user is a member of a particular group.
   """
import os
import grp
import logging

from hubzero.submit.LogMessage import getLogJobIdMessage as getLogMessage

def isGroupMember(groupName):
   """
   Is user a member of group groupName?
   """
   try:
#     name,pswd,requestedGroupId,other = grp.getgrnam(groupName)
      _,_,requestedGroupId,_ = grp.getgrnam(groupName)
   except:
      logger = logging.getLogger(__name__)
      logger.log(logging.ERROR,getLogMessage("Unable to get gid of '%s'" % (groupName)))
      return False

   for groupId in os.getgroups():
      if groupId == requestedGroupId:
         return True

   return False


