#!/usr/bin/env python3
#
# @package      hubzero-submit-distributor
# @file         harvester.py
# @copyright    Copyright (c) 2018-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2018-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
"""Harvest results at completion of distributed job."""

import os
import sys
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.JobHarvester         import JobHarvester

DISTRIBUTORLOGLEVEL    = "ERROR"
DISTRIBUTORSYSLOGLOCAL = "LOCAL3"

#DISTRIBUTORLOGDIRECTORY = os.path.join(os.sep,'var','log','submit','distributor')
CONFIGURATIONDIRECTORY       = os.path.join(os.sep,'etc','submit')
DISTRIBUTORCONFIGURATIONFILE = 'distributor.conf'
DAEMONSDIRECTORY             = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE     = 'daemons.conf'
INFOSDIRECTORY               = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE       = 'infos.conf'

if __name__ == '__main__':
   distributorLogLevel          = os.getenv("DISTRIBUTORLOGLEVEL",DISTRIBUTORLOGLEVEL)
   distributorSysLogLocal       = os.getenv("DISTRIBUTORSYSLOGLOCAL",DISTRIBUTORSYSLOGLOCAL)
   configurationDirectory       = os.getenv("CONFIGURATIONDIRECTORY",CONFIGURATIONDIRECTORY)
   distributorConfigurationFile = os.getenv("DISTRIBUTORCONFIGURATIONFILE",DISTRIBUTORCONFIGURATIONFILE)
   daemonsDirectory             = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile     = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory               = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile       = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(DISTRIBUTORLOGLEVEL,
                                               DISTRIBUTORSYSLOGLOCAL)

   applicationUtilities.openSysLogLogger(distributorSysLogLocal,
                                         distributorLogLevel)

   harvester(configurationDirectory,distributorConfigurationFile,
             daemonsDirectory,daemonsConfigurationFile,
             infosDirectory,infosConfigurationFile)


