#!/usr/bin/env python
#
# @package      hubzero-submit-distributor
# @file         monitorJobR.py
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
# ----------------------------------------------------------------------
#  monitorJobR.py
#
#  script which queries monitorJob.py for active job(s) at site
#
import sys
import time

from RemoteJobMonitor import RemoteJobMonitor

JOBMONITORHOST = ""
JOBMONITORPORT = 5727

def monitorJobR():
   """Report active jobs"""
   if   len(sys.argv) == 3:
      messageSite = sys.argv[1]
      localJobId  = sys.argv[2]
   elif len(sys.argv) == 2:
      messageSite = sys.argv[1]
      localJobId  = '*'
   else:
      messageSite = '*'
      localJobId  = '*'

   remoteJobMonitor = RemoteJobMonitor(JOBMONITORHOST,JOBMONITORPORT)

   lastReportTime,report = remoteJobMonitor.queryRemoteActiveJobStatus(messageSite,localJobId)
   if len(report) > 0:
      print "Current time              %s" % (time.ctime())
      print "Last time status reported %s" % (time.ctime(lastReportTime))

      sites = report.split('|')
      for site in sites:
         queues = site.split('@')
         messageSite,lastReportTime = queues[0].split()
         print "\nReport for monitor %s" % (messageSite)
         print "   Last time status reported %s" % (time.ctime(float(lastReportTime)))
         del queues[0]

         for queue in queues:
            jobs = queue.split(':')
            print "   Queue %s" % (jobs[0])
            del jobs[0]

            reportedJobs = {}
            for job in jobs:
               jobId,status,state = job.split()
               if not status in reportedJobs:
                  reportedJobs[status] = {}
               try:
                  reportedJobs[status][int(float(jobId))] = state
               except:
                  print "job poorly formatted: %s" % (job)

            for status in reportedJobs.keys():
               print "      Jobs in status: %s" % (status)

               jobIds = reportedJobs[status].keys()
               jobIds.sort()
               for jobId in jobIds:
                  print "         %d  %s" % (jobId,reportedJobs[status][jobId])

            del reportedJobs
   else:
      print "Current time %s" % (time.ctime())
      print "No jobs currently being processed"


if __name__ == '__main__':
   monitorJobR()

