#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/solarisscript/submitbatchjob.sh
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
if [ $# -lt 2 ] ; then
   echo usage: $0 jobWorkingDirectory command
   exit 64
fi

PATH=${HOME}/bin:${PATH}:/usr/ucb
export PATH

workingDirectory=$1
shift

cd $workingDirectory
exitStatus=$?

if [ $exitStatus -eq 0 ] ; then
   "$@"
   exitStatus=$?
fi

exit $exitStatus

