#!/usr/bin/env python
#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
# ----------------------------------------------------------------------
#  monitorTunnelR.py
#
#  script which reports monitor status for all ssh tunnels
#
import sys

from RemoteTunnelMonitor import RemoteTunnelMonitor

remoteTunnelMonitorHost = ""
remoteTunnelMonitorPort = 5729


if __name__ == '__main__':

   if len(sys.argv) > 1:
      tunnelName = sys.argv[1]
   else:
      tunnelName = ""

   remoteTunnelMonitor = RemoteTunnelMonitor(remoteTunnelMonitorHost,remoteTunnelMonitorPort)

   report = remoteTunnelMonitor.reportTunnelUse(tunnelName)
   print("\n%-30s  %s" % ("Tunnel","useCount"))
   tunnels = report.split(':')
   for tunnel in tunnels:
      if tunnel != "":
         tunnelName,useCount = tunnel.split()
         print("%-30s  %s" % (tunnelName,useCount))

