#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import sys
import time

from LogMessage  import logID as log
from MessageCore import MessageCore

class RemoteJobMonitor(MessageCore):
   def __init__(self,
                host,
                port,
                repeatDelay=5,
                fixedBufferSize=64):
      MessageCore.__init__(self,listenerHost=host,listenerPort=port,repeatDelay=repeatDelay)
      self.fixedBufferSize = fixedBufferSize


   def postNewJobSubmission(self,
                            siteMonitorDesignator,
                            remoteJobId):
      queryMessage = "S:" + siteMonitorDesignator + " " + remoteJobId
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize)

      log("confirmation: S(%d):%s" % (nTry,response))


   def queryRemoteJobStatus(self,
                            siteMonitorDesignator,
                            remoteJobId):
      queryMessage = "Q:" + siteMonitorDesignator + " " + remoteJobId
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize)

      if nTry > 1:
         log("confirmation: Q(%d):%s" % (nTry,response))

      jobStatus,jobStage = response.strip().split()
      if ';' in jobStage:
         jobStage,jobSite = jobStage.split(';')
      else:
         jobSite = "?"
      if jobStage == "?":
         jobStage = "Job"

      return(jobStatus,jobStage,jobSite)


   def terminateRemoteJob(self,
                          siteMonitorDesignator,
                          remoteJobId):
      queryMessage = "T:" + siteMonitorDesignator + " " + remoteJobId
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize)

      log("confirmation: T(%d):%s" % (nTry,response))


   def queryRemoteActiveJobStatus(self,
                                  siteMonitorDesignator,
                                  remoteJobId):
      queryMessage = "R:" + siteMonitorDesignator + " " + remoteJobId
      nTry,report,lastReportTime = self.requestMessageTimestampedResponse(queryMessage,
                                                                          self.fixedBufferSize,
                                                                          self.fixedBufferSize)

      if nTry > 1:
         log("confirmation: R(%d):%s" % (nTry,lastReportTime))

      return(float(lastReportTime),report)


   def waitForBatchJob(self,
                       siteMonitorDesignator,
                       remoteJobId,
                       knownSite=""):
      jobStatusMessages = {}
      jobStatusMessages['N']       = 'Submitted'
      jobStatusMessages['I']       = 'Idle'
      jobStatusMessages['Q']       = 'Queued'
      jobStatusMessages['H']       = 'Held'
      jobStatusMessages['R']       = 'Running'
      jobStatusMessages['C']       = 'Complete'
      jobStatusMessages['X']       = 'Marked For Deletion'
      jobStatusMessages['E']       = 'Exiting'
      jobStatusMessages['T']       = 'Moving'
      jobStatusMessages['W']       = 'Waiting'
      jobStatusMessages['S']       = 'Suspended'
      jobStatusMessages['D']       = 'Done'
      jobStatusMessages['CA']      = 'Cancelled'
      jobStatusMessages['CD']      = 'Completed'
      jobStatusMessages['CG']      = 'Completing'
      jobStatusMessages['F']       = 'Failed'
      jobStatusMessages['NF']      = 'Node_Fail'
      jobStatusMessages['PD']      = 'Pending'
      jobStatusMessages['TO']      = 'Timeout'
      jobStatusMessages['CK']      = 'Checkpointing'
      jobStatusMessages['CP']      = 'Complete Pending'
      jobStatusMessages['DF']      = 'Deferred'
      jobStatusMessages['NQ']      = 'Not Queued'
      jobStatusMessages['NR']      = 'Not Run'
      jobStatusMessages['P']       = 'Pending'
      jobStatusMessages['EP']      = 'Preempt Pending'
      jobStatusMessages['XP']      = 'Reject Pending'
      jobStatusMessages['RM']      = 'Removed'
      jobStatusMessages['RP']      = 'Remove Pending'
      jobStatusMessages['MP']      = 'Resume Pending'
      jobStatusMessages['ST']      = 'Starting'
      jobStatusMessages['TX']      = 'Terminated'
      jobStatusMessages['V']       = 'Vacated'
      jobStatusMessages['VP']      = 'Vacate Pending'
      jobStatusMessages['HS']      = 'User & System Hold'
      jobStatusMessages['PT']      = 'Preempted'
      jobStatusMessages['RJ']      = 'Rejected'
      jobStatusMessages['SH']      = 'System Hold'
      jobStatusMessages['DEFAULT'] = 'Returning Results...'

      minimumDelay = 5       #  5 10 20 40 80 160 320
      maximumDelay = 320
      updateFrequency = 5
      maximumReportDelay = 320

      delayTime = 0
      sleepTime = minimumDelay
      nDelays = 0
      timeLastReported = delayTime
      currentJobStatus,currentJobStage,currentJobSite = self.queryRemoteJobStatus(siteMonitorDesignator,remoteJobId)
      if currentJobSite == "" or currentJobSite == "?":
         if knownSite != "":
            currentJobSite = knownSite
      if currentJobSite == "" or currentJobSite == "?":
         log("status:%s %s" % (currentJobStage,currentJobStatus))
         sys.stdout.write("(%s) %s %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],time.ctime()))
         sys.stdout.flush()
      else:
         log("status:%s %s %s" % (currentJobStage,currentJobStatus,currentJobSite))
         sys.stdout.write("(%s) %s %s at %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],currentJobSite,time.ctime()))
         sys.stdout.flush()

      previousJobStatus = currentJobStatus
      previousJobStage  = currentJobStage
      previousJobSite   = currentJobSite
      while currentJobStatus != "D":
         nDelays += 1
         time.sleep(sleepTime)
         delayTime += sleepTime
         if nDelays == updateFrequency:
            nDelays = 0
            sleepTime *= 2
            if sleepTime > maximumDelay:
               sleepTime = maximumDelay
         currentJobStatus,currentJobStage,currentJobSite = self.queryRemoteJobStatus(siteMonitorDesignator,remoteJobId)
         if currentJobSite == "" or currentJobSite == "?":
            if knownSite != "":
               currentJobSite = knownSite
         if currentJobStatus != previousJobStatus or currentJobStage != previousJobStage or currentJobSite != previousJobSite:
            if currentJobSite == "" or currentJobSite == "?":
               log("status:%s %s" % (currentJobStage,currentJobStatus))
               sys.stdout.write("(%s) %s %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],time.ctime()))
               sys.stdout.flush()
            else:
               log("status:%s %s %s" % (currentJobStage,currentJobStatus,currentJobSite))
               sys.stdout.write("(%s) %s %s at %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],currentJobSite,time.ctime()))
               sys.stdout.flush()
            previousJobStatus = currentJobStatus
            previousJobStage  = currentJobStage
            previousJobSite   = currentJobSite
            timeLastReported = delayTime
            sleepTime = minimumDelay
            nDelays = 0
         else:
            if delayTime >= (timeLastReported + maximumReportDelay):
               if currentJobSite == "" or currentJobSite == "?":
                  sys.stdout.write("(%s) %s %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],time.ctime()))
                  sys.stdout.flush()
               else:
                  sys.stdout.write("(%s) %s %s at %s %s\n" % (remoteJobId,currentJobStage,jobStatusMessages[currentJobStatus],currentJobSite,time.ctime()))
                  sys.stdout.flush()
               timeLastReported = delayTime


