#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import re
import random

class RemoteInstantSCRIPT:
   def __init__(self,
                localJobId,
                workingDirectory,
                appScriptName,
                isMultiCoreRequest,
                computationMode,
                preManagerCommands,
                managerCommand,
                postManagerCommands,
                nNodes,
                ppn,
                venue,
                venues,
                venueIndex,
                TIMESTAMPTRANSFERRED,
                TIMESTAMPSTART,
                TIMESTAMPFINISH,
                TIMERESULTS):
      self.localJobId           = localJobId
      self.workingDirectory     = workingDirectory
      self.appScriptName        = appScriptName
      self.isMultiCoreRequest   = isMultiCoreRequest
      self.computationMode      = computationMode
      self.preManagerCommands   = preManagerCommands
      self.managerCommand       = managerCommand
      self.postManagerCommands  = postManagerCommands
      self.nNodes               = nNodes
      self.ppn                  = ppn
      self.venue                = venue
      self.venues               = venues
      self.venueIndex           = venueIndex
      self.TIMESTAMPSTART       = TIMESTAMPSTART
      self.TIMESTAMPFINISH      = TIMESTAMPFINISH
      self.TIMESTAMPTRANSFERRED = TIMESTAMPTRANSFERRED
      self.TIMERESULTS          = TIMERESULTS

      self.nodeFileName = ""
      self.nodeList     = []


   def __makeSubmitMPITemplate(self):
      return """#!/bin/sh

trap cleanup HUP INT QUIT ABRT TERM

cleanup()
{
#  echo "Abnormal termination by signal"
#  kill -s TERM `jobs -p`
   mpirunPidTree=$(pstree -l -p `jobs -p`)
   mpirunPidTreeMaster=${mpirunPidTree%%-[rs]sh(*}
   appPidTree=${mpirunPidTreeMaster##*(}
   appPid=${appPidTree%%)*}
   kill -s TERM ${appPid}
   if [ ! -s TS_FINISH ] ; then
      date +"%s" > TS_FINISH
   fi
#  exit 1
}

# Change to directory where job was submitted.
cd WORKINGDIRECTORY
export PATH=WORKINGDIRECTORY:${PATH}

date +"%s" > TS_TRANSFERRED
date +"%s" > TS_START

PREMANAGERCOMMANDS
#MANAGERCOMMAND `pwd`/APPSCRIPTNAME > JOBID.stdout 2> JOBID.stderr
MANAGERCOMMAND `pwd`/APPSCRIPTNAME &
wait %1
POSTMANAGERCOMMANDS

date +"%s" > TS_FINISH

touch TIME_RESULTS-0
cat TIME_RESULTS-[0-9]* >> TIME_RESULTS
rm -f TIME_RESULTS-[0-9]*
"""


   def __buildSubmitMPIFile(self):
      # setup regex's for the template
      re_preManagerCommands  = re.compile("PREMANAGERCOMMANDS")
      re_managerCommand      = re.compile("MANAGERCOMMAND")
      re_postManagerCommands = re.compile("POSTMANAGERCOMMANDS")
      re_nnodes              = re.compile("NNODES")
      re_processors          = re.compile("NPROCESSORS")
      re_appScriptName       = re.compile("APPSCRIPTNAME")
      re_tsTransferred       = re.compile("TS_TRANSFERRED")
      re_tsStart             = re.compile("TS_START")
      re_tsFinish            = re.compile("TS_FINISH")
      re_timeResults         = re.compile("TIME_RESULTS")
      re_jobid               = re.compile("JOBID")
      re_workingDirectory    = re.compile("WORKINGDIRECTORY")
      re_nodeFile            = re.compile("\${PBS_NODEFILE}")

      template = self.__makeSubmitMPITemplate()

      template = re_preManagerCommands.sub("\n".join(self.preManagerCommands),template)
      template = re_postManagerCommands.sub("\n".join(self.postManagerCommands),template)
      template = re_managerCommand.sub(self.managerCommand,template)
      template = re_nnodes.sub(self.nNodes,template)
      nProcessors = str(int(self.nNodes)*int(self.ppn))
      template = re_processors.sub(nProcessors,template)
      template = re_appScriptName.sub(self.appScriptName,template)
      template = re_tsTransferred.sub(self.TIMESTAMPTRANSFERRED,template)
      template = re_tsStart.sub(self.TIMESTAMPSTART,template)
      template = re_tsFinish.sub(self.TIMESTAMPFINISH,template)
      template = re_timeResults.sub(self.TIMERESULTS,template)
      template = re_jobid.sub(self.localJobId,template)
      template = re_workingDirectory.sub(self.workingDirectory,template)
      template = re_nodeFile.sub(self.nodeFileName,template)

      return(template)


   def __buildNodeList(self):
      del self.nodeList
      self.nodeList = []
      self.nodeFileName = self.localJobId + '.machinelist'

      nProcessors = int(self.nNodes)*int(self.ppn)
      for core in xrange(int(self.ppn)):
         self.nodeList.append(self.venue)
      eligible = range(len(self.venues))
      eligible.remove(self.venueIndex)
      for node in xrange(int(self.nNodes) - 1):
         index = eligible[random.randint(0,len(eligible)-1)]
         enclosure = self.venues[index]
         for core in xrange(int(self.ppn)):
            self.nodeList.append(enclosure)
         eligible.remove(index)
         if len(eligible) == 0:
            eligible = range(len(self.venues))


   def buildBatchScript(self):
      batchScriptName = ""
      if self.isMultiCoreRequest:
         if   self.computationMode == 'mpi':
            self.__buildNodeList()
            batchScript = self.__buildSubmitMPIFile()
            batchScriptName = self.localJobId + '.cl'
         elif self.computationMode == 'parallel':
            batchScript = ""
         elif self.computationMode == 'matlabmpi':
            batchScript = ""
      else:
         batchScript = ""

      return(batchScriptName,batchScript,self.nodeFileName,self.nodeList)


