'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/doctools/doctoc_lang_cmdref.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctoc_lang_cmdref" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
doctoc_lang_cmdref \- doctoc language command reference
.SH SYNOPSIS
\fBcomment\fR \fIplaintext\fR
.sp
\fBdivision_end\fR
.sp
\fBdivision_start\fR \fItext\fR ?\fIsymfile\fR?
.sp
\fBinclude\fR \fIfilename\fR
.sp
\fBitem\fR \fIfile\fR \fItext\fR \fIdesc\fR
.sp
\fBlb\fR
.sp
\fBrb\fR
.sp
\fBtoc_begin\fR \fItext\fR \fItitle\fR
.sp
\fBtoc_end\fR
.sp
\fBvset\fR \fIvarname\fR \fIvalue\fR
.sp
\fBvset\fR \fIvarname\fR
.sp
.BE
.SH DESCRIPTION
.PP
This document specifies both names and syntax of all the commands
which together are the doctoc markup language, version 1.
As this document is intended to be a reference the commands are listed
in alphabetical order, and the descriptions are relatively short.
A beginner should read the much more informally written
\fIdoctoc language introduction\fR first.
.SH COMMANDS
.TP
\fBcomment\fR \fIplaintext\fR
Toc markup. The argument text is marked up as a comment standing
outside of the actual text of the document. Main use is in free-form
text.
.TP
\fBdivision_end\fR
Toc structure. This command closes the division opened by the last
\fBdivision_begin\fR command coming before it, and not yet closed.
.TP
\fBdivision_start\fR \fItext\fR ?\fIsymfile\fR?
Toc structure. This command opens a division in the table of
contents. Its counterpart is \fBdivision_end\fR. Together they allow a
user to give a table of contents additional structure.
.sp
The title of the new division is provided by the argument \fItext\fR.
.sp
If the symbolic filename \fIsymfile\fR is present then the section
title should link to the referenced document, if links are supported
by the output format.
.TP
\fBinclude\fR \fIfilename\fR
Templating. The contents of the named file are interpreted as text
written in the doctoc markup and processed in the place of the
include command. The markup in the file has to be self-contained. It
is not possible for a markup command to cross the file boundaries.
.TP
\fBitem\fR \fIfile\fR \fItext\fR \fIdesc\fR
Toc structure. This command adds an individual element to the table of
contents. Each such element refers to a document. The document is
specified through the symbolic name \fIfile\fR. The \fItext\fR
argument is used to label the reference, whereas the \fIdesc\fR
provides a short descriptive text of that document.
.sp
The symbolic names are used to preserve the convertibility of this
format to any output format. The actual name of the file will be
inserted by the chosen formatting engine when converting the
input. This will be based on a mapping from symbolic to actual names
given to the engine.
.TP
\fBlb\fR
Text. The command is replaced with a left bracket. Use in free-form
text. Required to avoid interpretation of a left bracket as the start
of a markup command. Its usage is restricted to the arguments of other
markup commands.
.TP
\fBrb\fR
Text. The command is replaced with a right bracket. Use in free-form
text. Required to avoid interpretation of a right bracket as the end
of a markup command. Its usage is restricted to the arguments of other
commands.
.TP
\fBtoc_begin\fR \fItext\fR \fItitle\fR
Document structure. The command to start a table of contents. The
arguments are a label for the whole group of documents the index
refers to (\fItext\fR) and the overall title text for the index
(\fItitle\fR), without markup.
.sp
The label often is the name of the package (or extension) the
documents belong to.
.TP
\fBtoc_end\fR
Document structure. Command to end a table of contents. Anything in
the document coming after this command is in error.
.TP
\fBvset\fR \fIvarname\fR \fIvalue\fR
Templating. In this form the command sets the named document variable
to the specified \fIvalue\fR. It does not generate output. I.e. the
command is replaced by the empty string.
.TP
\fBvset\fR \fIvarname\fR
Templating. In this form the command is replaced by the value of the
named document variable
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIdoctools\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
doctoc_intro, doctoc_lang_faq, doctoc_lang_intro, doctoc_lang_syntax
.SH KEYWORDS
doctoc commands, doctoc language, doctoc markup, markup, semantic markup
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi