'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/transfer/receiver.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "transfer::receiver" n 0.2 transfer "Data transfer facilities"
.BS
.SH NAME
transfer::receiver \- Data source
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBsnit  ?1.0?\fR
.sp
package require \fBtransfer::data::destination  ?0.2?\fR
.sp
package require \fBtransfer::connect  ?0.2?\fR
.sp
package require \fBtransfer::receiver  ?0.2?\fR
.sp
\fBtransfer::receiver\fR \fIobject\fR ?\fIoptions\fR...?
.sp
\fBtransfer::receiver\fR \fBstream channel\fR \fIchan\fR \fIhost\fR \fIport\fR ?\fIarg\fR...?
.sp
\fBtransfer::receiver\fR \fBstream file\fR \fIpath\fR \fIhost\fR \fIport\fR ?\fIarg\fR...?
.sp
\fIobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBstart\fR
.sp
\fIobjectName\fR \fBbusy\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package pulls data destinations and connection setup together
into a combined object for the reception of information coming in over
a socket.
These objects understand all the options from objects created by the
packages \fBtransfer::data::destination\fR and
\fBtransfer::connect\fR.
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fBtransfer::receiver\fR \fIobject\fR ?\fIoptions\fR...?
This command creates a new receiver object with an associated Tcl
command whose name is \fIobjectName\fR.
This \fIobject\fR command is explained in full detail in the sections
\fBObject command\fR and \fBObject methods\fR. The set of
supported \fIoptions\fR is explained in section \fBOptions\fR.
.sp
The object command will be created under the current namespace if the
\fIobjectName\fR is not fully qualified, and in the specified
namespace otherwise.
The fully qualified name of the object command is returned as the
result of the command.
.TP
\fBtransfer::receiver\fR \fBstream channel\fR \fIchan\fR \fIhost\fR \fIport\fR ?\fIarg\fR...?
This method creates a fire-and-forget transfer for the data coming
from the source at host/port (details below) and writing to the
channel \fIchan\fR, starting at the current seek location. The channel
is configured to use binary translation and encoding for the transfer.
The channel is \fInot\fR closed when the transfer has completed. This
is left to the completion callback.
.sp
If both \fIhost\fR and \fIport\fR are provided an \fBactive\fR
connection to the data source is made. If only a \fIport\fR is
specified (with \fIhost\fR the empty string) then a \fBpassive\fR
connection is made instead, i.e. the receiver then waits for a
conneciton by the transmitter.
.sp
Any arguments after the port are treated as options and are used to
configure the internal receiver object.
See the section \fBOptions\fR for a list of the supported options
and their meaning.
\fINote\fR however that the signature of the command prefix specified
for the \fB-command\fR callback differs from the signature for the
same option of the receiver object.
This callback is only given the number of bytes and transfered, and
possibly an error message. No reference to the internally used
receiver object is made.
.sp
The result returned by the command is the empty string
if it was set to make an \fIactive\fR connection, and the port the
internal receiver object is listening on otherwise, i.e when it is
configured to connect \fIpassive\fRly.
See also the package \fBtransfer::connect\fR and the description
of the method \fBconnect\fR for where this behaviour comes from.
.TP
\fBtransfer::receiver\fR \fBstream file\fR \fIpath\fR \fIhost\fR \fIport\fR ?\fIarg\fR...?
This method is like \fBstream channel\fR, except that the
received data is written to the file \fIpath\fR, replacing any prior
content.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::transfer::receiver\fR command have the
following general form:
.TP
\fIobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command.
See section \fBObject methods\fR for the detailed
specifications.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object. Doing so while a reception is on
progress will cause errors later on, when the reception completes
and tries to access the now missing data structures of the destroyed
object.
.TP
\fIobjectName\fR \fBstart\fR
This method initiates the data reception, setting up the connection
first and then copying the received information into the
destination.
The method will throw an error if a reception is already/still in
progress.
I.e. it is not possible to run two receptions in parallel, only in
sequence.
Errors will also be thrown if the configuration of the data
destination is invalid, or if no completion callback was specified.
.sp
The result returned by the method is the empty string
for an object configured to make an \fIactive\fR connection, and the port the
object is listening on otherwise, i.e when it is
configured to connect \fIpassive\fRly.
See also the package \fBtransfer::connect\fR and the description
of the method \fBconnect\fR for where this behaviour comes from.
.TP
\fIobjectName\fR \fBbusy\fR
This method returns a boolean value telling us whether a reception
is in progress (\fBTrue\fR), or not (\fBFalse\fR).
.PP
.SS OPTIONS
All receiver objects support the union of the options supported by
their connect and data destination components, plus one of their own.
See also the documentation for the packages
\fBtransfer::data::destination\fR and \fBtransfer::connect\fR.
.TP
\fB-command\fR \fIcmdprefix\fR
This option specifies the command to invoke when the reception of
the information has been completed.
The arguments given to this command are the same as given to the
completion callback of the command \fBtransfer::copy::do\fR provided
by the package \fBtransfer::copy\fR.
.TP
\fB-mode\fR \fImode\fR
This option specifies the mode the object is in. It is optional and
defaults to \fBactive\fR mode. The two possible modes are:
.RS
.TP
\fBactive\fR
In this mode the two options \fB-host\fR and \fB-port\fR are
relevant and specify the host and TCP port the object has to connect
to. The host is given by either name or IP address.
.TP
\fBpassive\fR
In this mode the option \fB-host\fR has no relevance and is ignored
should it be configured.
The only option the object needs is \fB-port\fR, and it specifies
the TCP port on which the listening socket is opened to await the
connection from the partner.
.RE
.TP
\fB-host\fR \fIhostname-or-ipaddr\fR
This option specifies the host to connect to in \fIactive\fR mode,
either by name or ip-address. An object configured for \fIpassive\fR
mode ignores this option.
.TP
\fB-port\fR \fIint\fR
For \fIactive\fR mode this option specifies the port the object is
expected to connect to. For \fIpassive\fR mode however it is the port
where the object creates the listening socket waiting for a
connection. It defaults to \fB0\fR, which allows the OS to choose
the actual port to listen on.
.TP
\fB-socketcmd\fR \fIcommand\fR
This option allows the user to specify which command to use to open a
socket. The default is to use the builtin \fB::socket\fR. Any
compatible with that command is allowed.
.sp
The envisioned main use is the specfication of \fBtls::socket\fR. I.e.
this option allows the creation of secure transfer channels, without
making this package explicitly dependent on the \fBtls\fR package.
.sp
See also section \fBSecure connections\fR.
.TP
\fB-encoding\fR encodingname
.TP
\fB-eofchar\fR eofspec
.TP
\fB-translation\fR transspec
These options are the same as are recognized by the builtin command
\fBfconfigure\fR. They provide the configuration to be set for the
channel between the two partners after it has been established, but
before the callback is invoked (See method \fBconnect\fR).
.TP
\fB-channel\fR \fIhandle\fR
This option specifies that the destination of the data is a channel,
and its associated argument is the handle of the channel to write the
received data to.
.TP
\fB-file\fR \fIpath\fR
This option specifies that the destination of the data is a file, and
its associated argument is the path of the file to write the received
data to.
.TP
\fB-variable\fR \fIvarname\fR
This option specifies that the destination of the data is a variable,
and its associated argument contains the name of the variable to write
the received data to. The variable is assumed to be global or
namespaced, anchored at the global namespace.
.TP
\fB-progress\fR \fIcommand\fR
This option, if specified, defines a command to be invoked for each
chunk of bytes received, allowing the user to monitor the progress of
the reception of the data. The callback is always invoked with one
additional argument, the number of bytes received so far.
.PP
.SH "SECURE CONNECTIONS"
One way to secure connections made by objects of this package is to
require the package \fBtls\fR and then configure the option
\fB-socketcmd\fR to force the use of command \fBtls::socket\fR to
open the socket.
.nf

    # Load and initialize tls
    package require tls
    tls::init -cafile /path/to/ca/cert -keyfile ...

    # Create a connector with secure socket setup,
    transfer::receiver R -socketcmd tls::socket ...
    ...

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItransfer\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
channel, copy, data destination, receiver, secure, ssl, tls, transfer
.SH CATEGORY
Transfer module
.SH COPYRIGHT
.nf
Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi