#!/bin/sh

# Fail script on error.
set -e

host_os=`uname -s`
echo $system

base_dir=/apps/rappture
build_dir=$base_dir/`date +%Y%m%d`_render
mkdir -p $build_dir

stage1_flags=" \
 --without-cmake
"
stage2_flags=" \
 --without-blt \
 --without-htmlwidget \
 --without-itk \
 --without-shape \
 --without-tDOM \
 --without-tcllib \
 --without-tkimg \
 --without-tls \
"
stage3_flags=" \
 --with-pymol
 --without-vtk
"
rappture_flags=""
vizserver_flags="--with-rappture=$build_dir"

MAKE=make
case $host_os in 
   *Darwin* )
      DYLD_LIBRARY_PATH=$build_dir/lib
      export DYLD_LIBRARY_PATH
      ;;
   *Linux*  )
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
   *FreeBSD* )
      MAKE=gmake
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
esac

PATH=/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/bin/X11:/usr/X11/bin:/usr/openwin/bin:$build_dir/bin

export MAKE PATH


stage1() {
    pwd=`pwd`
    if test -d "render/stage1" ; then 
      cd render/stage1
    else 
      mkdir -p render/stage1
      cd render/stage1
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage1_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage2() {
    pwd=`pwd`
    if test -d "render/stage2" ; then 
      cd render/stage2
    else 
      mkdir -p render/stage2
      cd render/stage2
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage2_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage3() {
    pwd=`pwd`
    if test -d "render/stage3" ; then 
      cd "render/stage3"
    else 
      mkdir -p render/stage3
      cd render/stage3
      ../../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage3_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

rappture() {
    pwd=`pwd`
    if test -d "render/stage.rappture" ; then 
      cd render/stage.rappture
    else 
      mkdir -p render/stage.rappture
      cd render/stage.rappture
      ../../rappture/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $rappture_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

vizservers() {
    pwd=`pwd`
    if test -d "render/stage.vizservers" ; then 
      cd "render/stage.vizservers"
    else 
      mkdir -p render/stage.vizservers
      cd render/stage.vizservers
      ../../rappture/packages/vizservers/configure --prefix=$build_dir \
       --exec_prefix=$build_dir $vizserver_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage1
stage2
stage3
rappture
vizservers

exit 0
