# @package      hubzero-python
# @file         passwords.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

import base64
import re
import hashlib
import hubzero.config
import random
import string


secretsFileLocation = "/etc/hubzero.secrets"


def _getSecretsConfigOption(optionName):
	# read config values from file
	file = open(secretsFileLocation)
	fileContents = file.read()
	
	# grep for right line
	m = re.search("^\s*" + optionName + "\s*=\s*(.*)$", fileContents, re.MULTILINE)

	# return whatever we find, if not found, this will be none type
	if m:
		return m.group(1).rstrip()
	else:
		return ""


def generateAlphaNumPassword(length):
	pw = ''.join(random.choice(string.ascii_uppercase + string.ascii_lowercase + string.digits) for x in range(length))	
	return pw		    

		    
def getMySqlPW():
	return _getSecretsConfigOption("MYSQL-ROOT")


def MD5PasswordHash(pw):
	return "{MD5}" + base64.b64encode(hashlib.md5(str(pw)).digest())
