# @package      hubzero-python
# @file         setup.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
'''
hubzero-python is a library of python
routines for manipulating the HUBzero
platform.
'''

classifiers = '''\
Development Status :: 5 - Production/Stable
License :: OSI Approved :: MIT License
Operating System :: POSIX :: Linux
Programming Language :: Python\
'''.split('\n')

import os
from setuptools import setup

setup(
    name='hubzero-python',
    version='2.1.9-1',
    license = 'MIT License',
    description='HUBzero Python common python library',
    classifiers = classifiers,
    url='http://hubzero.org',
    author='Nicholas J. Kisseberth',
    author_email='nkisseberth@ucsd.edu',
    packages=['hubzero', 'hubzero.utilities', 'hubzero.data', 'hubzero.config'],
)

# vim:ts=4 sw=4 et
