# @package      hubzero-mw2-common
# @file         constants.template
# @copyright    Copyright (c) 2016-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Based on previous work by Richard L. Kennell and Nicholas Kisseberth
#
# Copyright (c) 2016-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

# This file will be processed to generate constants.py
# IT WILL NOT BE INSTALLED AS IS

# This file is to contain paths and other values unlikely to vary between revisions
# to the software.  It is not to contain secrets (e.g., passwords) and things likely to change
# periodically on a given Hub; use the configuration file for that.

#=============================================================================
# CONSTANTS
#=============================================================================
# In a correctly configured system, the following paths should be correct
# Constants are provided in a dictionary for ease of testing and flexibility
# Constants are separated according to the class in which they are used:

VERBOSE = True # True or False.  True:  increase log level for debugging

# Constants for the Host class
HOST_K = {
  "KEY_PATH" : '/etc/mw-client/maxwell.key',
  "NOTIFY_KEY": '/etc/mw-service/notify.key',
  "FS_PATH": '/usr/bin/maxwell_fs', # remote commands on file server
  "SERVICE_PATH": '/usr/bin/maxwell_service', # remote commands on execution hosts
  "MAXWELL_PATH": '/usr/bin/maxwell', # for ssh forced command when an execution host talks back
  "SVC_HOST_USER": 'root',
  "LOCK_PATH": '/var/log/mw-service',
  "WIN_SERVICE_PATH": 'C:/usr/bin/maxwell_service.py',
  "WIN_HOSTREQ": 'windowshost',
  "WINDOWS_SUPPORT": False,
  "DO_SUBMIT": False
}

# Constants for the Display class
DISPLAY_K = {
  "LOG_PATH" : '/var/log/mw-client'
}

# Constants for the App class
APP_K  = {
  "TOOL_TABLE": "_tool_version",
  "HOST_TABLE": "_tool_version_hostreq",
  "HOST_REQ_DEFAULTS": ['sessions'],
  "DEPTH_DEFAULT" : 24,
  # this is used by expire-sessions.py to determine when to kill an abandoned session
  "TIMEOUT_DEFAULT": 86400
}

# Constants for the Session class
SESSION_K = {
  "CONNECT_FORMAT": "vncsession:%s",
  "JAVA_SUPPORT_LINK": "/kb/misc/java/",
  # where old .err and .out files are stored for terminated sessions
  "LOG_PATH": '/var/log/mw-client/sessions',
  # where to store .err and .out files for open sessions (currently running tools)
  "SERVICE_LOG_PATH": "/var/log/mw-service/open-sessions", 
  # Service path for Windows support depends on whether this is a local or remote call...
  # Where to store .err and .out files for an application on a windows execution host
  # WEBSERVER_LOG_PATH is for remote usage (e.g., from the web server)
  "WIN_S_WEBSERVER_LOG_PATH": "/c/var/log/mw-service/open-sessions", # used for ssh and scp commands (they do not like colons in path)
  # WIN_S_EXEC_HOST_LOG_PATH is for local usage (e.g., on an execution host)
  "WIN_S_EXEC_HOST_LOG_PATH": "c:/var/log/mw-service/open-sessions", # used for creating/opening the .err and .out files (windows)
  "APP_K": APP_K,
  # applet path is something like "/core/components/com_tools/scripts/VncViewer-20150319-01.jar", or empty to let the web server decide
  "JAVA_APPLET_PATH": "",
  "NOVNC": False,
  "VNC_PROXY_PORT":443
}

# Constants for the Container class
CONTAINER_K = {
  "LOCAL_SESSIONDIR": False,
  "MAX_CONTAINERS": 1000,
  "SSHFS_MOUNT": False,
  "SSHFS_MOUNT_POINTS": [],
  "SSHFS_MOUNT_KEY": "",
  "PROJECT_MOUNT": False,
  "PROJECT_PUBLIC_MOUNT": False,
  "PROJECT_PUBLIC_PATH": "/srv/projects",
  "USER_MOUNT": False,
  "USER_MOUNT_POINTS": ["/home/sdata/", "/home/scratch/"],
  "LOCAL_SESSIONDIR": False,
  "APPS_READONLY": True, # mount /apps read-only, rw if member of apps group
  "FW_CHAIN": "FORWARD", # set to "AUTO_FORWARD" if the firewall uses the ogre configuration
  # set INPUT_CHAIN to "" if the web server is NOT an execution host. 
  # Set to "AUTO_INPUT" if the firewall uses the ogre configuration , "INPUT" otherwise
  "INPUT_CHAIN": "", 
  "PORTBASE": 5000,  # VNC port = VNC display number + PORTBASE
  "NETWORK_GROUP": 'network',
  "MATLAB_GROUP": "changeme",	# example, change or override this in mw2-client.conf
  "SSH_GROUP": "changeme",	# example, change or override this in mw2-client.conf
  "MYSQL_GROUP": "hubmysql",
  "MATLAB_LICENSE_SERVER": "localhost", # example, change or override this in mw2-client.conf
  "XAUTH_RETRIES": 10,
  "INTERNAL_PATH": '/usr/bin/', # path to mergeauth and startxvnc inside the container
  # REVISIT: code doesn't work with non zero VZOFFSET.  We should set it to 100 because 0-100 are reserved by OpenVZ.
  "VZOFFSET": 0, # Container ID = VNC display number + VZOFFSET
  "WIN_PORTBASE": 5900, # Windows VNC Server listening port
  "WIN_HOME_DRIVE": "H:", # Mapped drive within containers for a users home directory
  "WIN_HOME_DIR_SERVER": "changeme", # Server where home directories are located
  "WIN_HOME_DRIVE_MAP_PATH_A": "e:\\vz\private\\", # Location for the "net use" command file (first part)
  "WIN_HOME_DRIVE_MAP_PATH_B": "\\root\\CTID_command\\map_home_dir.cmd", # Location for the "net use" command file (second part)
  "WIN_SMB_SECRET": "--------------", # override in /etc/mw-service/mw-file-service.conf
  "STUNNEL_PORTS": 4000, # stunnel ports = VNC display number + STUNNEL_PORTS
  "FILEXFER_PORTS": 9000, # file transfer ports = VNC display number + FILEXFER_PORTS
  "VZ_CONF_PATH": '/etc/vz/conf',
  "VZ_PATH": '/var/lib/vz', # '/vz/' on nanohub
  "PEM_PATH": '/etc/mw-service/xvnc.pem', # x509 certificate. '/root/combined_cert.pem' on nanohub
  "TUNNEL_MODE": 'stunnel', # use socat or stunnel.  Use 'socatx' to get -d -d -d debug information options.
  "WIN_SMBPASSWD_PATH": "/var/samba/private/smbpasswd", # Location for the samba server's list of users
  "MW_OPEN_FW":False,
  "ANONYMOUS": False,
  "OPEN_FW": False,
  "PRIVATE_NET": "192.168.%d.%d",  # for the IP addresses of containers.
  "DEFAULT_GROUPS": (), # group memberships that apply only in containers, such as fuse
  # array of ["group_name", net_cidr, portmin, portmax] where net_cidr is something like 128.46.19.160/32
  # 0 or empty string means any;  portmin-portmax defines a range of ports
  "MW_PROTECTED_NETWORK": "128.46.16.0/20",
  "FW_GROUP_MAP": [
    ["apps", "", 0, 0],
    ["network", "", 0, 0],
    ["remote_mysql", "", 3306, 0],
  ],
  "EXTRA_ENV_CMD": ""
}

VIRTUALSSH_K = {
  "SCP_PATH": "/usr/bin/scp",
  # where to store ssh keys and the template for /ssh to copy inside tool containers
  # this used to be in /var/lib/mw, hence the name
  "VAR_PATH": "/etc/mw-virtualssh/"
}

MW_USER = "www-data"
WEB_HOMEDIR = "/var/www"
CONFIG_FILE = '/etc/mw-client/mw2-client.conf'
EXEC_CONFIG_FILE = '/etc/mw-service/mw-exec-service.conf'
FILE_CONFIG_FILE = '/etc/mw-service/mw-file-service.conf'
RUN_DIR = '/var/lib'

BANKS = False
LIB_PATH = '/usr/bin'  # '/apps/xvnc'
BASE_LOG_PATH = '/var/log/mw-client/'
MASTER_LOG_FILENAME = '/var/log/mw-client/' + 'client.log'
SERVICE_LOG = '/var/log/mw-service/' + "service.log"
QUOTA_PATH = '/etc/mw-service/quota.conf'

BKGND_RETRY_SLEEP = 5  # time to sleep before attempting background tasks
MYSQL_CONN_ATTEMPTS = 120

# regular expressions for input validation
# these should not need to be overridden even for testing so they are not provided in a dictionary.
# CMD_REGEXP is the command stored in the database, to start a tool/app.
CMD_REGEXP = r'\A[a-zA-Z0-9_\/\.\-\\ \:\(\)\~\"]+\Z'
PATH_REGEXP = r'\A[a-zA-Z0-9_\/\.\-\\]+\Z'
GEOM_REGEXP = r'\A\d+x\d+\Z'
USER_REGEXP = r'\A[0-9a-zA-Z]+[\@_0-9a-zA-Z\.\-]*\Z'
IP_REGEXP = r'\A[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\Z'
INT_REGEXP = r'\A[+-]?\d+\Z'
ALPHANUM_REGEXP = r'\A[a-zA-Z0-9]+\Z'
QUOTED_REGEXP = r'\A\'[^\'\"]*\'\Z'
NAME_REGEXP = r'\A[a-zA-Z0-9._\-]+\Z'
LOGSAFE_REGEXP = r'\A[a-zA-Z~!@#$%^&*()_+=\-0-9\[\]{}\/\.\\\' ]+\Z'
# command input validation
# each arg should be a single word containing only
# alphanumerics, dashes, underscores, dots and slashes, with redirections > <
# see maxwell/client in function "invoke_command"
# has "<>" which PATH_REGEXP doesn't
# allow quoted strings with spaces in them for application extra arguments
SHELLARG_REGEXP = r'\A[a-zA-Z0-9_\/.\-\\\>\<\'\ \:\(\)\~\"]+\Z' 
SESSNAME_REGEXP = r'\A[0-9]+[a-zA-Z]?\Z'
URL_REGEXP=r'\A[a-zA-Z0-9\%\.\-\_\~]+\Z'

# for random password generation -- some used on the command line, so special characters
# such as ';' are problematic
ALPHANUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

