#!/bin/sh

PEMFILE="/etc/mw/xvnc.pem"

# Generate new certs if needed
if [ -e $PEMFILE ]; then
  echo "You already have an SSL pem file for xvnc; not replacing"
else
  echo "Creating generic self-signed certificate: $PEMFILE"
  echo "(replace with hand-crafted or authorized one if needed)."
  cd /etc/mw
  PATH=$PATH:/usr/bin/ssl
  FQDN=`hostname -f`
  MAILNAME=`cat /etc/mailname 2> /dev/null || hostname -f`
  (openssl req -new -x509 -days 365 -nodes -out $PEMFILE.cert -keyout $PEMFILE.key  > /dev/null 2>&1 <<+
.
.
.
HUBzero Middleware
$FQDN
$FQDN
root@$MAILNAME
+
  ) || echo "Warning : Bad SSL config, can't generate certificate."
  cat $PEMFILE.cert $PEMFILE.key > $PEMFILE
  rm $PEMFILE.cert $PEMFILE.key

  if [ -e $PEMFILE ]; then
    chown root $PEMFILE || true
    chgrp root $PEMFILE || true
    chmod 0600 $PEMFILE || true
  fi
fi
