%define name hubzero-mw-client
%define version 1.1.15
%define release 6

Summary:       HUBzero middleware client
Name:          %{name}
Version:       %{version}
Release:       %{release}
Source0:       %{name}-%{version}.tar.gz
License:       GNU LGPL 3+
Packager:      David Benham <dbenham@purdue.edu>
Vendor:        Hubzero, http://hubzero.org
Url:           http://hubzero.org
BuildArch:     noarch
Requires:      openssh, openssh-server, python, python-dns, mysql-connector-python, python-ldap

%description
HUBzero middleware client called by the CMS to control the 
execution of apps and other system functions.

%prep
%setup -q

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
/usr/share
/usr/bin
/etc
/var/log

%doc copyright

%post
if [ ! -f /etc/mw-client/maxwell.key.pub ]
then
	printf "y\n" | ssh-keygen -q -t rsa -f /etc/mw-client/maxwell.key -N '' -C apache@`hostname`
fi

if [ ! -f /etc/mw-client/notify.key.pub ]
then
	printf "y\n" | ssh-keygen -q -t rsa -f /etc/mw-client/notify.key -N '' -C root@`hostname`
fi 

if [ ! -e /var/log/mw-client ]
then
	mkdir /var/log/mw-client
	chown apache:apache /var/log/mw-client
	chmod 0750 /var/log/mw-client
fi

if [ ! -e /var/log/mw-client/sessions ]
then
	mkdir /var/log/mw-client/sessions
	chown apache:apache /var/log/mw-client/sessions
	chmod 0750 /var/log/mw-client/sessions
fi


if [ -d /var/log/hubzero/sessions ]
then
	find /var/log/hubzero/sessions -maxdepth 1 -name "*.out" -type f -exec mv --backup=t {} /var/log/mw-client/sessions \;
	find /var/log/hubzero/sessions -maxdepth 1 -name "*.err" -type f -exec mv --backup=t {} /var/log/mw-client/sessions \;
	rmdir --ignore-fail-on-non-empty /var/log/hubzero/sessions
fi

if [ -d /var/log/hubzero ]
then
	find /var/log/hubzero -maxdepth 1 -name "vnc-*" -type f -exec mv --backup=t {} /var/log/mw-client \;
	find /var/log/hubzero -maxdepth 1 -name "master*" -type f -exec mv --backup=t {} /var/log/mw-client \;
	rmdir --ignore-fail-on-non-empty /var/log/hubzero
fi

if [ -d /var/log/mw/sessions ]
then
	find /var/log/mw/sessions -maxdepth 1 -name "*.out" -type f -exec mv --backup=t {} /var/log/mw-client/sessions \;
	find /var/log/mw/sessions -maxdepth 1 -name "*.err" -type f -exec mv --backup=t {} /var/log/mw-client/sessions \;
	rmdir --ignore-fail-on-non-empty /var/log/mw/sessions
fi

if [ -d /var/log/mw ]
then
	find /var/log/mw -maxdepth 1 -name "vnc-*" -type f -exec mv --backup=t {} /var/log/mw-client \;
	find /var/log/mw -maxdepth 1 -name "master*" -type f -exec mv --backup=t {} /var/log/mw-client \;
	rmdir --ignore-fail-on-non-empty /var/log/mw
fi

chmod -R 770 /etc/mw-client

chown apache:apache /etc/mw-client/maxwell.key
chmod 0400 /etc/mw-client/maxwell.key
#ucfr hubzero-mw-client /etc/mw-client/maxwell.key

chown apache:apache /etc/mw-client/maxwell.key.pub
chmod 0400 /etc/mw-client/maxwell.key.pub
#ucfr hubzero-mw-client /etc/mw-client/maxwell.key.pub

chown apache:apache /etc/mw-client/notify.key.pub
chmod 0400 /etc/mw-client/notify.key.pub
#ucfr hubzero-mw-client /etc/mw-client/notify.key.pub

chown apache:apache /etc/mw-client/notify.key
chmod 0400 /etc/mw-client/notify.key
#ucfr hubzero-mw-client /etc/mw-client/notify.key

mkdir -p ~apache/.ssh
if [ ! -f ~apache/.ssh/authorized_keys ]
then
	touch  ~apache/.ssh/authorized_keys
fi


if [ -f /etc/mw-client/notify.key -a -d /etc/mw-service ]
then
	cp /etc/mw-client/notify.key /etc/mw-service/notify.key
fi

if [ -f /etc/mw-service/notify.key ]
then
	chown root:root /etc/mw-service/notify.key
	chmod 0400 /etc/mw-service/notify.key
fi
grep -q -f /etc/mw-client/notify.key.pub ~apache/.ssh/authorized_keys || (echo -n "COMMAND=\"/usr/bin/maxwell notify\" " >> ~apache/.ssh/authorized_keys; cat /etc/mw-client/notify.key.pub >> ~apache/.ssh/authorized_keys)
chown apache:apache ~apache/.ssh
chmod 0700 ~apache/.ssh
chown apache:apache ~apache/.ssh/authorized_keys
chmod 0400 ~apache/.ssh/authorized_keys
chown -R apache.apache /etc/mw-client
chown -R apache.apache /var/log/mw-client


%changelog
* Thu Sep 15 2013 David Benham <dbenham@purdue.edu>
- created rpm package


