# @package      hubzero-mailgateway
# @file         rpm.mk
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2010-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2010-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

USRLIB=$(DESTDIR)/usr/lib
ETC=$(DESTDIR)/etc

all:
	@true

install:
	install --mode 0755 -D python/mailproc.py $(USRLIB)/hubzero/bin/mailproc/mailproc.py
	install --mode 0755 -D python/processgroupforumpost.py $(USRLIB)/hubzero/bin/mailproc/processgroupforumpost.py
	install --mode 0755 -D python/processsupportemail.py $(USRLIB)/hubzero/bin/mailproc/processsupportemail.py
	install --mode 0755 -D python/processticketcomment.py $(USRLIB)/hubzero/bin/mailproc/processticketcomment.py
	install --mode 0755 -D python/filecopy.py $(USRLIB)/hubzero/bin/mailproc/filecopy.py
	install --mode 0755 -D python/process_emailbounces.py $(USRLIB)/hubzero/bin/mailproc/process_emailbounces.py
	install --mode 0755 -D hubzero-mailgateway.logrotate.rpm $(ETC)/logrotate.d/hubmailgateway

collectfiles:
	cp /usr/lib/hubzero/bin/mailproc/mailproc.py python/mailproc.py
	cp /usr/lib/hubzero/bin/mailproc/processgroupforumpost.py python/processgroupforumpost.py
	cp /usr/lib/hubzero/bin/mailproc/processsupportemail.py python/processsupportemail.py
	cp /usr/lib/hubzero/bin/mailproc/processticketcomment.py python/processticketcomment.py
	cp /usr/lib/hubzero/bin/mailproc/filecopy.py python/filecopy.py
	cp /etc/logrotate.d/hubmailgateway ./hubzero-mailgateway.logrotate.rpm

uninstall:
	@true

postinst:
	install --mode 0744 --owner root --group root -D hubmailgateway /etc/logrotate.d/hubmailgateway

clean:
	@true

.PHONY: all install uninstall postinst clean
