/**
 * @package     hubzero-cms
 * @file        modules/mod_youtube/mod_youtube.js
 * @copyright   Copyright 2005-2011 Purdue University. All rights reserved.
 * @license     http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

//-----------------------------------------------------------
//  Ensure we have our namespace
//-----------------------------------------------------------
if (!HUB) {
	var HUB = {};
}

//-----

if(!HUB.Modules) {
	HUB.Modules = {};
}

//-----------------------------------------------------------
//  Youtube feed js
//-----------------------------------------------------------

HUB.Modules.Youtube = { 
	buildFeed: function(options) {
		var html = "";
		var entries = options.feed.entry;
		var title = options.feed.title.$t;
		if(options.type == 'playlists') {
			var desc = options.feed.subtitle.$t;
		}
		var logo = new String(options.feed.logo.$t);
		var logo = logo.replace("http://","https://");
		
		//check to see if we are to display a title and which title to display
		if(options.showTitle) {
			if(options.altTitle != '') {
				html += '<h3>' + options.altTitle + '</h3>';
			} else {
				html += '<h3>' + title + '</h3>';
			}
		}
		
		//check to see if we are to display a title and which title to display
		if(options.showDesc) {
			if(options.altDesc != '') {
				html += '<p class="description">' + options.altDesc + '</p>';
			} else if(options.type == 'playlists') {
				html += '<p class="description">' + desc + '</p>';
			}
		}
		
		//check to see if we are to display a title and which title to display
		if(options.showImage) {
			if(options.altImage != '') {
				html += '<img class="logo" src="' + options.altImage + '" alt="Youtube" />';
			} else {
				html += '<img class="logo" src="' + logo + '" alt="Youtube" />';
			}
		}
		
		//check to see if we should randomize entries
		if(options.random) {
			entries.sort(function() {return 0.5 - Math.random()});
		}
		
		//console.log(entries);
		
		//create the list of videos
		html += '<ul>';
		for(var i = 0; i < options.number; i++) {
			var entry = entries[i];
			if(entry) {
				var media = entry.media$group;
				html += "<li>";
				var thumb = media.media$thumbnail[3].url;
				var thumb = thumb.replace("http://","https://");
				html += "<a class=\"entry-thumb\" rel=\"external\" href=\"" + entry.link[0].href + "\"><img src=\"" + thumb + "\" alt=\"\" /></a>";
				html += "<a class=\"entry-title\" rel=\"external\" href=\"" + entry.link[0].href + "\">" + entry.title.$t + "</a>";
				html += "<br /><span class=\"entry-duration\">" + HUB.Modules.Youtube.formatDuration(media.yt$duration.seconds) + "</span>";
				html+="</li>";
			}
		}
		html += '</ul>';
		
		//check to see if we are to display a title and which title to display
		if(options.showLink) {
			if(options.altLink != '') {
				html += '<p class="more"><a rel="external" href="' + options.altLink + '" title="Youtube">More Videos</a></p><br class="clear" />';
			} else {
				switch(options.type)
				{
					case 'playlists':
						link = "http://www.youtube.com/view_play_list?p=" + options.content;
						break;
					case 'users':
						link = "http://www.youtube.com/user/" + options.content;
						break;
					case 'videos':
						link = "http://www.youtube.com/results?search_query=" + options.content;
						break;
				}
				
				html += '<p class="more"><a rel="external" href="' + link + '" title="Youtube">More Videos</a></p><br class="clear" />';
			}
		}
		
		//set the content of the container
		$('youtube_feed_' + options.id).innerHTML = html;
	},
	
	formatDuration: function( seconds ) {
		minutes = Math.floor(seconds/60); 	
		seconds = seconds % 60;
		if(seconds < 10) {
			seconds = "0" + seconds;
		}
		return "<span>" + minutes + ":" + seconds + "</span>";
	}
	
}

