/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.browser.net.ProxyInfo;
import com.sun.java.browser.net.ProxyService;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketToMe {
    String host;
    int port;
    VncViewer viewer;
    boolean debug = true;
    SSLSocket socket = null;
    SSLSocketFactory factory;
    boolean proxy_in_use = false;
    boolean proxy_is_https = false;
    boolean proxy_failure = false;
    public DataInputStream is = null;
    public OutputStream os = null;
    String proxy_dialog_host = null;
    int proxy_dialog_port = 0;
    Socket proxySock;
    DataInputStream proxy_is;
    OutputStream proxy_os;
    SSLContext trustloc_ctx;
    SSLContext trustall_ctx;
    SSLContext trusturl_ctx;
    SSLContext trustone_ctx;
    TrustManager[] trustAllCerts;
    TrustManager[] trustUrlCert;
    TrustManager[] trustOneCert;
    boolean use_url_cert_for_auth = true;
    boolean user_wants_to_see_cert = true;
    Certificate[] trustallCerts = null;
    Certificate[] trusturlCerts = null;

    SSLSocketToMe(String string, int n, VncViewer vncViewer) throws Exception {
        this.host = string;
        this.port = n;
        this.viewer = vncViewer;
        this.factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.dbg("SSL startup: " + this.host + " " + this.port);
        this.trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                SSLSocketToMe.this.dbg("ALL: an untrusted connect to grab cert.");
            }
        }};
        this.trustUrlCert = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                throw new CertificateException("No Clients");
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                int n;
                boolean bl;
                if (SSLSocketToMe.this.trusturlCerts == null) {
                    throw new CertificateException("No Trust url Certs array.");
                }
                if (SSLSocketToMe.this.trusturlCerts.length < 1) {
                    throw new CertificateException("No Trust url Certs.");
                }
                if (SSLSocketToMe.this.trusturlCerts.length > 1) {
                    bl = true;
                    for (n = 0; n < SSLSocketToMe.this.trusturlCerts.length - 1; ++n) {
                        if (SSLSocketToMe.this.trusturlCerts[n].equals(SSLSocketToMe.this.trusturlCerts[n + 1])) continue;
                        bl = false;
                    }
                    if (!bl) {
                        throw new CertificateException("Too many Trust url Certs: " + SSLSocketToMe.this.trusturlCerts.length);
                    }
                }
                if (x509CertificateArray == null) {
                    throw new CertificateException("No this-certs array.");
                }
                if (x509CertificateArray.length < 1) {
                    throw new CertificateException("No this-certs Certs.");
                }
                if (x509CertificateArray.length > 1) {
                    bl = true;
                    for (n = 0; n < x509CertificateArray.length - 1; ++n) {
                        if (x509CertificateArray[n].equals(x509CertificateArray[n + 1])) continue;
                        bl = false;
                    }
                    if (!bl) {
                        throw new CertificateException("Too many this-certs: " + x509CertificateArray.length);
                    }
                }
                if (!SSLSocketToMe.this.trusturlCerts[0].equals(x509CertificateArray[0])) {
                    throw new CertificateException("Server Cert Changed != URL.");
                }
                SSLSocketToMe.this.dbg("URL: trusturlCerts[0] matches certs[0]");
            }
        }};
        this.trustOneCert = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                throw new CertificateException("No Clients");
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                int n;
                boolean bl;
                if (SSLSocketToMe.this.trustallCerts == null) {
                    throw new CertificateException("No Trust All Server Certs array.");
                }
                if (SSLSocketToMe.this.trustallCerts.length < 1) {
                    throw new CertificateException("No Trust All Server Certs.");
                }
                if (SSLSocketToMe.this.trustallCerts.length > 1) {
                    bl = true;
                    for (n = 0; n < SSLSocketToMe.this.trustallCerts.length - 1; ++n) {
                        if (SSLSocketToMe.this.trustallCerts[n].equals(SSLSocketToMe.this.trustallCerts[n + 1])) continue;
                        bl = false;
                    }
                    if (!bl) {
                        throw new CertificateException("Too many Trust All Server Certs: " + SSLSocketToMe.this.trustallCerts.length);
                    }
                }
                if (x509CertificateArray == null) {
                    throw new CertificateException("No this-certs array.");
                }
                if (x509CertificateArray.length < 1) {
                    throw new CertificateException("No this-certs Certs.");
                }
                if (x509CertificateArray.length > 1) {
                    bl = true;
                    for (n = 0; n < x509CertificateArray.length - 1; ++n) {
                        if (x509CertificateArray[n].equals(x509CertificateArray[n + 1])) continue;
                        bl = false;
                    }
                    if (!bl) {
                        throw new CertificateException("Too many this-certs: " + x509CertificateArray.length);
                    }
                }
                if (!SSLSocketToMe.this.trustallCerts[0].equals(x509CertificateArray[0])) {
                    throw new CertificateException("Server Cert Changed != TRUSTALL.");
                }
                SSLSocketToMe.this.dbg("ONE: trustallCerts[0] matches certs[0]");
            }
        }};
        try {
            this.trustloc_ctx = SSLContext.getInstance("SSL");
            this.trustloc_ctx.init(null, null, new SecureRandom());
        }
        catch (Exception exception) {
            String string2 = "SSL trustloc_ctx FAILED.";
            this.dbg(string2);
            throw new Exception(string2);
        }
        try {
            this.trustall_ctx = SSLContext.getInstance("SSL");
            this.trustall_ctx.init(null, this.trustAllCerts, new SecureRandom());
        }
        catch (Exception exception) {
            String string3 = "SSL trustall_ctx FAILED.";
            this.dbg(string3);
            throw new Exception(string3);
        }
        try {
            this.trusturl_ctx = SSLContext.getInstance("SSL");
            this.trusturl_ctx.init(null, this.trustUrlCert, new SecureRandom());
        }
        catch (Exception exception) {
            String string4 = "SSL trusturl_ctx FAILED.";
            this.dbg(string4);
            throw new Exception(string4);
        }
        try {
            this.trustone_ctx = SSLContext.getInstance("SSL");
            this.trustone_ctx.init(null, this.trustOneCert, new SecureRandom());
        }
        catch (Exception exception) {
            String string5 = "SSL trustone_ctx FAILED.";
            this.dbg(string5);
            throw new Exception(string5);
        }
    }

    boolean browser_cert_match() {
        String string = "Browser URL accept previously accepted cert";
        if (this.user_wants_to_see_cert) {
            return false;
        }
        if (this.trustallCerts != null && this.trusturlCerts != null && this.trustallCerts.length == 1 && this.trusturlCerts.length == 1 && this.trustallCerts[0].equals(this.trusturlCerts[0])) {
            System.out.println(string);
            return true;
        }
        return false;
    }

    public void check_for_proxy() {
        boolean bl = false;
        String string = "https://" + this.host + ":";
        string = this.viewer.httpsPort != null ? string + this.viewer.httpsPort : string + this.port;
        string = string + this.viewer.urlPrefix + "/check.https.proxy.connection";
        this.dbg("ustr is: " + string);
        this.trusturlCerts = null;
        this.proxy_in_use = this.viewer.forceProxy;
        if (this.proxy_in_use) {
            return;
        }
        string = "http://" + this.host + ":" + this.port;
        string = string + this.viewer.urlPrefix + "/index.vnc";
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Pragma", "No-Cache");
            httpURLConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            if (httpURLConnection.usingProxy()) {
                this.proxy_in_use = true;
                this.proxy_is_https = false;
                this.dbg("HTTP proxy in use. There may be connection problems.");
            }
            Object object = httpURLConnection.getContent();
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            this.dbg("HttpURLConnection: " + exception.getMessage());
        }
    }

    public Socket connectSock() throws IOException {
        Object object;
        Object object2;
        block35: {
            this.check_for_proxy();
            if (this.viewer.trustAllVncCerts) {
                this.dbg("viewer.trustAllVncCerts-0 using trustall_ctx");
                this.factory = this.trustall_ctx.getSocketFactory();
            } else if (this.use_url_cert_for_auth && this.trusturlCerts != null) {
                this.dbg("using trusturl_ctx");
                this.factory = this.trusturl_ctx.getSocketFactory();
            } else {
                this.dbg("using trustloc_ctx");
                this.factory = this.trustloc_ctx.getSocketFactory();
            }
            this.socket = null;
            try {
                if (this.proxy_in_use && this.viewer.forceProxy) {
                    throw new Exception("forcing proxy (forceProxy)");
                }
                if (this.viewer.CONNECT != null) {
                    throw new Exception("forcing CONNECT");
                }
                this.socket = (SSLSocket)this.factory.createSocket(this.host, this.port);
            }
            catch (Exception exception) {
                this.dbg("esock: " + exception.getMessage());
                if (!this.proxy_in_use && this.viewer.CONNECT == null) break block35;
                this.proxy_failure = true;
                if (this.proxy_in_use) {
                    this.dbg("HTTPS proxy in use. Trying to go with it.");
                } else {
                    this.dbg("viewer.CONNECT reverse proxy in use. Trying to go with it.");
                }
                try {
                    this.socket = this.proxy_socket(this.factory);
                }
                catch (Exception exception2) {
                    this.dbg("err proxy_socket: " + exception2.getMessage());
                }
            }
        }
        if (this.socket == null) {
            if (this.proxy_in_use) {
                throw new IOException("Unable to make either a direct or proxied connection to " + this.host);
            }
            throw new IOException("Unable to make a direct connection to " + this.host + ".  Try again.");
        }
        try {
            Object object3;
            this.socket.startHandshake();
            this.dbg("Server Connection Verified on 1st try.");
            SSLSession sSLSession = this.socket.getSession();
            object2 = sSLSession.getPeerCertificates();
            if (this.viewer.trustAllVncCerts) {
                this.dbg("viewer.trustAllVncCerts-1");
            } else if (object2 == null || ((Certificate[])object2).length < 1) {
                this.socket.close();
                this.socket = null;
                throw new SSLHandshakeException("no current certs");
            }
            String string = "";
            try {
                object3 = new CertInfo(object2[0]);
                string = ((CertInfo)object3).get_certinfo("CN");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.viewer.trustAllVncCerts) {
                this.dbg("viewer.trustAllVncCerts-2");
                this.user_wants_to_see_cert = false;
            } else {
                object = new BrowserCertsDialog(string, this.host + ":" + this.port);
                ((BrowserCertsDialog)object).queryUser();
                if (((BrowserCertsDialog)object).showCertDialog) {
                    object3 = "user wants to see cert";
                    this.dbg((String)object3);
                    this.user_wants_to_see_cert = true;
                    throw new SSLHandshakeException((String)object3);
                }
                this.user_wants_to_see_cert = false;
                this.dbg("bcd: user said yes, accept it");
            }
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.dbg("Could not automatically verify Server.");
            this.dbg("msg: " + sSLHandshakeException.getMessage());
            this.socket.close();
            this.socket = null;
            this.factory = this.trustall_ctx.getSocketFactory();
            this.socket = this.proxy_failure ? this.proxy_socket(this.factory) : (SSLSocket)this.factory.createSocket(this.host, this.port);
            try {
                this.socket.startHandshake();
                this.dbg("TrustAll Server Connection Verified.");
                try {
                    object = this.socket.getSession();
                    this.trustallCerts = object.getPeerCertificates();
                }
                catch (Exception exception) {
                    throw new Exception("Could not get Peer Certificate");
                }
                if (this.viewer.trustAllVncCerts) {
                    this.dbg("viewer.trustAllVncCerts-3");
                } else if (!this.browser_cert_match()) {
                    this.socket.close();
                    this.socket = null;
                    object = new TrustDialog(this.host, this.port, this.trustallCerts);
                    if (!((TrustDialog)object).queryUser()) {
                        String string = "User decided against it.";
                        this.dbg(string);
                        throw new IOException(string);
                    }
                }
            }
            catch (Exception exception) {
                this.dbg("** Could not TrustAll Verify Server.");
                throw new IOException(exception.getMessage());
            }
            this.factory = this.trustone_ctx.getSocketFactory();
            this.socket = this.proxy_failure ? this.proxy_socket(this.factory) : (SSLSocket)this.factory.createSocket(this.host, this.port);
            try {
                this.socket.startHandshake();
                this.dbg("TrustAll Server Connection Verified #3.");
            }
            catch (Exception exception) {
                this.dbg("** Could not TrustAll Verify Server #3.");
                throw new IOException(exception.getMessage());
            }
        }
        if (this.socket != null && this.viewer.GET) {
            object2 = "GET ";
            object2 = (String)object2 + this.viewer.urlPrefix;
            object2 = (String)object2 + "/request.https.vnc.connection";
            object2 = (String)object2 + " HTTP/1.0\r\n";
            object2 = (String)object2 + "Pragma: No-Cache\r\n";
            object2 = (String)object2 + "\r\n";
            System.out.println("sending GET: " + (String)object2);
            object = this.socket.getOutputStream();
            ((OutputStream)object).write(((String)object2).getBytes());
            ((OutputStream)object).flush();
        }
        this.dbg("SSL returning socket to caller.");
        return this.socket;
    }

    private void dbg(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private int gint(String string) {
        int n = -1;
        try {
            Integer n2 = new Integer(string);
            n = n2;
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    public SSLSocket proxy_socket(SSLSocketFactory sSLSocketFactory) throws IOException {
        ProxyInfo[] proxyInfoArray;
        Object object;
        Object object2;
        Object object3;
        Properties properties = null;
        String string = null;
        int n = 0;
        String string2 = null;
        int n2 = 0;
        try {
            properties = System.getProperties();
        }
        catch (Exception exception) {
            this.dbg("props failed: " + exception.getMessage());
        }
        if (properties != null) {
            this.dbg("\n---------------\nAll props:");
            properties.list(System.out);
            this.dbg("\n---------------\n\n");
            object3 = properties.propertyNames();
            block15: while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = System.getProperty((String)object2);
                proxyInfoArray = ((String)object2).toLowerCase();
                String string3 = ((String)object).toLowerCase();
                if (proxyInfoArray.indexOf("proxy") < 0 && string3.indexOf("proxy") < 0 || string3.indexOf("https") < 0) continue;
                if (proxyInfoArray.indexOf("proxy.https.host") >= 0) {
                    string = string3;
                    continue;
                }
                if (proxyInfoArray.indexOf("proxy.https.port") >= 0) {
                    n = this.gint(string3);
                    continue;
                }
                if (proxyInfoArray.indexOf("proxy.http.host") >= 0) {
                    string2 = string3;
                    continue;
                }
                if (proxyInfoArray.indexOf("proxy.http.port") >= 0) {
                    n2 = this.gint(string3);
                    continue;
                }
                String[] stringArray = ((String)object).split("[,;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2;
                    String string4 = stringArray[i];
                    int n3 = string4.indexOf("https");
                    if (n3 < 0 || (n3 = string4.indexOf("=", n3)) < 0 || (stringArray2 = (string4 = string4.substring(n3 + 1)).split(":")).length != 2 || stringArray2[0].length() <= 1 || stringArray2[1].length() <= 1 || (n = this.gint(stringArray2[1])) < 0) continue;
                    string = new String(stringArray2[0]);
                    continue block15;
                }
            }
        }
        if (string == null) {
            object3 = "https://" + this.host + ":";
            object3 = this.viewer.httpsPort != null ? (String)object3 + this.viewer.httpsPort : (String)object3 + this.port;
            object2 = new URL((String)object3);
            try {
                object = Class.forName("com.sun.java.browser.net.ProxyService");
                proxyInfoArray = ProxyService.getProxyInfo((URL)object2);
                if (proxyInfoArray == null || proxyInfoArray.length == 0) {
                    this.dbg("1.4.X reported NULL proxy (no proxy assumed)");
                } else {
                    this.dbg("1.4.X Proxy info geProxy:" + proxyInfoArray[0].getHost() + " get Port:" + proxyInfoArray[0].getPort() + " isSocks:" + proxyInfoArray[0].isSocks());
                    string = proxyInfoArray[0].getHost();
                    n = proxyInfoArray[0].getPort();
                }
            }
            catch (Exception exception) {
                this.dbg("Sun Plugin 1.4.X proxy detection class not found, will try failover detection, e:" + exception);
            }
            if (string == null) {
                try {
                    object = System.getProperties().getProperty("javaplugin.proxy.config.list").toUpperCase();
                    this.dbg("Plugin Proxy Config List Property:" + (String)object);
                    if (object != null) {
                        string = ((String)object).indexOf("HTTP=") > -1 ? ((String)object).substring(((String)object).indexOf("HTTP=") + 5, ((String)object).indexOf(":")) : ((String)object).substring(0, ((String)object).indexOf(":"));
                        int n4 = ((String)object).indexOf(",");
                        if (n4 < 1) {
                            n4 = ((String)object).length();
                        }
                        n = Integer.parseInt(((String)object).substring(((String)object).indexOf(":") + 1, n4));
                    }
                }
                catch (SecurityException securityException) {
                    this.dbg("Security Exception arose while trying to access system properties to detect proxy parameters " + securityException.getMessage());
                }
                catch (Exception exception) {
                    this.dbg("Exception during failover auto proxy detection, autoDetect disabled, e:" + exception);
                }
            }
        }
        if (string != null && string2 != null && n2 > 0) {
            this.dbg("Using http proxy info instead of https.");
            string = string2;
            n = n2;
        }
        if (!this.viewer.forceProxy) {
            this.dbg("trying a direct connection...");
            try {
                this.proxySock = this.directSocket(this.host, this.port, 5000);
                if (this.proxySock != null) {
                    this.proxy_in_use = false;
                }
            }
            catch (Exception exception) {
                System.out.println("Direct socket failed: " + exception.getMessage());
            }
        }
        if (this.proxy_in_use) {
            if (this.proxy_dialog_host != null && this.proxy_dialog_port > 0) {
                string = this.proxy_dialog_host;
                n = this.proxy_dialog_port;
            }
            if (string != null) {
                this.dbg("Lucky us! we figured out the Proxy parameters: " + string + " " + n);
            } else {
                object3 = new ProxyDialog(string, n);
                ((ProxyDialog)object3).queryUser();
                string = ((ProxyDialog)object3).getHost();
                n = ((ProxyDialog)object3).getPort();
                this.proxy_dialog_host = new String(string);
                this.proxy_dialog_port = n;
                this.dbg("User said host: " + ((ProxyDialog)object3).getHost() + " port: " + ((ProxyDialog)object3).getPort());
            }
            this.dbg("proxy_in_use psocket:");
            this.proxySock = this.psocket(string, n);
            if (this.proxySock == null) {
                this.dbg("1-a sadly, returning a null socket");
                return null;
            }
            object3 = this.host + ":" + this.port;
            object2 = "CONNECT " + (String)object3 + " HTTP/1.1\r\n" + "Host: " + (String)object3 + "\r\n\r\n";
            this.dbg("requesting1: " + (String)object2);
            try {
                this.proxy_os.write(((String)object2).getBytes());
                object = this.readline(this.proxy_is);
                this.dbg("proxy replied1: " + ((String)object).trim());
                if (((String)object).indexOf("HTTP/1.") < 0 && ((String)object).indexOf(" 200") < 0) {
                    this.proxySock.close();
                    this.proxySock = this.psocket(string, n);
                    if (this.proxySock == null) {
                        this.dbg("2-a sadly, returning a null socket");
                        return null;
                    }
                }
            }
            catch (Exception exception) {
                this.dbg("sock prob1: " + exception.getMessage());
                throw new IOException("sock prob1: " + exception.getMessage());
            }
            do {
                object = this.readline(this.proxy_is);
                this.dbg("proxy line1: " + ((String)object).trim());
            } while (!((String)object).equals("\r\n") && !((String)object).equals("\n"));
        }
        if (this.viewer.CONNECT != null) {
            object3 = this.viewer.CONNECT;
            object2 = "CONNECT " + (String)object3 + " HTTP/1.1\r\n" + "Host: " + (String)object3 + "\r\n\r\n";
            this.dbg("requesting2: " + (String)object2);
            try {
                this.proxy_os.write(((String)object2).getBytes());
                object = this.readline(this.proxy_is);
                this.dbg("proxy replied2: " + ((String)object).trim());
                if (((String)object).indexOf("HTTP/1.") < 0 && ((String)object).indexOf(" 200") < 0) {
                    this.proxySock.close();
                    this.proxySock = this.psocket(string, n);
                    if (this.proxySock == null) {
                        this.dbg("2-b sadly, returning a null socket");
                        return null;
                    }
                }
            }
            catch (Exception exception) {
                this.dbg("sock prob2: " + exception.getMessage());
                throw new IOException("sock prob2: " + exception.getMessage());
            }
            do {
                object = this.readline(this.proxy_is);
                this.dbg("proxy line2: " + ((String)object).trim());
            } while (!((String)object).equals("\r\n") && !((String)object).equals("\n"));
        }
        object3 = null;
        try {
            object3 = sSLSocketFactory.createSocket(this.proxySock, this.host, this.port, true);
        }
        catch (Exception exception) {
            this.dbg("sslsock prob: " + exception.getMessage());
            this.dbg("3 sadly, returning a null socket");
        }
        return (SSLSocket)object3;
    }

    Socket psocket(String string, int n) {
        Socket socket = null;
        System.out.println("PSOCKET: " + string + ":" + Integer.toString(n));
        try {
            socket = new Socket(string, n);
            this.proxy_is = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 16384));
            this.proxy_os = socket.getOutputStream();
        }
        catch (Exception exception) {
            this.dbg("psocket prob: " + exception.getMessage());
            return null;
        }
        return socket;
    }

    Socket directSocket(String string, int n, int n2) {
        Socket socket = null;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
            socket = new Socket();
            socket.connect(inetSocketAddress, n2);
            this.proxy_is = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 16384));
            this.proxy_os = socket.getOutputStream();
        }
        catch (Exception exception) {
            this.dbg("direct socket problem: " + exception.getMessage());
            return null;
        }
        return socket;
    }

    String readline(DataInputStream dataInputStream) {
        byte[] byArray = new byte[1];
        String string = new String("");
        byArray[0] = 0;
        try {
            while (byArray[0] != 10) {
                byArray[0] = (byte)dataInputStream.readUnsignedByte();
                string = string + new String(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

