ifdef(`HUBNAME',`',`define(`HUBNAME',example)')dnl
ifdef(`FQDN',`',`undefine(`USE_CANONICAL_HOSTNAME')')dnl
ifdef(`DOCUMENT_ROOT',`',`define(`DOCUMENT_ROOT',`/var/www/HUBNAME')')dnl
ifdef(`FQDN',`',`define(`FQDN',example.com)')dnl
ifdef(`BASEDN',`',`define(`BASEDN',`dc=HUBNAME')')dnl
ifdef(`SSLCERTFILE',`',`define(`SSLCERTFILE',/etc/ssl/certs/ssl-cert-snakeoil.pem)')dnl
ifdef(`SSLCERTKEYFILE',`',`define(`SSLCERTKEYFILE',/etc/ssl/private/ssl-cert-snakeoil.key)')dnl
ifdef(`SEARCHDN',`',`define(`SEARCHDN',`cn=search,BASEDN')')dnl
ifdef(`DBHOST',`define(`DBHOST',`localhost')')dnl
ifdef(`DBNAME',`define(`DBNAME',`HUBNAME')')dnl
ifdef(`DBUSER',`define(`DBUSER',`HUBNAME')')dnl
changecom(`//')dnl
# Secure HUBzero Website Definition
#
# DO NOT MODIFY THIS FILE DIRECTLY!!!!
# This file is automatically generated from /etc/APACHE_HOME/sites-m4/HUBNAME
# and can get recreated on demand by `''hzcms' and other tools
changecom(`#')

ifdef(`DISTRH',`
<IfModule !ssl_module>
LoadModule ssl_module modules/mod_ssl.so
</IfModule>

Listen 443

')dnl
dnl

<VirtualHost *:443>
	DocumentRoot DOCUMENT_ROOT
	TraceEnable off
	RewriteEngine on
	ServerSignature off
	ServerName FQDN

ifdef(`USE_CANONICAL_HOSTNAME',`	# Force requests to use canonical hostname
	RewriteCond %{HTTP_HOST} !^FQDN$ [NC]
	RewriteCond %{HTTP_HOST} !^$
	RewriteRule ^/(.*) https://FQDN/$1 [L,R]

')dnl
dnl
ifdef(`USE_FILEXFER',`	# Define filexfer-xlate map
	RewriteMap	filexfer-xlate	prg:/usr/bin/filexfer-xlate

')dnl
dnl
	RewriteRule ^(.*/)?(\.svn|\.git|\.hg)/ - [R=404,L]

	<Directory />
		Order Deny,Allow
		Deny from all
		Options None
		AllowOverride None
	</Directory>

	<Directory DOCUMENT_ROOT/api>
		RewriteEngine On
		Order Allow,Deny
		Allow from all
		Options FollowSymLinks
		AllowOverride None
		DirectoryIndex index.php index.html
		RewriteCond %{REQUEST_FILENAME} !-f
		RewriteCond %{REQUEST_FILENAME} !-d
		RewriteRule (.*) index.php
		Satisfy Any
		php_flag magic_quotes_gpc off
	</Directory>

	<Directory DOCUMENT_ROOT>
		RewriteEngine On
		Order Allow,Deny
		Allow from all
		Options FollowSymLinks
		AllowOverride None
		DirectoryIndex index.php index.html

ifdef(`USE_FILEXFER',`		# Define filexfer rule
		RewriteRule ^filexfer/(.*)	${filexfer-xlate:$1|nothing} [P,QSA,L]

')dnl
dnl
		RewriteCond %{REQUEST_FILENAME} !-f
		RewriteCond %{REQUEST_FILENAME} !-d
ifdef(`USE_SUBVERSION',`		# Don't redirect subversion urls to cms
		RewriteCond %{REQUEST_URI} !^/tools/[^/]+/svn($|/)
)dnl
dnl
ifdef(`USE_TRAC',`		# Don't redirect trac urls to cms
		RewriteCond %{REQUEST_URI} !^/tools/[^/]+/(pygments|admin|prefs|chrome|log|login|wiki|timeline|roadmap|timeline|browser|search|about|diff|changeset|logout|settings|raw-attachment|attachment|export)($|/)
)dnl
dnl
		RewriteRule (.*) index.php
	</Directory>

	<Directory DOCUMENT_ROOT/site/protected>
		Order Deny,Allow
		Deny from All
		Options None
		AllowOverride None
	</Directory>
dnl
ifdef(`USE_TRAC',`
	# Enable trac urls
	<Directory /usr/share/pyshared/trac/htdocs>
		Options FollowSymLinks
		AllowOverride None
		Order allow,deny
		Allow from all
	</Directory>

	Alias /trac/ "TRACROOT/trac/htdocs/"

	<LocationMatch /tools/[^/]+((/($|pygments|admin|prefs|chrome|log|login|wiki|roadmap|timeline|browser|search|about|diff|changeset|logout|settings|raw-attachment|attachment|export)($|/)))>
		SetHandler mod_python
		PythonInterpreter main_interpreter
		PythonHandler trac.web.modpython_frontend
		PythonOption TracUriRoot /tools
		PythonOption TracEnvParentDir "/opt/trac/tools"
	</LocationMatch>

	<LocationMatch /tools/[^/]+/login>
		AuthType Basic
		AuthName "Trac Repository [HUBNAME]"
		AuthBasicProvider ldap
		AuthzLDAPAuthoritative off
		AuthLDAPURL ldap://localhost/ou=users,BASEDN?uid?sub?(cn=*)
		AuthLDAPBindDN "SEARCHDN"
ifdef(`SEARCHPW',`		AuthLDAPBindPassword "SEARCHPW"')
		Require valid-user
	</LocationMatch>
')dnl
dnl
dnl
ifdef(`USE_SUBVERSION',`
	# Enable subversion urls (defined seperately)
	Include HUBNAME.conf.d/svn/svn.con[f]
')dnl
dnl
dnl
ifdef(`USE_WEBDAV',`
	# Enable webdav urls
	DavLockDB /var/lock/apache2/DavLock

	Alias /webdav /webdav
	RewriteMap lc int:tolower
	RewriteRule ^/webdav(/.*) /webdav/home/${lc:%{LA-U:REMOTE_USER}}$1 [L]
	<Directory /webdav>
		DirectoryIndex .None.file.not.exists
		Options Indexes
		IndexOptions FancyIndexing SuppressDescription
		AllowOverride None
		Order Allow,Deny
		Allow from all
		DAV On
		AuthType Basic
		AuthName "WebDAV Server [HUBNAME]"
		AuthBasicProvider ldap
		AuthzLDAPAuthoritative off
		AuthLDAPURL ldap://localhost/ou=users,BASEDN?uid
		AuthLDAPBindDN "SEARCHDN"
ifdef(`SEARCHPW',`		AuthLDAPBindPassword "SEARCHPW"')
		Require valid-user
		AddType text/plain .php .phtml .pht .phps .php3 .php3p .php4 .php5 .php6
		php_admin_value engine Off
		<FilesMatch ".+">
		        SetHandler default-handler
		</FilesMatch>
	</Directory>
')dnl
dnl

	LogLevel warn
	LogFormat "%{%Y-%m-%d %H:%M:%S %Z}t %P %u \"%r\" %>s %B %a \"%{Referer}i\" \"%{User-Agent}i\" %{SSL_PROTOCOL}x %T %D %{userid}n %{jsession}n %{site}C %{auth}n %{component}n %{view}n %{task}n %{action}n %{item}n" hublog
	ErrorLog WEBLOGFILEROOT/HUBNAME-error-ssl.log
	CustomLog WEBLOGFILEROOT/HUBNAME-access.log hublog

	SSLEngine On
	SSLHonorCipherOrder On
	SSLCipherSuite HIGH:!aNULL:!eNULL
	SSLProtocol all -SSLv2 -SSLv3
	SSLCertificateFile SSLCERTFILE
	SSLCertificateKeyFile SSLCERTKEYFILE
ifdef(`SSLCERTCHAINFILE',`
	SSLCertificateChainFile SSLCERTCHAINFILE
')dnl

	<Location /site>
		AddType text/plain .php .phtml .pht .phps .php3 .php3p .php4 .php5 .php6
		php_admin_value engine Off
	</Location>

	AddType application/x-font-ttf .ttf
	AddType application/vnd.ms-fontobject .eot
	AddType application/x-font-opentype .otf
	AddType application/x-font-woff .woff

</VirtualHost>

ifdef(`USE_FILEXFER',`	# Define rewrite lock because of filexfer
	RewriteLock /var/lock/apache2/RewriteLock
')dnl

ifdef(`USE_VNCPROXY',`
# Enable vncproxy
vncProxy On
vncProxyDBDriver mysql
vncProxyDBDParams host=DBHOST,user=DBUSER,pass=DBPASS,dbname=DBNAME
vncProxyHelper "/usr/bin/vncproxy %t"

')dnl
