/**
 * @package     hubzero-vncproxy
 * @file		log.c
 * @author      Nicholas J. Kisseberth <nkissebe@purdue.edu>
 * @copyright   Copyright (c) 2010-2011 Purdue University. All rights reserved.
 * @license     http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2010-2011 Purdue University
 * All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <assert.h>
#include <time.h>
#include <netdb.h>
#include <apr_pools.h>
#include <apr_strings.h>
#include <apu.h>
#include <apr_dbd.h>
#include <getopt.h>
#include <syslog.h>
#include <libgen.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/sysinfo.h>
#define __USE_GNU /* For O_NOFOLLOW */
#include <fcntl.h>
#undef __USE_GNU

#ifndef DEFAULT_LOGLEVEL
#define DEFAULT_LOGLEVEL LOG_INFO
#endif
 
#ifndef DEFAULT_SYSLOGLEVEL
#define DEFAULT_SYSLOGLEVEL LOG_WARNING
#endif

int log_priority = DEFAULT_LOGLEVEL;
int syslog_priority = DEFAULT_SYSLOGLEVEL;

#define MLOG_EMERG   __FILE__,__LINE__,LOG_EMERG
#define MLOG_ALERT   __FILE__,__LINE__,LOG_ALERT
#define MLOG_CRIT    __FILE__,__LINE__,LOG_CRIT
#define MLOG_ERR     __FILE__,__LINE__,LOG_ERR
#define MLOG_WARNING __FILE__,__LINE__,LOG_WARNING
#define MLOG_NOTICE  __FILE__,__LINE__,LOG_NOTICE
#define MLOG_INFO    __FILE__,__LINE__,LOG_INFO
#define MLOG_DEBUG   __FILE__,__LINE__,LOG_DEBUG

void
logmsg(char *file, int line, int priority, char *msg, ...)
{
	static char *priorities[8] = {"[emerg]", "[alert]", "[crit]", "[error]", "[warn]", "[notice]", "[info]", "[debug]" };
	va_list ap;
	char buffer[1500] = {0, 0};
	char pidstr[8];
	time_t t;
	struct tm tm_result;
	int len;

	if ((priority >= 0) && (priority < sizeof (priorities)) && (priority <= log_priority)) {

		if (time(&t) == -1) {
			t = 0;
		}

		buffer[0] = '[';

		if ((localtime_r(&t, &tm_result) == NULL) || (asctime_r(&tm_result, buffer + 1) == NULL)) {
			strcpy(buffer + 1, "Thu Jan 01 00:00:00 1970");
		}

		va_start(ap,msg);
		len = snprintf(buffer + 25, sizeof (buffer) - 25, "] %s %s(%d): [%d] ", priorities[priority], file, line, getpid());
			vsnprintf(buffer + 25 + len, sizeof (buffer) - 25 - len, msg, ap);
		va_end(ap);

		strcat(buffer, "\n");
		fprintf(stderr, buffer);
		fflush(stderr);
	}

	if ((syslog_priority >= 0) && (syslog_priority < sizeof (priorities)) && (priority <= syslog_priority)) {
	
		va_start(ap, msg);
		vsyslog(priority, msg, ap);
		va_end(ap);
	}
}
