# @package      hubzero-use-apps
# @file         apps.csh
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This endifle is part of: The HUBzero(R) Platform for Scientiendifc Collaboration
#
# The HUBzero(R) Platform for Scientiendifc Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

setenv CONFIG_DIRS ""

# determibe Debian OS version, 5 - lenny, 6 - squeeze, 7 - wheezy
setenv dist "debian"
setenv os_version  `grep Linux /etc/issue | sed -e "s/.*Linux //" -e "s/\.[0-9]*//" -e "s/ .*//"`
setenv dist_version "${dist}${os_version}"

# setup the name of the share directory where external software
# should be installed.
# share_base is for bit ambiguous software (probably scripts)
# share_arch is for bit specific software (32-bit vs 64-bit compiled stuff)
setenv share_base "share"
setenv share_arch ""
if ( `uname -m` == x86_64 ) then
    # setup for 64-bit share envionments
    setenv share_arch "share64"
else if ( `uname -m` == x86 ) then
    # setup for 32-bit share envionments
    setenv share_arch "share32"
else
    setenv share_arch "share"
endif


# setup bit specific share environments
if      ( -d /apps/${share_arch}/${dist_version}/environ.d ) then
    setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_arch}/${dist_version}/environ.d"
else if ( -d /apps/${share_arch}/environ.d ) then
    setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_arch}/environ.d"
else if ( -d /apps/${share_arch}/environ ) then
    setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_arch}/environ"
endif

# setup bit agnostic share environments
if ( ${share_arch} != ${share_base} ) then
    if      ( -d /apps/${share_base}/${dist_version}/environ.d ) then
        setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_base}/${dist_version}/environ.d"
    else if ( -d /apps/${share_base}/environ.d ) then
        setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_base}/environ.d"
    else if ( -d /apps/${share_base}/environ ) then
        setenv CONFIG_DIRS "$CONFIG_DIRS /apps/${share_base}/environ"
    endif
endif

# special setup for old production machines
if ( ${dist_version} == debian5 ) then
    # take care of debian 5 (lenny) installs on old production machines
    # during transition, these may exist in cooperation with one of the
    # previous bit specific environments. if we are operating in one
    # of these environments, we ignore previous CONFIG_DIRS settings
    # and hard code to use the old location.
    setenv CONFIG_DIRS ""
    if      ( -d /apps/environ.d ) then
        setenv CONFIG_DIRS "$CONFIG_DIRS /apps/environ.d"
    else if ( -d /apps/environ ) then
        setenv CONFIG_DIRS "$CONFIG_DIRS /apps/environ"
    endif
endif


setenv ENVIRON_CONFIG_DIRS "$ENVIRON_CONFIG_DIRS $CONFIG_DIRS"

unsetenv dist
unsetenv os_version
unsetenv dist_version
unsetenv share_base
unsetenv share_arch
unsetenv CONFIG_DIRS
