# @package      hubzero-submit-server
# @file         MySQLDatabase.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import time
import MySQLdb
import logging

from hubzero.submit.LogMessage import getLogIDMessage as getLogMessage

class MySQLDatabase:
   def __init__(self,
                mysqlHost="",
                mysqlUser="",
                mysqlPassword="",
                mysqlCA=""):
      self.logger        = logging.getLogger(__name__)
      self.mysqlHost     = mysqlHost
      self.mysqlUser     = mysqlUser
      self.mysqlPassword = mysqlPassword
      self.mysqlDB       = ""
      self.mysqlCA       = mysqlCA
      self.db            = None
      self.cursor        = None


   def connect(self,
               mysqlDB,
               maximumAttempts=8):
      connected = False
      if   self.db and (mysqlDB == self.mysqlDB):
         connected = True
      elif self.db:
         self.disconnect()

      if not connected:
         if self.mysqlCA:
            sslSettings = {'ca':self.mysqlCA}
         else:
            sslSettings = {}

         attempts = 0
         delay = 1
         maxdelay = 256
         while attempts < maximumAttempts:
            try:
               attempts += 1
               self.db = MySQLdb.connect(host=self.mysqlHost,
                                         user=self.mysqlUser,
                                         passwd=self.mysqlPassword,
                                         ssl=sslSettings,
                                         db=mysqlDB)
               self.cursor = self.db.cursor()
               self.mysqlDB = mysqlDB
               connected = True
               break
            except MySQLdb.Error, err:
               self.logger.log(logging.ERROR,getLogMessage("Exception in MySQLDatabase.connect: %d %s" % (err.args[0],err.args[1])))

            time.sleep(delay)
            if delay < maxdelay:
               delay = delay * 2

      return(connected)


   def disconnect(self):
      if self.db:
         self.db.close()
         self.db      = None
         self.mysqlDB = ""


   def select(self,
              sqlCommand):
      result = ()
      try:
         count = self.cursor.execute(sqlCommand)
         result = self.cursor.fetchall()
      except MySQLdb.MySQLError, (num, expl):
         self.logger.log(logging.ERROR,getLogMessage("%s.  SQL was: %s" % (expl,sqlCommand)))
      except:
         self.logger.log(logging.ERROR,getLogMessage("Some other MySQL exception."))

      return(result)


   def update(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


   def insert(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


   def delete(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


