#!/usr/bin/python2.6
# @package      hubzero-submit-server
# @file         submit-server.py
# @author       Steven Clark <clarks@purdue.edu>
# @author       Rick Kennell <kennell@purdue.edu>
# @copyright    Copyright (c) 2006-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2006-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import os
import sys

from hubzero.submit.LogMessage   import openLog, logJobId as log
from hubzero.submit.SubmitServer import SubmitServer

LOGDIRECTORY = os.path.join(os.sep,'var','log','submit')
HUBLOGFILE   = 'submit-server.log'

PIDFILE = os.path.join(os.sep,'var','run','submit-server.pid')

CONFIGURATIONDIRECTORY = os.path.join(os.sep,'etc','submit')
CONFIGURATIONFILE      = 'submit-server.conf'
CONFIGFILEPATH         = os.path.join(CONFIGURATIONDIRECTORY,CONFIGURATIONFILE)

DISTRIBUTORDIRECTORY = os.path.join(os.sep,'opt','submit')
DISTRIBUTORSCRIPT    = 'distributor'

def daemonize():
   if os.fork():
      os._exit(os.EX_OK)
   os.setsid()
   os.chdir("/")
   if os.fork():
      os._exit(os.EX_OK)


def openLogFile(logDirectory,
                hubLogFile):
   hubLogPath = os.path.join(logDirectory,hubLogFile)
   openLog(hubLogPath)
   log(80*'#')
   log("Backgrounding process.")


def writePidFile(pidFile):
   try:
      fpPid = open(pidFile,'w')
      fpPid.write("%d\n" % (os.getpid()))
      fpPid.close()
   except:
      log("Unable to write pid (%d) to %s" % (os.getpid(),pidFile))
      os._exit(os.EX_CANTCREAT)


def server(distributorDirectory,
           distributorScript,
           configFilePath):
   submitServer = SubmitServer(distributorDirectory,distributorScript)
   if submitServer.configure(configFilePath):
      if submitServer.setupMySQL():
         if submitServer.setupListeners():
            submitServer.run()
         else:
            log("Shutting down - no listeners configured.")
            sys.exit(1)
      else:
         log("Shutting down - could not configure MySQL database.")
         sys.exit(1)
   else:
      log("Shutting down - server configuration failed.")
      sys.exit(1)


if __name__ == '__main__':
   openLogFile(LOGDIRECTORY,HUBLOGFILE)

   daemonize()

   writePidFile(PIDFILE)

   server(DISTRIBUTORDIRECTORY,DISTRIBUTORSCRIPT,CONFIGFILEPATH)

   sys.exit(0)
   
