<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="migrating_from_2x.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cpu_affinity_condor.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="16.4. Best Practices For Developing Portable Code">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="portable_code"></a>16.4. Best Practices For Developing Portable Code</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="portable_code.php#idp18202112">16.4.1. Supported Platforms</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp18206176">16.4.2. Packaging of Software</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp8345984">16.4.3. MPI Codes</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp8347616">16.4.4. Maximum Running Time of Codes</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp11630512">16.4.5. Codes cannot specify the directory in which they should be
      run</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp11633632">16.4.6. No hard-coded paths</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp11635216">16.4.7. Wrapping legacy codes with a shell wrapper</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp8971040">16.4.8. Propogating back the right exitcode</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp12636832">16.4.9. Static vs. Dynamically Linked Libraries</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp12640192">16.4.10. Temporary Files</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp7120416">16.4.11. Handling of stdio</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp22556848">16.4.12. Configuration Files</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp22560416">16.4.13. Code Invocation and input data staging by Pegasus</a></span></dt>
<dt><span class="section"><a href="portable_code.php#idp11026240">16.4.14. Logical File naming in DAX</a></span></dt>
</dl></div>
<p>This document lists out issues for the algorithm developers to keep
    in mind while developing the respective codes. Keeping these in mind will
    alleviate a lot of problems while trying to run the codes on the Grid
    through workflows.</p>
<div class="section" title="16.4.1. Supported Platforms">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp18202112"></a>16.4.1. Supported Platforms</h3></div></div></div>
<p>Most of the hosts making a Grid run variants of Linux or in some
      case Solaris. The Grid middleware mostly supports UNIX and it's
      variants.</p>
<div class="section" title="16.4.1.1. Running on Windows">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp18203424"></a>16.4.1.1. Running on Windows</h4></div></div></div>
<p>The majority of the machines making up the various Grid sites
        run Linux. In fact, there is no widespread deployment of a
        Windows-based Grid. Currently, the server side software of Globus does
        not run on Windows. Only the client tools can run on Windows. The
        algorithm developers should not code exclusively for the Windows
        platforms. They must make sure that their codes run on Linux or
        Solaris platforms. If the code is written in a portable language like
        Java, then porting should not be an issue.</p>
<p>If for some reason the code can only be executed on windows
        platform, please contact the pegasus team at pegasus aT isi dot edu .
        In certain cases it is possible to stand up a linux headnode in front
        of a windows cluster running Condor as it's scheduler.</p>
</div>
</div>
<div class="section" title="16.4.2. Packaging of Software">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp18206176"></a>16.4.2. Packaging of Software</h3></div></div></div>
<p>As far as possible, binary packages (preferably statically linked)
      of the codes should be provided. If for some reason the codes, need to
      be built from the source then they should have an associated makefile (
      for C/C++ based tools) or an ant file ( for Java tools). The building
      process should refer to the standard libraries that are part of a normal
      Linux installation. If the codes require non-standard libraries, clear
      documentation needs to be provided, as to how to install those
      libraries, and make the build process refer to those libraries.</p>
<p>Further, installing software as root is not a possibility. Hence,
      all the external libraries that need to be installed can only be
      installed as non-root in non-standard locations.</p>
</div>
<div class="section" title="16.4.3. MPI Codes">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp8345984"></a>16.4.3. MPI Codes</h3></div></div></div>
<p>If any of the algorithm codes are MPI based, they should contact
      the Grid group. MPI can be run on the Grid but the codes need to be
      compiled against the installed MPI libraries on the various Grid sites.
      The pegasus group has some experience running MPI code through
      PBS.</p>
</div>
<div class="section" title="16.4.4. Maximum Running Time of Codes">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp8347616"></a>16.4.4. Maximum Running Time of Codes</h3></div></div></div>
<p>Each of the Grid sites has a policy on the maximum time for which
      they will allow a job to run. The algorithms catalog should have the
      maximum time (in minutes) that the job can run for. This information is
      passed to the Grid sites while submitting a job, so that Grid site does
      not kill a job before that published time expires. It is OK, if the job
      runs only a fraction of the max time.</p>
</div>
<div class="section" title="16.4.5. Codes cannot specify the directory in which they should be run">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp11630512"></a>16.4.5. Codes cannot specify the directory in which they should be
      run</h3></div></div></div>
<p>Codes are installed in some standard location on the Grid Sites or
      staged on demand. However, they are not invoked from directories where
      they are installed. The codes should be able to be invoked from any
      directory, as long as one can access the directory where the codes are
      installed.</p>
<p>This is especially relevant, while writing scripts around the
      algorithm codes. At that point specifying the relative paths do not
      work. This is because the relative path is constructed from the
      directory where the script is being invoked. A suggested workaround is
      to pick up the base directory where the software is installed from the
      environment or by using the <span class="command"><strong>dirname</strong></span> cmd or api. The
      workflow system can set appropriate environment variables while
      launching jobs on the Grid.</p>
</div>
<div class="section" title="16.4.6. No hard-coded paths">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp11633632"></a>16.4.6. No hard-coded paths</h3></div></div></div>
<p>The algorithms should not hard-code any directory paths in the
      code. All directories paths should be picked up explicitly either from
      the environment (specifying environment variables) or from command line
      options passed to the algorithm code.</p>
</div>
<div class="section" title="16.4.7. Wrapping legacy codes with a shell wrapper">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp11635216"></a>16.4.7. Wrapping legacy codes with a shell wrapper</h3></div></div></div>
<p>When wrapping a legacy code in a script (or another program), it
      is necessary that the wrapper knows where the executable lives. This is
      accomplished using an environmental variable. Be sure to include this
      detail in the component description when submitting a component for use
      on the Grid -- include a brief descriptive name like GDA_BIN.</p>
</div>
<div class="section" title="16.4.8. Propogating back the right exitcode">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp8971040"></a>16.4.8. Propogating back the right exitcode</h3></div></div></div>
<p>A job in the workflow is only released for execution if its
      parents have executed successfully. Hence, it is very important that the
      algorithm codes exit with the correct error code in case of success and
      failure. The algorithms should exit with a status of 0 in case of
      success, and a non zero status in case of error. Failure to do so will
      result in erroneous workflow execution where jobs might be released for
      execution even though their parents had exited with an error.</p>
<p>The algorithm codes should catch all errors and exit with a non
      zero exitcode. The successful execution of the algorithm code can only
      be determined by an exitcode of 0. The algorithm code should not rely
      upon something being written to the stdout to designate success for e.g.
      if the algorithm code writes out to the stdout SUCCESS and exits with a
      non zero status the job would be marked as failed.</p>
<p>In *nix, a quick way to see if a code is exiting with the correct
      code is to execute the code and then execute echo $?.</p>
<pre class="programlisting">$ component-x input-file.lisp
... some output ...
$ echo $?
0</pre>
<p>If the code is not exiting correctly, it is necessary to wrap the
      code in a script that tests some final condition (such as the presence
      or format of a result file) and uses exit to return correctly.</p>
</div>
<div class="section" title="16.4.9. Static vs. Dynamically Linked Libraries">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp12636832"></a>16.4.9. Static vs. Dynamically Linked Libraries</h3></div></div></div>
<p>Since there is no way to know the profile of the machine that will
      be executing the code, it is important that dynamically linked libraries
      are avoided or that reliance on them is kept to a minimum. For example,
      a component that requires libc 2.5 may or may not run on a machine that
      uses libc 2.3. On *nix, you can use the <span class="command"><strong>ldd</strong></span> command
      to see what libraries a binary depends on.</p>
<p>If for some reason you install an algorithm specific library in a
      non standard location make sure to set the
      <code class="envar">LD_LIBRARY_PATH</code> for the algorithm in the transformation
      catalog for each site.</p>
</div>
<div class="section" title="16.4.10. Temporary Files">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp12640192"></a>16.4.10. Temporary Files</h3></div></div></div>
<p>If the algorithm codes create temporary files during execution,
      they should be cleared by the codes in case of errors and success
      terminations. The algorithm codes will run on scratch file systems that
      will also be used by others. The scratch directories get filled up very
      easily, and jobs will fail in case of directories running out of free
      space. The temporary files are the files that are not being tracked
      explicitly through the workflow generation process.</p>
</div>
<div class="section" title="16.4.11. Handling of stdio">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp7120416"></a>16.4.11. Handling of stdio</h3></div></div></div>
<p>When writing a new application, it often appears feasible to use
      <span class="emphasis"><em>stdin</em></span> for a single file data, and
      <span class="emphasis"><em>stdout</em></span> for a single file output data. The
      <span class="emphasis"><em>stderr</em></span> descriptor should be used for logging and
      debugging purposes only, never to put data on it. In the *nix world,
      this will work well, but may hiccup in the Windows world.</p>
<p>We are suggesting that you avoid using stdio for data files,
      because there is the implied expectation that stdio data gets magically
      handled. There is no magic! If you produce data on
      <span class="emphasis"><em>stdout</em></span>, you need to declare to Pegasus that your
      <span class="emphasis"><em>stdout</em></span> has your data, and what LFN Pegasus can
      track it by. After the application is done, the data product will be a
      remote file just like all other data products. If you have an input file
      on <span class="emphasis"><em>stdin</em></span>, you must track it in a similar manner. If
      you produce logs on <span class="emphasis"><em>stderr</em></span> that you care about, you
      must track it in a similar manner. Think about it this way: Whenever you
      are redirecting stdio in a *nix shell, you will also have to specify a
      file name.</p>
<p>Most execution environments permit to connect
      <span class="emphasis"><em>stdin</em></span>, <span class="emphasis"><em>stdout</em></span> or
      <span class="emphasis"><em>stderr</em></span> to any file, and Pegasus supports this case.
      However, there are certain very specific corner cases where this is not
      possible. For this reason, we recommend that in new code, you avoid
      using stdio for data, and provide alternative means on the commandline,
      i.e. via <span class="command"><strong>--input <em class="replaceable"><code>fn</code></em></strong></span> and
      <span class="command"><strong>--output <em class="replaceable"><code>fn</code></em></strong></span> commandline
      arguments instead relying on <span class="emphasis"><em>stdin</em></span> and
      <span class="emphasis"><em>stdout</em></span>.</p>
</div>
<div class="section" title="16.4.12. Configuration Files">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp22556848"></a>16.4.12. Configuration Files</h3></div></div></div>
<p>If your code requires a configuration file to run and the
      configuration changes from one run to another, then this file needs to
      be tracked explicitly via the Pegasus WMS. The configuration file should
      not contain any absolute paths to any data or libraries used by the
      code. If any libraries, scripts etc need to be referenced they should
      refer to relative paths starting with a <code class="filename">./xyz</code> where
      <code class="filename">xyz</code> is a tracked file (defined in the workflow) or
      as $ENV-VAR/xyz where <code class="envar">$ENV-VAR</code> is set during execution
      time and evaluated by your application code internally.</p>
</div>
<div class="section" title="16.4.13. Code Invocation and input data staging by Pegasus">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp22560416"></a>16.4.13. Code Invocation and input data staging by Pegasus</h3></div></div></div>
<p>Pegasus will create one temporary directory per workflow on each
      site where the workflow is planned. Pegasus will stage all the files
      required for the execution of the workflow in these temporary
      directories. This directory is shared by all the workflow components
      that executed on the site. You will have no control over where this
      directory is placed and as such you should have no expectations about
      where the code will be run. The directories are created per workflow and
      not per job/alogrithm/task. Suppose there is a component component-x
      that takes one argument: input-file.lisp (a file containing the data to
      be operated on). The staging step will bring input-file.lisp to the
      temporary directory. In *nix the call would look like this:</p>
<pre class="programlisting">$ /nfs/software/component-x input-file.lisp</pre>
<p>Note that Pegasus will call the component using the full path to
      the component. If inside your code/script you invoke some other code you
      cannot assume a path for this code to be relative or absolute. You have
      to resovle it either using a dirname $0 trick in shell assuming the
      child code is in the same directory as the parent or construct the path
      by expecting an enviornment variable to be set by the workflow system.
      These env variables need to be explicitly published so that they can be
      stored in the transformation catalog.</p>
<p>Now suppose that internally, component-x writes its results to
      /tmp/component-x-results.lisp. This is not good. Components should not
      expect that a /tmp directory exists or that it will have permission to
      write there. Instead, component-x should do one of two things: 1. write
      component-x-results.lisp to the directory where it is run from or 2.
      component-x should take a second argument output-file.lisp that
      specifies the name and path of where the results should be
      written.</p>
</div>
<div class="section" title="16.4.14. Logical File naming in DAX">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp11026240"></a>16.4.14. Logical File naming in DAX</h3></div></div></div>
<p>The logical file names used by your code can be of two
      types.</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p>Without a directory path e.g. <code class="filename">f.a</code>,
          <code class="filename">f.b</code> etc</p></li>
<li class="listitem"><p>With a directory path e.g. <code class="filename">a/1/f.a</code>,
          <code class="filename">b/2/f.b</code></p></li>
</ul></div>
<p>Both types of files are supported. We will create any directory
      structure mentioned in your logical files on the remote execution site
      when we stage in data as well as when we store the output data to a
      permanent location. An example invocation of a code that consumes and
      produces files will be</p>
<pre class="programlisting">$/bin/test --input f.a --output f.b</pre>
<p>OR</p>
<pre class="programlisting">$/bin/test --input a/1/f.a --output b/1/f.b</pre>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>A logical file name should never be an absolute file path, e.g.
        /a/1/f.a In other words, there should not be a starting slash (/) in a
        logical filename.</p>
</div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="migrating_from_2x.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="useful_tips.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cpu_affinity_condor.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">16.3. Migrating From Pegasus 2.X to Pegasus 3.X </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 16.5. Slot Partitioning and CPU Affinity in Condor</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
