<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-mpi-cluster.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-plots.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry">
<a name="cli-pegasus-plan"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-plan — runs Pegasus to generate the executable workflow</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-plan_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-plan</strong></span> [<span class="strong"><strong>-v</strong></span>] [<span class="strong"><strong>-q</strong></span>] [<span class="strong"><strong>-V</strong></span>] [<span class="strong"><strong>-h</strong></span>]<br>
             [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>prop=value</em></span>…]] [<span class="strong"><strong>-b</strong></span> prefix]<br>
             [<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propsfile</em></span>]<br>
             [<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>cachefile</em></span>[,<span class="emphasis"><em>cachefile</em></span>…]] [<span class="strong"><strong>--cleanup</strong></span> <span class="emphasis"><em>cleanup strategy</em></span> ]<br>
             [<span class="strong"><strong>-C</strong></span> <span class="emphasis"><em>style</em></span>[,<span class="emphasis"><em>style</em></span>…]]<br>
             [<span class="strong"><strong>--dir</strong></span> <span class="emphasis"><em>dir</em></span>]<br>
             [<span class="strong"><strong>--force</strong></span>] [<span class="strong"><strong>--force-replan</strong></span>]<br>
             [<span class="strong"><strong>--inherited-rc-files</strong></span>] [<span class="strong"><strong>-j</strong></span> <span class="emphasis"><em>prefix</em></span>]<br>
             [<span class="strong"><strong>-n</strong></span>][<span class="strong"><strong>-I</strong></span> <span class="emphasis"><em>input-dir</em></span>][<span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>output-dir</em></span>] [<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>site</em></span>]<br>
             [<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>site1</em></span>[,<span class="emphasis"><em>site2</em></span>…]]<br>
             [<span class="strong"><strong>--staging-site</strong></span> s1=ss1[,s2=ss2[..]]<br>
             [<span class="strong"><strong>--randomdir</strong></span>[=<span class="emphasis"><em>dirname</em></span>]]<br>
             [<span class="strong"><strong>--relative-dir</strong></span> <span class="emphasis"><em>dir</em></span>]<br>
             [<span class="strong"><strong>--relative-submit-dir</strong></span> <span class="emphasis"><em>dir</em></span>]<br>
             <span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>daxfile</em></span></p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-plan_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-plan</strong></span> command takes in as input the DAX and generates an
executable workflow usually in form of <span class="strong"><strong>condor</strong></span> submit files, which
can be submitted to an <span class="emphasis"><em>execution</em></span> site for execution.</p>
<p>As part of generating an executable workflow, the planner needs to discover:</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>data</strong></span>
</span></dt>
<dd>
<p class="simpara">
The Pegasus Workflow Planner ensures that all the data required for the
execution of the executable workflow is transferred to the execution site
by adding transfer nodes at appropriate points in the DAG. This is done by
looking up an appropriate <span class="strong"><strong>Replica Catalog</strong></span> to determine the locations of
the input files for the various jobs. By default, a file based replica
catalog is used.
</p>
<p class="simpara">The Pegasus Workflow Planner also tries to reduce the workflow, unless
specified otherwise. This is done by deleting the jobs whose output files
have been found in some location in the Replica Catalog. At present no
cost metrics are used. However preference is given to a location
corresponding to the execution site</p>
<p class="simpara">The planner can also add nodes to transfer all the materialized files to
an output site. The location on the output site is determined by looking
up the site catalog file, the path to which is picked up from the
<span class="strong"><strong>pegasus.catalog.site.file</strong></span> property value.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>executables</strong></span>
</span></dt>
<dd>
The planner looks up a Transformation Catalog to discover locations of
the executables referred to in the executable workflow. Users can specify
INSTALLED or STAGEABLE executables in the catalog. Stageable executables
can be used by Pegasus to stage executables to resources where they are
not pre-installed.
</dd>
<dt><span class="term">
<span class="strong"><strong>resources</strong></span>
</span></dt>
<dd>
The layout of the sites, where Pegasus can schedule jobs of a workflow
are described in the Site Catalog. The planner looks up the site catalog
to determine for a site what directories a job can be executed in, what
servers to use for staging in and out data and what jobmanagers (if
applicable) can be used for submitting jobs.
</dd>
</dl></div>
<p>The data and executable locations can now be specified in DAX’es conforming
to DAX schema version 3.2 or higher.</p>
</div>
<div class="refsect1">
<a name="pegasus-plan_options"></a><h2>Options</h2>
<p>Any option will be displayed with its long options synonym(s).</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
The <span class="strong"><strong>-D</strong></span> option allows an experienced user to override certain
properties which influence the program execution, among them the
default location of the user’s properties file and the PEGASUS home
location. One may set several CLI properties by giving this option
multiple times. The <span class="strong"><strong>-D</strong></span> option(s) must be the first option on the
command line. A CLI property take precedence over the properties file
property of the same key.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span> <span class="emphasis"><em>file</em></span>
, </span><span class="term">
<span class="strong"><strong>--dax</strong></span> <span class="emphasis"><em>file</em></span>
</span>
</dt>
<dd>
The DAX is the XML input file that describes an abstract workflow.
This is a mandatory option, which has to be used.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-b</strong></span> <span class="emphasis"><em>prefix</em></span>
, </span><span class="term">
<span class="strong"><strong>--basename</strong></span> <span class="emphasis"><em>prefix</em></span>
</span>
</dt>
<dd>
The basename prefix to be used while constructing per workflow files
like the dagman file (.dag file) and other workflow specific files
that are created by Condor. Usually this prefix, is taken from the
name attribute specified in the root element of the dax files.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>file</em></span>[,<span class="emphasis"><em>file</em></span>,…]
, </span><span class="term">
<span class="strong"><strong>--cache</strong></span> <span class="emphasis"><em>file</em></span>[,<span class="emphasis"><em>file</em></span>,…]
</span>
</dt>
<dd>
<p class="simpara">
A comma separated list of paths to replica cache files that override
the results from the replica catalog for a particular LFN.
</p>
<p class="simpara">Each entry in the cache file describes a LFN , the corresponding PFN and
the associated attributes. The site attribute should be specified for
each entry.</p>
<pre class="screen">LFN_1 PFN_1 site=[site handle 1]
LFN_2 PFN_2 site=[site handle 2]
 ...
LFN_N PFN_N [site handle N]</pre>
<p class="simpara">To treat the cache files as supplemental replica catalogs set the
property <span class="strong"><strong>pegasus.catalog.replica.cache.asrc</strong></span> to true. This results
in the mapping in the cache files to be merged with the mappings in
the replica catalog. Thus, for a particular LFN both the entries in
the cache file and replica catalog are available for replica selection.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-C</strong></span> <span class="emphasis"><em>style</em></span>[,<span class="emphasis"><em>style</em></span>,…]
, </span><span class="term">
<span class="strong"><strong>--cluster</strong></span> <span class="emphasis"><em>style</em></span>[,<span class="emphasis"><em>style</em></span>,…]
</span>
</dt>
<dd>
<p class="simpara">
Comma-separated list of clustering styles to apply to the workflow.
This mode of operation results in clustering of n compute jobs into a
larger jobs to reduce remote scheduling overhead. You can specify a
list of clustering techniques to recursively apply them to the
workflow. For example, this allows you to cluster some jobs in the
workflow using horizontal clustering and then use label based
clustering on the intermediate workflow to do vertical clustering.
</p>
<p class="simpara">The clustered jobs can be run at the remote site, either sequentially
or by using MPI. This can be specified by setting the property
<span class="strong"><strong>pegasus.job.aggregator</strong></span>. The property can be overridden by associating
the PEGASUS profile key <span class="emphasis"><em>collapser</em></span> either with the transformation in the
transformation catalog or the execution site in the site catalog. The
value specified (to the property or the profile), is the logical name
of the transformation that is to be used for clustering jobs. Note that
clustering will only happen if the corresponding transformations are
catalogued in the transformation catalog.</p>
<p class="simpara">PEGASUS ships with a clustering executable <span class="emphasis"><em>pegasus-cluster</em></span> that can be found
in the <span class="emphasis"><em>$PEGASUS_HOME/bin</em></span> directory. It runs the jobs in the clustered
job sequentially on the same node at the remote site.</p>
<p class="simpara">In addition, an MPI based clustering tool called
pegasus-mpi-cluster', is also distributed and can be found in the bin
directory. pegasus-mpi-cluster can also be used in the sharedfs setup
and needs to be compiled against the remote site MPI install.
directory. The wrapper is run on every MPI node, with the first one
being the master and the rest of the ones as workers.</p>
<p class="simpara">By default, <span class="emphasis"><em>pegasus-cluster</em></span> is used for clustering jobs unless overridden
in the properties or by the pegasus profile key <span class="emphasis"><em>collapser</em></span>.</p>
<p class="simpara">The following type of clustering styles are currently supported:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<p class="simpara">
<span class="strong"><strong>horizontal</strong></span> is the style of clustering in which jobs on the same level
are aggregated into larger jobs. A level of the workflow is defined as the
greatest distance of a node, from the root of the workflow. Clustering
occurs only on jobs of the same type i.e they refer to the same
logical transformation in the transformation catalog.
</p>
<p class="simpara">Horizontal Clustering can operate in one of two modes.
a. Job count based.</p>
<p class="simpara">The granularity of clustering can be specified by associating either
the PEGASUS profile key  <span class="emphasis"><em>clusters.size</em></span> or the PEGASUS profile key
<span class="emphasis"><em>clusters.num</em></span> with the transformation.</p>
<p class="simpara">The <span class="emphasis"><em>clusters.size</em></span> key indicates how many jobs need to be clustered into
the larger clustered job. The clusters.num key indicates how many clustered
jobs are to be created for a particular level at a particular
execution site. If both keys are specified for a particular
transformation, then the clusters.num key value is used to determine the
clustering granularity.</p>
<div class="orderedlist"><ol class="orderedlist" type="a"><li class="listitem">
<p class="simpara">
Runtime based.
</p>
<p class="simpara">To cluster jobs according to runtimes user needs to set one property and two profile keys.
The property pegasus.clusterer.preference must be set to the value <span class="emphasis"><em>runtime</em></span>.
In addition user needs to specify two Pegasus profiles.
a. clusters.maxruntime which specifies the maximum duration for which the clustered job should run for.
b. job.runtime which specifies the duration for which the job with which the profile key is associated, runs for.
Ideally, clusters.maxruntime should be set in transformation catalog and job.runtime should be set for each job individually.</p>
</li></ol></div>
</li>
<li class="listitem">
<p class="simpara">
<span class="strong"><strong>label</strong></span> is the style of clustering in which you can label the jobs in
your workflow. The jobs with the same level are put in the same clustered
job. This allows you to aggregate jobs across levels, or in a manner
that is best suited to your application.
</p>
<p class="simpara">To label the workflow, you need to associate PEGASUS profiles with the
jobs in the DAX. The profile key to use for labeling the workflow can
be set by the property <span class="emphasis"><em>pegasus.clusterer.label.key</em></span>.
It defaults to label, meaning if you have a PEGASUS profile key label
with jobs, the jobs with the same value for the pegasus profile key label
will go into the same clustered job.</p>
</li>
</ul></div>
</dd>
<dt><span class="term">
<span class="strong"><strong>--cleanup</strong></span> <span class="emphasis"><em>cleanup strategy</em></span>
</span></dt>
<dd>
<p class="simpara">
The cleanup strategy to be used for workflows. Pegasus can add cleanup
jobs to the executable workflow that can remove files and directories
during the workflow execution. The default strategy is inplace .
</p>
<p class="simpara">The following type of cleanup strategies are currently supported:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<span class="strong"><strong>none</strong></span> disables cleanup altogether. The planner does not add any
cleanup jobs in the executable workflow whatsoever.
</li>
<li class="listitem">
<span class="strong"><strong>leaf</strong></span> the planner adds a leaf cleanup node per staging site that
removes the directory created by the create dir job in the workflow.
</li>
<li class="listitem">
<p class="simpara">
<span class="strong"><strong>inplace</strong></span> the planner adds in addition to leaf cleanup nodes,
cleanup nodes per level of the workflow that remove files no longer
required during execution. For example, an added cleanup node will
remove input files for a particular compute job after the job has
finished successfully.
</p>
<p class="simpara">By default, for hierarchal workflows the inplace cleanup is always
turned off. This is because the cleanup algorithm ( InPlace ) does not
work across the sub workflows. For example, if you have two DAX jobs
in your top level workflow and the child DAX job refers to a file
generated during the execution of the parent DAX job, the InPlace
cleanup algorithm when applied to the parent dax job will result in
the file being deleted, when the sub workflow corresponding to parent
DAX job is executed. This would result in failure of sub workflow
corresponding to the child DAX job, as the file deleted is required to
present during it’s execution.</p>
<p class="simpara">In case there are no data dependencies across the dax jobs, then yes
you can enable the InPlace algorithm for the sub dax’es . To do this
you can set the property</p>
<p class="simpara">pegasus.file.cleanup.scope deferred</p>
<p class="simpara">This will result in cleanup option to be picked up from the arguments
for the DAX job in the top level DAX.</p>
</li>
</ul></div>
</dd>
<dt><span class="term">
<span class="strong"><strong>--conf</strong></span> <span class="emphasis"><em>propfile</em></span>
</span></dt>
<dd>
The path to properties file that contains the properties planner needs to
use while planning the workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>--dir</strong></span> <span class="emphasis"><em>dir</em></span>
</span></dt>
<dd>
<p class="simpara">
The base directory where you want the output of the Pegasus Workflow
Planner usually condor submit files, to be generated. Pegasus creates
a directory structure in this base directory on the basis of username,
VO Group and the label of the workflow in the DAX.
</p>
<p class="simpara">By default the base directory is the directory from which one runs the
<span class="strong"><strong>pegasus-plan</strong></span> command.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-f</strong></span>
, </span><span class="term">
<span class="strong"><strong>--force</strong></span>
</span>
</dt>
<dd>
This bypasses the reduction phase in which the abstract DAG is
reduced, on the basis of the locations of the output files returned by
the replica catalog. This is analogous to a <span class="strong"><strong>make</strong></span> style generation of
the executable workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>--force-replan</strong></span>
</span></dt>
<dd>
By default, for hierarichal workflows if a DAX job fails, then on job retry
the rescue DAG of the associated workflow is submitted. This option causes
Pegasus to replan the DAX job in case of failure instead.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-g</strong></span>
, </span><span class="term">
<span class="strong"><strong>--group</strong></span>
</span>
</dt>
<dd>
The VO Group to which the user belongs to.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Displays all the options to the <span class="strong"><strong>pegasus-plan</strong></span> command.
</dd>
<dt><span class="term">
<span class="strong"><strong>--inherited-rc-files</strong></span> <span class="emphasis"><em>file</em></span>[,<span class="emphasis"><em>file</em></span>,…]
</span></dt>
<dd>
A comma separated list of paths to replica files. Locations mentioned in these
have a lower priority than the locations in the DAX file. This option is usually
used internally for hierarchical workflows, where the file locations mentioned in
the parent (encompassing) workflow DAX, passed to the sub workflows (corresponding)
to the DAX jobs.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-I</strong></span>
, </span><span class="term">
<span class="strong"><strong>--input-dir</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
A path to the input directory where the input files reside. This
internally loads a Directory based Replica Catalog backend, that
constructs does a directory listing to create the LFN→PFN mappings
for the files in the input directory. You can specify additional
properties either on the command line or the properties file to
control the site attribute and url prefix associated with the
mappings.
</p>
<p class="simpara">pegasus.catalog.replica.directory.site  specifies the site attribute
to associate with the mappings. Defaults to local</p>
<p class="simpara">pegasus.catalog.replica.directory.url.prefix specifies the URL prefix
to use while constructing the PFN. Defaults to file://</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-j</strong></span> <span class="emphasis"><em>prefix</em></span>
, </span><span class="term">
<span class="strong"><strong>--job-prefix</strong></span> <span class="emphasis"><em>prefix</em></span>
</span>
</dt>
<dd>
The job prefix to be applied for constructing the filenames for the
job submit files.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-n</strong></span>
, </span><span class="term">
<span class="strong"><strong>--nocleanup</strong></span>
</span>
</dt>
<dd>
This option is deprecated. Use --cleanup none instead.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>site</em></span>
, </span><span class="term">
<span class="strong"><strong>--output-site</strong></span> <span class="emphasis"><em>site</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The output site to which the output files of the DAX are transferred to.
</p>
<p class="simpara">By default the <span class="strong"><strong>materialized data</strong></span> remains in the working directory on the
<span class="strong"><strong>execution</strong></span> site where it was created. Only those output files are
transferred to an output site for which  transfer attribute is set to
true in the DAX.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-O</strong></span> <span class="emphasis"><em>output directory</em></span>
, </span><span class="term">
<span class="strong"><strong>--output-dir</strong></span> <span class="emphasis"><em>output directory</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The output directory to which the output files of the DAX are
transferred to.
</p>
<p class="simpara">If -o is specified the storage directory of the site specified as the
output site is updated to be the directory passed. If no output site
is specified, then this option internally sets the output site to
local with the storage directory updated to the directory passed.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
Decreases the logging level.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span>[<span class="emphasis"><em>dirname</em></span>]
, </span><span class="term">
<span class="strong"><strong>--randomdir</strong></span>[=<span class="emphasis"><em>dirname</em></span>]
</span>
</dt>
<dd>
<p class="simpara">
Pegasus Worfklow Planner adds create directory jobs to the executable
workflow that create a directory in which all jobs for that workflow
execute on a particular site. The directory created is in the working
directory (specified in the site catalog with each site).
</p>
<p class="simpara">By default, Pegasus duplicates the relative directory structure on the
submit host on the remote site. The user can specify this option
without arguments to create a random timestamp based name for the
execution directory that are created by the create dir jobs.
The user can can specify the optional argument to this option to
specify the basename of the directory that is to be created.</p>
<p class="simpara">The create dir jobs refer to the <span class="strong"><strong>dirmanager</strong></span> executable that is shipped
as part of the PEGASUS worker package. The transformation catalog is
searched for the transformation named <span class="strong"><strong>pegasus::dirmanager</strong></span>
for all the remote sites where the workflow has been scheduled. Pegasus
can create a default path for the dirmanager executable, if <span class="strong"><strong>PEGASUS_HOME</strong></span>
environment variable is associated with the sites in the site catalog
as an environment profile.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>--relative-dir</strong></span> <span class="emphasis"><em>dir</em></span>
</span></dt>
<dd>
The directory relative to the base directory where the executable
workflow it to be generated and executed. This overrides the default directory
structure that Pegasus creates based on username, VO Group and the DAX
label.
</dd>
<dt><span class="term">
<span class="strong"><strong>--relative-submit-dir</strong></span> <span class="emphasis"><em>dir</em></span>
</span></dt>
<dd>
The directory relative to the base directory where the executable
workflow it to be generated. This overrides the default directory
structure that Pegasus creates based on username, VO Group and the DAX
label. By specifying <span class="strong"><strong>--relative-dir</strong></span> and <span class="strong"><strong>--relative-submit-dir</strong></span> you
can have different relative execution directory on the remote site and
different relative submit directory on the submit host.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>site</em></span>[,<span class="emphasis"><em>site</em></span>,…]
, </span><span class="term">
<span class="strong"><strong>--sites</strong></span> <span class="emphasis"><em>site</em></span>[,<span class="emphasis"><em>site</em></span>,…]
</span>
</dt>
<dd>
<p class="simpara">
A comma separated list of execution sites on which the workflow is to be
executed. Each of the sites should have an entry in the site catalog,
that is being used. To run on the submit host, specify the execution
site as <span class="strong"><strong>local</strong></span>.
</p>
<p class="simpara">In case this option is not specified, all the sites in the site
catalog are picked up as candidates for running the workflow.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>--staging-site</strong></span> <span class="emphasis"><em>s1=ss1</em></span>[,s2=ss2[..]]
</span></dt>
<dd>
<p class="simpara">
A comma separated list of key=value pairs , where the key is the
execution site and value is the staging site for that execution
site.
</p>
<p class="simpara">In case of running on a shared filesystem, the staging site is
automatically associated by the planner to be the execution site.  If
only a value is specified, then that is taken to be the staging site
for all the execution sites. e.g <span class="strong"><strong>--staging-site</strong></span> local means that the
planner will use the local site as the staging site for all jobs in
the workflow.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span>
, </span><span class="term">
<span class="strong"><strong>--submit</strong></span>
</span>
</dt>
<dd>
Submits the generated <span class="strong"><strong>executable workflow</strong></span> using <span class="strong"><strong>pegasus-run</strong></span> script in
$PEGASUS_HOME/bin directory. By default, the Pegasus Workflow Planner only
generates the Condor submit files and does not submit them.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
Increases the verbosity of messages about what is going on. By default, all
FATAL, ERROR, CONSOLE and WARN messages are logged. The logging hierarchy
is as follows:
</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
FATAL
</li>
<li class="listitem">
ERROR
</li>
<li class="listitem">
CONSOLE
</li>
<li class="listitem">
WARN
</li>
<li class="listitem">
INFO
</li>
<li class="listitem">
CONFIG
</li>
<li class="listitem">
DEBUG
</li>
<li class="listitem">
TRACE
</li>
</ol></div>
<p class="simpara">For example, to see the INFO, CONFIG and DEBUG messages additionally, set
<span class="strong"><strong>-vvv</strong></span>.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Displays the current version number of the Pegasus Workflow Management System.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-plan_return_value"></a><h2>Return Value</h2>
<p>If the Pegasus Workflow Planner is able to generate an executable workflow
successfully, the exitcode will be 0. All runtime errors result in an
exitcode of 1. This is usually in the case when you have misconfigured
your catalogs etc. In the case of an error occurring while loading a
specific module implementation at run time, the exitcode will be
2. This is usually due to factory methods failing while loading a
module.  In case of any other error occurring during the running of the
command, the exitcode will be 1. In most cases, the error message
logged should give a clear indication as to where things went wrong.</p>
</div>
<div class="refsect1">
<a name="pegasus-plan_controlling_pegasus_plan_memory_consumption"></a><h2>Controlling pegasus-plan Memory Consumption</h2>
<p>pegasus-plan will try to determine memory limits automatically using
factors such as total system memory and potential memory limits
(ulimits). The automatic limits can be overridden by setting the
JAVA_HEAPMIN and JAVA_HEAPMAX environment variables before invoking
pegasus-plan. The values are in megabytes. As a rule of thumb,
JAVA_HEAPMIN can be set to half of the value of JAVA_HEAPMAX.</p>
</div>
<div class="refsect1">
<a name="pegasus-plan_pegasus_properties"></a><h2>Pegasus Properties</h2>
<p>This is not an exhaustive list of properties used. For the complete
description and list of properties refer to
<span class="strong"><strong>$PEGASUS_HOME/doc/advanced-properties.pdf</strong></span></p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>pegasus.selector.site</strong></span>
</span></dt>
<dd>
Identifies what type of site selector you want to use. If not
specified the default value of <span class="strong"><strong>Random</strong></span> is used. Other supported modes are
<span class="strong"><strong>RoundRobin</strong></span> and <span class="strong"><strong>NonJavaCallout</strong></span> that calls out to a external site selector.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica</strong></span>
</span></dt>
<dd>
<p class="simpara">
Specifies the type of replica catalog to be used.
</p>
<p class="simpara">If not specified, then the value defaults to <span class="strong"><strong>File</strong></span>.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.replica.url</strong></span>
</span></dt>
<dd>
Contact string to access the replica catalog. In case of File it is
path to the file based replica catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.dir.exec</strong></span>
</span></dt>
<dd>
A suffix to the workdir in the site catalog to determine the current
working directory. If relative, the value will be appended to the
working directory from the site.config file. If absolute it
constitutes the  working directory.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.transformation</strong></span>
</span></dt>
<dd>
Specifies the type of transformation catalog to be used. One can use
only a file based transformation catalog, with the value as <span class="strong"><strong>Text</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.transformation.file</strong></span>
</span></dt>
<dd>
<p class="simpara">
The location of file to use as transformation catalog.
</p>
<p class="simpara">If not specified, then the default location of $PEGASUS_HOME/etc/tc.text</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.site</strong></span>
</span></dt>
<dd>
Specifies the type of site catalog to be used. One can use either a
text based or an xml based site catalog.  At present the default is
<span class="strong"><strong>XML</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.catalog.site.file</strong></span>
</span></dt>
<dd>
The location of file to use as a site catalog. If not specified, then
default value of $PEGASUS_HOME/etc/sites.xml is used in case of the xml
based site catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.data.configuration</strong></span>
</span></dt>
<dd>
<p class="simpara">
This property sets up Pegasus to run in different environments. This
can be set to
</p>
<p class="simpara"><span class="strong"><strong>sharedfs</strong></span>
If this is set, Pegasus will be setup to execute jobs on the shared
filesystem on the execution site. This assumes, that the head node of
a cluster and the worker nodes share a filesystem. The staging site in
this case is the same as the execution site.</p>
<p class="simpara"><span class="strong"><strong>nonsharedfs</strong></span>
If this is set, Pegasus will be setup to execute jobs on an execution
site without relying on a shared filesystem between the head node and
the worker nodes.</p>
<p class="simpara"><span class="strong"><strong>condorio</strong></span>
If this is set, Pegasus will be setup to run jobs in a pure condor
pool, with the nodes not sharing a filesystem. Data is staged to the
compute nodes from the submit host using Condor File IO.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus.code.generator</strong></span>
</span></dt>
<dd>
The code generator to use. By default, Condor submit files are generated
for the executable workflow. Setting to <span class="strong"><strong>Shell</strong></span> results in Pegasus
generating a shell script that can be executed on the submit host.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-plan_files"></a><h2>Files</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/dax-3.3.xsd</strong></span>
</span></dt>
<dd>
is the suggested location of the latest DAX schema to produce DAX
output.
</dd>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/sc-4.0.xsd</strong></span>
</span></dt>
<dd>
is the suggested location of the latest Site Catalog schema that is
used to create the XML version of the site catalog
</dd>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/tc.data.text</strong></span>
</span></dt>
<dd>
is the suggested location for the file corresponding to the
Transformation Catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/etc/sites.xml4</strong></span> | <span class="strong"><strong>$PEGASUS_HOME/etc/sites.xml3</strong></span>
</span></dt>
<dd>
is the suggested location for the file containing the site information.
</dd>
<dt><span class="term">
<span class="strong"><strong>$PEGASUS_HOME/lib/pegasus.jar</strong></span>
</span></dt>
<dd>
contains all compiled Java bytecode to run the Pegasus Workflow Planner.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-plan_see_also"></a><h2>See Also</h2>
<p>pegasus-run(1), pegasus-status(1), pegasus-remove(1), pegasus-rc-client(1), pegasus-analyzer(1)</p>
</div>
<div class="refsect1">
<a name="pegasus-plan_authors"></a><h2>Authors</h2>
<p>Karan Vahi <code class="literal">&lt;vahi at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-mpi-cluster.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-plots.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-mpi-cluster </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-plots</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
