<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="api.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="ch14s03.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="14.2. DAX Generator API">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="dax_generator_api"></a>14.2. DAX Generator API</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="dax_generator_api.php#api-java">14.2.1. The Java DAX Generator API</a></span></dt>
<dt><span class="section"><a href="dax_generator_api.php#api-python">14.2.2. The Python DAX Generator API</a></span></dt>
<dt><span class="section"><a href="dax_generator_api.php#api-perl">14.2.3. The Perl DAX Generator</a></span></dt>
</dl></div>
<p>The DAX generating APIs support Java, Perl and Python. This section
    will show in each language the necessary code, using Pegasus-provided
    libraries, to generate the diamond DAX example above. There may be minor
    differences in details, e.g. to show-case certain features, but
    effectively all generate the same basic diamond.</p>
<div class="section" title="14.2.1. The Java DAX Generator API">
<div class="titlepage"><div><div><h3 class="title">
<a name="api-java"></a>14.2.1. The Java DAX Generator API</h3></div></div></div>
<p>The Java DAX API provided with the Pegasus distribution allows
      easy creation of complex and huge workflows. This API is used by several
      applications to generate their abstract DAX. SCEC, which is Southern
      California Earthquake Center, uses this API in their CyberShake workflow
      generator to generate huge DAX containing 10&amp;rsquor;s of thousands
      of tasks with 100&amp;rsquor;s of thousands of input and output files.
      The <a class="ulink" href="javadoc/index.html" target="_top">Java API</a> is well documented
      using <a class="ulink" href="javadoc/edu/isi/pegasus/planner/dax/ADAG.html" target="_top">Javadoc
      for ADAGs</a> .</p>
<p>The steps involved in creating a DAX using the API are</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Create a new <span class="emphasis"><em>ADAG</em></span> object</p></li>
<li class="listitem"><p>Add any Workflow notification elements</p></li>
<li class="listitem"><p>Create <span class="emphasis"><em>File</em></span> objects as necessary. You can
          augment the files with physical information, if you want to include
          them into your DAX. Otherwise, the physical information is
          determined from the replica catalog.</p></li>
<li class="listitem"><p>(Optional) Create <span class="emphasis"><em>Executable</em></span> objects, if
          you want to include your transformation catalog into your DAX.
          Otherwise, the translation of a job/task into executable location
          happens with the transformation catalog.</p></li>
<li class="listitem"><p>Create a new <span class="emphasis"><em>Job</em></span> object.</p></li>
<li class="listitem"><p>Add arguments, files, profiles, notifications and other
          information to the <span class="emphasis"><em>Job</em></span> object</p></li>
<li class="listitem"><p>Add the job object to the <span class="emphasis"><em>ADAG</em></span>
          object</p></li>
<li class="listitem"><p>Repeat step 4-6 as necessary.</p></li>
<li class="listitem"><p>Add all dependencies to the <span class="emphasis"><em>ADAG</em></span>
          object.</p></li>
<li class="listitem"><p>Call the <span class="emphasis"><em>writeToFile()</em></span> method on the
          <span class="emphasis"><em>ADAG</em></span> object to render the XML DAX file.</p></li>
</ol></div>
<p>An example Java code that generates the diamond dax show above is
      listed below. This same code can be found in the Pegasus distribution in
      the <code class="filename">examples/grid-blackdiamond-java</code> directory
      as <code class="filename">BlackDiamonDAX.java</code>:</p>
<pre class="programlisting">/**
 *  Copyright 2007-2008 University Of Southern California
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import edu.isi.pegasus.planner.dax.*;


/**
 * An example class to highlight how to use the JAVA DAX API to generate a diamond
 * DAX.
 * 
 */
public class Diamond {

    

    public ADAG generate(String site_handle, String pegasus_location) throws Exception {

        java.io.File cwdFile = new java.io.File (".");
        String cwd = cwdFile.getCanonicalPath(); 

        ADAG dax = new ADAG("blackdiamond");
        dax.addNotification(Invoke.WHEN.start,"/pegasus/libexec/notification/email -t notify@example.com");
        dax.addNotification(Invoke.WHEN.at_end,"/pegasus/libexec/notification/email -t notify@example.com");
        File fa = new File("f.a");
        fa.addPhysicalFile("file://" + cwd + "/f.a", "local");
        dax.addFile(fa);

        File fb1 = new File("f.b1");
        File fb2 = new File("f.b2");
        File fc1 = new File("f.c1");
        File fc2 = new File("f.c2");
        File fd = new File("f.d");
        fd.setRegister(true);

        Executable preprocess = new Executable("pegasus", "preprocess", "4.0");
        preprocess.setArchitecture(Executable.ARCH.X86).setOS(Executable.OS.LINUX);
        preprocess.setInstalled(true);
        preprocess.addPhysicalFile("file://" + pegasus_location + "/bin/keg", site_handle);

        Executable findrange = new Executable("pegasus", "findrange", "4.0");
        findrange.setArchitecture(Executable.ARCH.X86).setOS(Executable.OS.LINUX);
        findrange.setInstalled(true);
        findrange.addPhysicalFile("file://" + pegasus_location + "/bin/keg", site_handle);

        Executable analyze = new Executable("pegasus", "analyze", "4.0");
        analyze.setArchitecture(Executable.ARCH.X86).setOS(Executable.OS.LINUX);
        analyze.setInstalled(true);
        analyze.addPhysicalFile("file://" + pegasus_location + "/bin/keg", site_handle);

        dax.addExecutable(preprocess).addExecutable(findrange).addExecutable(analyze);

        // Add a preprocess job
        Job j1 = new Job("j1", "pegasus", "preprocess", "4.0");
        j1.addArgument("-a preprocess -T 60 -i ").addArgument(fa);
        j1.addArgument("-o ").addArgument(fb1);
        j1.addArgument(" ").addArgument(fb2);
        j1.uses(fa, File.LINK.INPUT);
        j1.uses(fb1, File.LINK.OUTPUT);
        j1.uses(fb2, File.LINK.OUTPUT);
        j1.addNotification(Invoke.WHEN.start,"/pegasus/libexec/notification/email -t notify@example.com");
        j1.addNotification(Invoke.WHEN.at_end,"/pegasus/libexec/notification/email -t notify@example.com");
        dax.addJob(j1);

        // Add left Findrange job
        Job j2 = new Job("j2", "pegasus", "findrange", "4.0");
        j2.addArgument("-a findrange -T 60 -i ").addArgument(fb1);
        j2.addArgument("-o ").addArgument(fc1);
        j2.uses(fb1, File.LINK.INPUT);
        j2.uses(fc1, File.LINK.OUTPUT);
        j2.addNotification(Invoke.WHEN.start,"/pegasus/libexec/notification/email -t notify@example.com");
        j2.addNotification(Invoke.WHEN.at_end,"/pegasus/libexec/notification/email -t notify@example.com");
        dax.addJob(j2);

        // Add right Findrange job
        Job j3 = new Job("j3", "pegasus", "findrange", "4.0");
        j3.addArgument("-a findrange -T 60 -i ").addArgument(fb2);
        j3.addArgument("-o ").addArgument(fc2);
        j3.uses(fb2, File.LINK.INPUT);
        j3.uses(fc2, File.LINK.OUTPUT);
        j3.addNotification(Invoke.WHEN.start,"/pegasus/libexec/notification/email -t notify@example.com");
        j3.addNotification(Invoke.WHEN.at_end,"/pegasus/libexec/notification/email -t notify@example.com");
        dax.addJob(j3);

        // Add analyze job
        Job j4 = new Job("j4", "pegasus", "analyze", "4.0");
        j4.addArgument("-a analyze -T 60 -i ").addArgument(fc1);
        j4.addArgument(" ").addArgument(fc2);
        j4.addArgument("-o ").addArgument(fd);
        j4.uses(fc1, File.LINK.INPUT);
        j4.uses(fc2, File.LINK.INPUT);
        j4.uses(fd, File.LINK.OUTPUT);
        j4.addNotification(Invoke.WHEN.start,"/pegasus/libexec/notification/email -t notify@example.com");
        j4.addNotification(Invoke.WHEN.at_end,"/pegasus/libexec/notification/email -t notify@example.com");
        dax.addJob(j4);

        dax.addDependency("j1", "j2");
        dax.addDependency("j1", "j3");
        dax.addDependency("j2", "j4");
        dax.addDependency("j3", "j4");
        return dax;
    }
    
    /**
     * Create an example DIAMOND DAX
     * @param args
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java GenerateDiamondDAX  &lt;pegasus_location&gt; ");
            System.exit(1);
        }

        try {
            Diamond diamond = new Diamond();
            String pegasusHome = args[0];
            String site = "TestCluster";
            ADAG dag = diamond.generate( site, pegasusHome );
            dag.writeToSTDOUT();
            //generate(args[0], args[1]).writeToFile(args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }

    }
}

</pre>
<p>Of course, you will have to set up some catalogs and properties to
      run this example. The details are catpured in the examples directory
      <code class="filename">examples/grid-blackdiamond-java</code>.</p>
</div>
<div class="section" title="14.2.2. The Python DAX Generator API">
<div class="titlepage"><div><div><h3 class="title">
<a name="api-python"></a>14.2.2. The Python DAX Generator API</h3></div></div></div>
<p>Refer to the <a class="ulink" href="python/" target="_top">auto-generated python
      documentation</a> explaining this API.</p>
<pre class="programlisting">#!/usr/bin/env python

from Pegasus.DAX3 import *
import sys
import os

if len(sys.argv) != 2:
        print "Usage: %s PEGASUS_HOME" % (sys.argv[0])
        sys.exit(1)

# Create a abstract dag
diamond = ADAG("diamond")

# Add input file to the DAX-level replica catalog
a = File("f.a")
a.addPFN(PFN("file://" + os.getcwd() + "/f.a", "local"))
diamond.addFile(a)
        
# Add executables to the DAX-level replica catalog
# In this case the binary is keg, which is shipped with Pegasus, so we use
# the remote PEGASUS_HOME to build the path.
e_preprocess = Executable(namespace="diamond", name="preprocess", version="4.0", os="linux", arch="x86_64")
e_preprocess.addPFN(PFN("file://" + sys.argv[1] + "/bin/keg", "TestCluster"))
diamond.addExecutable(e_preprocess)
        
e_findrange = Executable(namespace="diamond", name="findrange", version="4.0", os="linux", arch="x86_64")
e_findrange.addPFN(PFN("file://" + sys.argv[1] + "/bin/keg", "TestCluster"))
diamond.addExecutable(e_findrange)
        
e_analyze = Executable(namespace="diamond", name="analyze", version="4.0", os="linux", arch="x86_64")
e_analyze.addPFN(PFN("file://" + sys.argv[1] + "/bin/keg", "TestCluster"))
diamond.addExecutable(e_analyze)

# Add a preprocess job
preprocess = Job(namespace="diamond", name="preprocess", version="4.0")
b1 = File("f.b1")
b2 = File("f.b2")
preprocess.addArguments("-a preprocess","-T60","-i",a,"-o",b1,b2)
preprocess.uses(a, link=Link.INPUT)
preprocess.uses(b1, link=Link.OUTPUT)
preprocess.uses(b2, link=Link.OUTPUT)
diamond.addJob(preprocess)

# Add left Findrange job
frl = Job(namespace="diamond", name="findrange", version="4.0")
c1 = File("f.c1")
frl.addArguments("-a findrange","-T60","-i",b1,"-o",c1)
frl.uses(b1, link=Link.INPUT)
frl.uses(c1, link=Link.OUTPUT)
diamond.addJob(frl)

# Add right Findrange job
frr = Job(namespace="diamond", name="findrange", version="4.0")
c2 = File("f.c2")
frr.addArguments("-a findrange","-T60","-i",b2,"-o",c2)
frr.uses(b2, link=Link.INPUT)
frr.uses(c2, link=Link.OUTPUT)
diamond.addJob(frr)

# Add Analyze job
analyze = Job(namespace="diamond", name="analyze", version="4.0")
d = File("f.d")
analyze.addArguments("-a analyze","-T60","-i",c1,c2,"-o",d)
analyze.uses(c1, link=Link.INPUT)
analyze.uses(c2, link=Link.INPUT)
analyze.uses(d, link=Link.OUTPUT, register=True)
diamond.addJob(analyze)

# Add control-flow dependencies
diamond.depends(parent=preprocess, child=frl)
diamond.depends(parent=preprocess, child=frr)
diamond.depends(parent=frl, child=analyze)
diamond.depends(parent=frr, child=analyze)

# Add notification for analyze job
analyze.invoke(When.ON_ERROR, '/home/user/bin/email -s "Analyze job failed" user@example.com')

# Add notification for workflow
diamond.invoke(When.AT_END, '/home/user/bin/email -s "Workflow finished" user@example.com')
diamond.invoke(When.ON_SUCCESS, '/home/user/bin/publish_workflow_result')

# Write the DAX to stdout
diamond.writeXML(sys.stdout)</pre>
</div>
<div class="section" title="14.2.3. The Perl DAX Generator">
<div class="titlepage"><div><div><h3 class="title">
<a name="api-perl"></a>14.2.3. The Perl DAX Generator</h3></div></div></div>
<p>The Perl API example below can be found in file
      <code class="filename">blackdiamond.pl</code> in directory <code class="filename">examples/grid-blackdiamond-perl</code>. It
      requires that you set the environment variable
      <code class="envar">PEGASUS_HOME</code> to the installation directory of Pegasus,
      and include into <code class="envar">PERL5LIB</code> the path to the directory
      <code class="filename">lib/perl</code> of the Pegasus
      installation. The actual code is longer, and will not require these
      settings, only the example below does. The Perl API is documented using
      <a class="ulink" href="http://pegasus.isi.edu/wms/docs/3.0/perl/" target="_top">perldoc</a>.
      For each of the modules you can invoke
      <span class="application">perldoc</span>, if your <code class="envar">PERL5LIB</code>
      variable is set.</p>
<p>The steps to generate a DAX from Perl are similar to the Java
      steps. However, since most methods to the classes are deeply within the
      Perl class modules, the convenience module
      <code class="code">Perl::DAX::Factory</code> makes most constructors accessible
      without you needing to type your fingers raw:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Create a new <span class="emphasis"><em>ADAG</em></span> object.</p></li>
<li class="listitem"><p>Create <span class="emphasis"><em>Job</em></span> objects as necessary.</p></li>
<li class="listitem"><p>As example, the required input file "f.a" is declared as
          <span class="emphasis"><em>File</em></span> object and linked to the
          <span class="emphasis"><em>ADAG</em></span> object.</p></li>
<li class="listitem"><p>The first job arguments and files are filled into the job, and
          the job is added to the <span class="emphasis"><em>ADAG</em></span> object.</p></li>
<li class="listitem"><p>Repeat step 4 for the remaining jobs.</p></li>
<li class="listitem"><p>Add dependencies for all jobs. You have the option of
          assigning label text to edges, though these are not used
          (yet).</p></li>
<li class="listitem"><p>To generate the DAX file, invoke the
          <span class="emphasis"><em>toXML()</em></span> method on the <span class="emphasis"><em>ADAG</em></span>
          object. The first argument is an opened file handle or
          <code class="code">IO::Handle</code> descriptor scalar to write to, the second
          the default indentation for the root element, and the third the XML
          namespace to use for elements and attributes. The latter is
          typically unused unless you want to include your output into another
          XML document.</p></li>
</ol></div>
<pre class="programlisting">#!/usr/bin/env perl
#
use 5.006;
use strict;
use IO::Handle;
use Cwd;
use File::Spec;
use File::Basename;
use Sys::Hostname;
use POSIX ();

BEGIN { $ENV{'PEGASUS_HOME'} ||= `pegasus-config --nocrlf --home` }
use lib File::Spec-&gt;catdir( $ENV{'PEGASUS_HOME'}, 'lib', 'perl' );

use Pegasus::DAX::Factory qw(:all);
use constant NS =&gt; 'diamond';

my $adag = newADAG( name =&gt; NS );
my $job1 = newJob( namespace =&gt; NS, name =&gt; 'preprocess', version =&gt; '2.0' );
my $job2 = newJob( namespace =&gt; NS, name =&gt; 'findrange', version =&gt; '2.0' );
my $job3 = newJob( namespace =&gt; NS, name =&gt; 'findrange', version =&gt; '2.0' );
my $job4 = newJob( namespace =&gt; NS, name =&gt; 'analyze', version =&gt; '2.0' );

# create "f.a" locally
my $fn = "f.a";
open( F, "&gt;$fn" ) || die "FATAL: Unable to open $fn: $!\n";
my @now = gmtime();
printf F "%04u-%02u-%02u %02u:%02u:%02uZ\n",
        $now[5]+1900, $now[4]+1, @now[3,2,1,0];
close F;

my $file = newFile( name =&gt; 'f.a' );
$file-&gt;addPFN( newPFN( url =&gt; 'file://' . Cwd::abs_path($fn),
                       site =&gt; 'local' ) );
$adag-&gt;addFile($file);

# follow this path, if the PEGASUS_HOME was determined
if ( exists $ENV{'PEGASUS_HOME'} ) {
    my $keg = File::Spec-&gt;catfile( $ENV{'PEGASUS_HOME'}, 'bin', 'keg' );
    my @os = POSIX::uname();
    # $os[2] =~ s/^(\d+(\.\d+(\.\d+)?)?).*/$1/;  ## create a proper osversion
    $os[4] =~ s/i.86/x86/;

    # add Executable instances to DAX-included TC. This will only work,
    # if we know how to access the keg executable. HOWEVER, for a grid
    # workflow, these entries are not used, and you need to
    # [1] install the work tools remotely
    # [2] create a TC with the proper entries
    if ( -x $keg ) {
        for my $j ( $job1, $job2, $job4 ) {
            my $app = newExecutable( namespace =&gt; $j-&gt;namespace,
                                     name =&gt; $j-&gt;name,
                                     version =&gt; $j-&gt;version,
                                     installed =&gt; 'false',
                                     arch =&gt; $os[4],
                                     os =&gt; lc($^O) );
            $app-&gt;addProfile( 'globus', 'maxtime', '2' );
            $app-&gt;addProfile( 'dagman', 'RETRY', '3' );
            $app-&gt;addPFN( newPFN( url =&gt; "file://$keg", site =&gt; 'local' ) );
            $adag-&gt;addExecutable($app);
        }
    }
}

my %hash = ( link =&gt; LINK_OUT, register =&gt; 'false', transfer =&gt; 'true' );
my $fna = newFilename( name =&gt; $file-&gt;name, link =&gt; LINK_IN );
my $fnb1 = newFilename( name =&gt; 'f.b1', %hash );
my $fnb2 = newFilename( name =&gt; 'f.b2', %hash );
$job1-&gt;addArgument( '-a', $job1-&gt;name, '-T60', '-i', $fna,
                    '-o', $fnb1, $fnb2 );
$adag-&gt;addJob($job1);

my $fnc1 = newFilename( name =&gt; 'f.c1', %hash );
$fnb1-&gt;link( LINK_IN );
$job2-&gt;addArgument( '-a', $job2-&gt;name, '-T60', '-i', $fnb1,
                    '-o', $fnc1 );
$adag-&gt;addJob($job2);

my $fnc2 = newFilename( name =&gt; 'f.c2', %hash );
$fnb2-&gt;link( LINK_IN );
$job3-&gt;addArgument( '-a', $job3-&gt;name, '-T60', '-i', $fnb2,
                    '-o', $fnc2 );
$adag-&gt;addJob($job3);
# a convenience function -- you can specify multiple dependents
$adag-&gt;addDependency( $job1, $job2, $job3 );

my $fnd = newFilename( name =&gt; 'f.d', %hash );
$fnc1-&gt;link( LINK_IN );
$fnc2-&gt;link( LINK_IN );
$job4-&gt;separator('');                # just to show the difference wrt default
$job4-&gt;addArgument( '-a ', $job4-&gt;name, ' -T60 -i ', $fnc1, ' ', $fnc2,
                    ' -o ', $fnd );
$adag-&gt;addJob($job4);
# this is a convenience function adding parents to a child.
# it is clearer than overloading addDependency
$adag-&gt;addInverse( $job4, $job2, $job3 );

# workflow level notification in case of failure
# refer to Pegasus::DAX::Invoke for details
my $user = $ENV{USER} || $ENV{LOGNAME} || scalar getpwuid($&gt;);
$adag-&gt;invoke( INVOKE_ON_ERROR,
               "/bin/mailx -s 'blackdiamond failed' $user" );

my $xmlns = shift;
$adag-&gt;toXML( \*STDOUT, '', $xmlns );</pre>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="api.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="api.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="ch14s03.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 14. API Reference </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 14.3. DAX Generator without a Pegasus DAX API</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
