<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-cleanup.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-config.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-cluster">
<a name="cli-pegasus-cluster"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-cluster — run a list of applications</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-cluster_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-cluster</strong></span> [<span class="strong"><strong>-d</strong></span>] [<span class="strong"><strong>-e</strong></span> | <span class="strong"><strong>-f</strong></span>] [<span class="strong"><strong>-S ec</strong></span>] [<span class="strong"><strong>-s fn</strong></span>] [<span class="strong"><strong>-R fn</strong></span>] [<span class="strong"><strong>-n nr</strong></span>] [<span class="strong"><strong>inputfile</strong></span>]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-cluster_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-cluster</strong></span> tool executes a list of application in the order
specified (assuming sequential mode.) It is generally used to do
horizontal clustering of independent application, and does not care
about any application failures. Such failures should be caught by using
<span class="strong"><strong>pegasus-kickstart</strong></span> to start application.</p>
<p>In vertical clustering mode, the <span class="emphasis"><em>hard failure</em></span> mode is encouraged,
ending execution as soon as one application fails. When running a
complex workflow through <span class="strong"><strong>pegasus-cluster</strong></span> , the order of applications
in the input file must be topologically sorted.</p>
<p>Applications are usually using <span class="strong"><strong>pegasus-kickstart</strong></span> to execute. In the
<span class="strong"><strong>pegasus-kickstart</strong></span> case, all invocations of <span class="strong"><strong>pegasus-kickstart</strong></span> except
the first should add the <span class="strong"><strong>pegasus-kickstart</strong></span> option <span class="emphasis"><em>-H</em></span> to supress
repeating the XML preamble and certain other headers of no interest when
repeated.</p>
<p><span class="strong"><strong>pegasus-cluster</strong></span> permits shell-style quoting. One level of quoting is
removed from the arguments. Please note that <span class="strong"><strong>pegasus-kickstart</strong></span> will
also remove one level of quoting.</p>
</div>
<div class="refsect1" title="Arguments">
<a name="pegasus-cluster_arguments"></a><h2>Arguments</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-d</strong></span>
</span></dt>
<dd>
This option increases the debug level. Debug message are generated on
<span class="emphasis"><em>stdout</em></span> .
 By default, debugging is minimal.
</dd>
<dt><span class="term">
<span class="strong"><strong>-e</strong></span>
</span></dt>
<dd>
This flag turns on the old behavior of <span class="strong"><strong>pegasus-cluster</strong></span> to always
run everything <span class="emphasis"><em>and</em></span> return success no matter what. The <span class="strong"><strong>-e</strong></span> flag is
mutually exclusive with the <span class="strong"><strong>-f</strong></span> flag. By default, all applications are
executed regardles of failures. Any detected application failure results
in a non-zero exit status from <span class="strong"><strong>pegasus-cluster</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>-f</strong></span>
</span></dt>
<dd>
In hard failure mode, as soon as one application fails, either through
a non-zero exit code, or by dying on a signal, further execution is
stopped.
 In parallel execution mode, one or more other applications
later in the sequence file may have been started already by the time
failure is detected. <span class="strong"><strong>Pegasus-cluster</strong></span> will wait for the completion of
these applications, but not start new ones. The <span class="strong"><strong>-f</strong></span> flag is mutually
exclusive with the <span class="strong"><strong>-e</strong></span> flag.
 By default, all applications are executed
regardless of failures. Any detected application failure results in a
non-zero exit status from <span class="strong"><strong>pegasus-cluster</strong></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>-h</strong></span>
</span></dt>
<dd>
This option prints the help message and exits the program.
</dd>
<dt><span class="term">
<span class="strong"><strong>-s fn</strong></span>
</span></dt>
<dd>
This option will send protocol message (for Mei) to the specified
file.
 By default, all message are written to <span class="emphasis"><em>stdout</em></span> .
</dd>
<dt><span class="term">
<span class="strong"><strong>-R fn</strong></span>
</span></dt>
<dd>
The progress reporting feature, if turned on, will write one event
record whenever an application is started, and one event record whenever
an application finished. This is to enable tracking of jobs in progress.
 By default, track logs are not written, unless the environment
variable <span class="emphasis"><em>SEQEXEC_PROGRESS_REPORT</em></span> is set. If set, progress reports
are appended to the file pointed to by the environment variable.
</dd>
<dt><span class="term">
<span class="strong"><strong>-S ec</strong></span>
</span></dt>
<dd>
This option is a multi-option, which may be used multiple times. For
each given non-zero exit-code of an application, mark it as a form
of success. In <span class="strong"><strong>-f</strong></span> mode, this means that <span class="strong"><strong>pegasus-cluster</strong></span>
will not fail when seeing this exit code from any application it runs.
 By default, all non-zero exit code constitute failure.
</dd>
<dt><span class="term">
<span class="strong"><strong>-n nr</strong></span>
</span></dt>
<dd>
This option determines the amount of parallel execution. Typically,
parallel execution is only recommended on multi-core systems, and
must be deployed rather carefully, i.e. only completely independent
jobs across of whole <span class="emphasis"><em>inputfile</em></span> should ever be attempted to be run
in parallel.
 The argument <span class="strong"><strong>nr</strong></span> is the number of parallel jobs that should be
used. In addition to a non-negative integer, the word <span class="emphasis"><em>auto</em></span>
is also understood. When <span class="emphasis"><em>auto</em></span> is specified, <span class="strong"><strong>pegasus-cluster</strong></span>
will attempt to automatically determine the number of cores
available in the system.
 Strictly sequential execution, as if <span class="emphasis"><em>nr</em></span> was 1, is the default.
If the environment variable <span class="emphasis"><em>SEQEXEC_CPUS</em></span> is set, it will determine
the default number of CPUs.
</dd>
<dt><span class="term">
<span class="strong"><strong>inputfile</strong></span>
</span></dt>
<dd>
The input file specifies a list of application to run, one per line.
Comments and empty lines are permitted. The comment character is the
octothorpe (#), and extends to the end of line.
 By default, <span class="strong"><strong>pegasus-cluster</strong></span> uses <span class="emphasis"><em>stdin</em></span> to read the list of
applications to execute.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Return Value">
<a name="pegasus-cluster_return_value"></a><h2>Return Value</h2>
<p>The <span class="strong"><strong>pegasus-cluster</strong></span> tool returns 1, if an illegal option was used.
It returns 2, if the status file from option <span class="strong"><strong>-s</strong></span> cannot be opened. It
returns 3, if the input file cannot be opened. It does <span class="emphasis"><em>not</em></span> return
any failure for failed applications in old-exit <span class="strong"><strong>-e</strong></span> mode. In <span class="emphasis"><em>default</em></span>
and hard failure <span class="strong"><strong>-f</strong></span> mode, it will return 5 for true failure. The
determination of failure is modified by the <span class="strong"><strong>-S</strong></span> option.</p>
<p>All other internal errors being absent, <span class="strong"><strong>pegasus-cluster</strong></span> will always
return 0 when run without <span class="strong"><strong>-f</strong></span> . Unlike shell, it will <span class="emphasis"><em>not</em></span> return
the last application’s exit code. In <span class="emphasis"><em>default</em></span> mode, it will return 5,
if any application failed. Unlike shell, it will <span class="emphasis"><em>not</em></span> return the last
application’s exit code. However, it will execute all applications. The
determination of failure is modified by the <span class="strong"><strong>-S</strong></span> flag. In <span class="strong"><strong>-f</strong></span> mode,
*pegasus-cluster returns either 0 if all main sequence applications
succeeded, or 5 if one failed; or more than one in parallel execution
mode. It will run only as long as applications were successful. As
before, the *-S flag determines what constitutes a failure.</p>
<p>The <span class="strong"><strong>pegasus-cluster</strong></span> application will also create a small summary on
<span class="emphasis"><em>stdout</em></span> for each job, and one for itself, about the success and failure.
The field <span class="strong"><strong>failed</strong></span> reports any exit code that was not zero or a signal of
death termination. It does <span class="emphasis"><em>not</em></span> include non-zero exit codes that were
marked as success using the <span class="strong"><strong>-S</strong></span> option.</p>
</div>
<div class="refsect1" title="Task Summary">
<a name="pegasus-cluster_task_summary"></a><h2>Task Summary</h2>
<p>Each task executed by <span class="strong"><strong>pegasus-cluster</strong></span> generates a record bracketed
by square brackets like this (each entry is broken over two lines for
readability):</p>
<pre class="screen">[cluster-task id=1, start="2011-04-27T14:31:25.340-07:00", duration=0.521,
 status=0, line=1, pid=18543, app="/bin/usleep"]
[cluster-task id=2, start="2011-04-27T14:31:25.342-07:00", duration=0.619,
 status=0, line=2, pid=18544, app="/bin/usleep"]
[cluster-task id=3, start="2011-04-27T14:31:25.862-07:00", duration=0.619,
 status=0, line=3, pid=18549, app="/bin/usleep"]</pre>
<p>Each record is introduced by the string <span class="emphasis"><em>cluster-task</em></span>
with the following constituents, where strings are quoted:</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>id</strong></span>
</span></dt>
<dd>
This is a numerical value for main sequence application, indicating the
application’s place in the sequence file. The setup task uses the string
<span class="emphasis"><em>setup</em></span> , and the cleanup task uses the string <span class="emphasis"><em>cleanup</em></span> .
</dd>
<dt><span class="term">
<span class="strong"><strong>start</strong></span>
</span></dt>
<dd>
is the ISO 8601 time stamp, with millisecond resolution, when the
application was started. This string is quoted.
</dd>
<dt><span class="term">
<span class="strong"><strong>duration</strong></span>
</span></dt>
<dd>
is the application wall-time duration in seconds, with millisecond
resolution.
</dd>
<dt><span class="term">
<span class="strong"><strong>status</strong></span>
</span></dt>
<dd>
is the <span class="emphasis"><em>raw</em></span> exit status as returned by the <span class="emphasis"><em>wait</em></span>
family of system calls. Typically, the exit code is found in the high
byte, and the signal of death in the low byte. Typically, 0 indicates
a successful execution, and any other value a problem. However, details
could differ between systems, and exit codes are only meaningful on the
same os and architecture.
</dd>
<dt><span class="term">
<span class="strong"><strong>line</strong></span>
</span></dt>
<dd>
is the line number where the task was found in the main sequence file.
Setup- and cleanup tasks don’t have this attribute.
</dd>
<dt><span class="term">
<span class="strong"><strong>pid</strong></span>
</span></dt>
<dd>
is the process id under which the application had run.
</dd>
<dt><span class="term">
<span class="strong"><strong>app</strong></span>
</span></dt>
<dd>
is the path to the application that was started. As with the progress
record, any <span class="strong"><strong>pegasus-kickstart</strong></span> will be parsed out so that you see the true application.
</dd>
</dl></div>
</div>
<div class="refsect1" title="pegasus-cluster Summary">
<a name="pegasus-cluster_pegasus_cluster_summary"></a><h2>pegasus-cluster Summary</h2>
<p>The final summary of counts is a record bracketed by square brackets
like this (broken over two lines for readability):</p>
<pre class="screen">[cluster-summary stat="ok", lines=3, tasks=3, succeeded=3, failed=0, extra=0,
 duration=1.143, start="2011-04-27T14:31:25.338-07:00", pid=18542, app="./seqexec"]</pre>
<p>The record is introduced by the string <span class="emphasis"><em>cluster-summary</em></span>
with the following constituents:</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>stat</strong></span>
</span></dt>
<dd>
The string <span class="emphasis"><em>fail</em></span> when <span class="strong"><strong>pegasus-cluster</strong></span> would return with an exit
status of 5. Concretely, this is any failure in <span class="emphasis"><em>default</em></span> mode, and
first failure in <span class="strong"><strong>-f</strong></span> mode. Otherwise, it will always be the string <span class="emphasis"><em>ok</em></span>
, if the record is produced.
</dd>
<dt><span class="term">
<span class="strong"><strong>lines</strong></span>
</span></dt>
<dd>
is the stopping line number of the input sequence file, indicating
how far processing got. Up to the number of cores additional lines
may have been parsed in case of <span class="strong"><strong>-f</strong></span> mode.
</dd>
<dt><span class="term">
<span class="strong"><strong>tasks</strong></span>
</span></dt>
<dd>
is the number of tasks processed.
</dd>
<dt><span class="term">
<span class="strong"><strong>succeeded</strong></span>
</span></dt>
<dd>
is the number of main sequence jobs that succeeded.
</dd>
<dt><span class="term">
<span class="strong"><strong>failed</strong></span>
</span></dt>
<dd>
is the number of main sequence jobs that failed. The failure condition
depends on the <span class="strong"><strong>-S</strong></span> settings, too.
</dd>
<dt><span class="term">
<span class="strong"><strong>extra</strong></span>
</span></dt>
<dd>
is 0, 1 or 2, depending on the existence of setup- and cleanup jobs.
</dd>
<dt><span class="term">
<span class="strong"><strong>duration</strong></span>
</span></dt>
<dd>
is the duration in seconds, with millisecond resolution, how long
*pegasus-cluster
ran.
</dd>
<dt><span class="term">
<span class="strong"><strong>start</strong></span>
</span></dt>
<dd>
is the start time of <span class="strong"><strong>pegasus-cluster</strong></span> as ISO 8601 time stamp.
</dd>
</dl></div>
</div>
<div class="refsect1" title="See Also">
<a name="pegasus-cluster_see_also"></a><h2>See Also</h2>
<p><span class="strong"><strong>pegasus-kickstart(1)</strong></span></p>
</div>
<div class="refsect1" title="Caveats">
<a name="pegasus-cluster_caveats"></a><h2>Caveats</h2>
<p>The <span class="strong"><strong>-S</strong></span> option sets success codes globally. It is not possible to
activate success codes only for one specific application, and doing
so would break the shell compatibility. Due to the global nature, use
success codes sparingly as last resort emergency handler. In better
plannable environments, you should use an application wrapper instead.</p>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-cluster_example"></a><h2>Example</h2>
<p>The following shows an example input file to <span class="strong"><strong>pegasus-cluster</strong></span> making
use of <span class="strong"><strong>pegasus-kickstart</strong></span> to track applications.</p>
<pre class="screen">#
# mkdir
/path/to/pegasus-kickstart -R HPC -n mkdir /bin/mkdir -m 2755 -p split-corpus split-ne-corpus
#
# drop-dian
/path/to/pegasus-kickstart -H -R HPC -n drop-dian -o '^f-new.plain' /path/to/drop-dian /path/to/f-tok.plain /path/to/f-tok.NE
#
# split-corpus
/path/to/pegasus-kickstart -H -R HPC -n split-corpus /path/to/split-seq-new.pl 23 f-new.plain split-corpus/corpus.
#
# split-corpus
/path/to/pegasus-kickstart -H -R HPC -n split-corpus /path/to/split-seq-new.pl 23 /path/to/f-tok.NE split-ne-corpus/corpus.</pre>
</div>
<div class="refsect1" title="Environment Variables">
<a name="pegasus-cluster_environment_variables"></a><h2>Environment Variables</h2>
<p>A number of environment variables permits to influence the behavior of
<span class="strong"><strong>pegasus-cluster</strong></span> during run-time.</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>SEQEXEC_PROGRESS_REPORT</strong></span>
</span></dt>
<dd>
If this variable is set, and points to a writable file location,
progress report records are appended to the file. While care is taken to
atomically append records to the log file, in case concurrent instances
of <span class="strong"><strong>pegasus-cluster</strong></span> are running, broken Linux NFS may still garble some
content.
</dd>
<dt><span class="term">
<span class="strong"><strong>SEQEXEC_CPUS</strong></span>
</span></dt>
<dd>
If this variable is set to a non-negative integer, that many CPUs are
attempted to be used. The special value <span class="emphasis"><em>auto</em></span> permits to auto-detect
the number of CPUs available to <span class="strong"><strong>pegasus-cluster</strong></span> on the system.
</dd>
<dt><span class="term">
<span class="strong"><strong>SEQEXEC_SETUP</strong></span>
</span></dt>
<dd>
If this variable is set, and contains a single fully-qualified path
to an executable and arguments, this executable will be run before
any jobs are started. The exit code of this setup job will have no
effect upon the main job sequence. Success or failure will not be
counted towards the summary.
</dd>
<dt><span class="term">
<span class="strong"><strong>SEQEXEC_CLEANUP</strong></span>
</span></dt>
<dd>
If this variable is set, and contains a single fully-qualified path
to an executable and arguments, this executable will be before
<span class="strong"><strong>pegasus-cluster</strong></span> quits. Failure of any previous job will have no effect
on the ability to run this job. The exit code of the cleanup job will
have no effect on the overall success or failure state. Success or
failure will not be counted towards the summary.
</dd>
</dl></div>
</div>
<div class="refsect1" title="History">
<a name="pegasus-cluster_history"></a><h2>History</h2>
<p>As you may have noticed, <span class="strong"><strong>pegasus-cluster</strong></span> had the name <span class="strong"><strong>seqexec</strong></span>
in previous incantations. We are slowly moving to the new name to avoid
clashes in a larger OS installation setting. However, there is no
pertinent need to change the internal name, too, as no name clashes are
expected.</p>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-cluster_authors"></a><h2>Authors</h2>
<p>Jens-S. Vöckler &lt;voeckler at isi dot edu&gt;</p>
<p>Pegasus
<span class="strong"><strong>http://pegasus.isi.edu/</strong></span></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-cleanup.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-config.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-cleanup </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-config</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
