<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="site.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="running_workflows.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="4.4. Executable Discovery (Transformation Catalog)">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="transformation"></a>4.4. Executable Discovery (Transformation Catalog)</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="transformation.php#tc-Text">4.4.1. MultiLine Text based TC (Text)</a></span></dt>
<dt><span class="section"><a href="transformation.php#tc-File">4.4.2. Singleline Text based TC (File)</a></span></dt>
<dt><span class="section"><a href="transformation.php#tc-Database">4.4.3. Database TC (Database)</a></span></dt>
<dt><span class="section"><a href="transformation.php#pegasus-tc-client">4.4.4. TC Client pegasus-tc-client</a></span></dt>
<dt><span class="section"><a href="transformation.php#idp6020304">4.4.5. TC Converter Client pegasus-tc-converter</a></span></dt>
</dl></div>
<p>The Transformation Catalog maps logical transformations to physical
    executables on the system. It also provides additional information about
    the transformation as to what system they are compiled for, what profiles
    or environment variables need to be set when the transformation is invoked
    etc.</p>
<p>Pegasus currently supports two implementations of the Transformation
    Catalog</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>Text: </strong></span>A multiline text based
        Transformation Catalog (DEFAULT)</p></li>
<li class="listitem"><p><span class="bold"><strong>File:</strong></span> A simple multi column
        text based Transformation Catalog</p></li>
<li class="listitem"><p><span class="bold"><strong>Database:</strong></span> A database backend
        (MySQL or PostgreSQL) via JDB</p></li>
</ol></div>
<p>In this guide we will look at the format of the Multiline Text based
    TC.</p>
<div class="section" title="4.4.1. MultiLine Text based TC (Text)">
<div class="titlepage"><div><div><h3 class="title">
<a name="tc-Text"></a>4.4.1. MultiLine Text based TC (Text)</h3></div></div></div>
<p>The multile line text based TC is the new default TC in Pegasus.
      This format allows you to define the transformations</p>
<p>The file is read and cached in memory. Any modifications, as
      adding or deleting, causes an update of the memory and hence to the file
      underneath. All queries are done against the memory representation. The
      file sample.tc.text in the etc directory contains an example</p>
<pre class="programlisting">tr example::keg:1.0 { 

#specify profiles that apply for all the sites for the transformation 
#in each site entry the profile can be overriden 

  profile env "APP_HOME" "/tmp/myscratch"
  profile env "JAVA_HOME" "/opt/java/1.6"

  site isi {
    profile env "HELLo" "WORLD"
    profile condor "FOO" "bar"
    profile env "JAVA_HOME" "/bin/java.1.6"
    pfn "/path/to/keg"
    arch "x86"
    os "linux"
    osrelease "fc"
    osversion "4"
    type "INSTALLED"
  }

  site wind {
    profile env "CPATH" "/usr/cpath"
    profile condor "universe" "condor"
    pfn "file:///path/to/keg"
    arch "x86"
    os "linux"
    osrelease "fc"
    osversion "4"
    type "STAGEABLE"
  }
}</pre>
<p>The entries in this catalog have the following meaning</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>tr</strong></span> tr - A transformation
            identifier. (Normally a Namespace::Name:Version.. The Namespace
            and Version are optional.)</p></li>
<li class="listitem"><p><span class="bold"><strong>pfn</strong></span> - URL or file path for
            the location of the executable. The pfn is a file path if the
            transformation is of type INSTALLED and generally a url (file:///
            or http:// or gridftp://) if of type STAGEABLE</p></li>
<li class="listitem"><p><span class="bold"><strong>site</strong></span> - The site identifier
            for the site where the transformation is available</p></li>
<li class="listitem"><p><span class="bold"><strong>type</strong></span> - The type of
            transformation. Whether it is Iinstalled ("INSTALLED") on the
            remote site or is availabe to stage ("STAGEABLE").</p></li>
<li class="listitem">
<p><span class="bold"><strong>arch, os, osrelease,
            osversion</strong></span> - The arch/os/osrelease/osversion of the
            transformation. osrelease and osversion are optional.</p>
<p>ARCH can have one of the following values x86, x86_64,
            sparcv7, sparcv9, ppc, aix. The default value for arch is
            x86</p>
<p>OS can have one of the following values linux,sunos,macosx.
            The default value for OS if none specified is linux</p>
</li>
<li class="listitem"><p><span class="bold"><strong>Profiles</strong></span> - One or many
            profiles can be attached to a transformation for all sites or to a
            transformation on a particular site.</p></li>
</ol></div>
<p>To use this format of the Transformation Catalog you need to set
      the following properties</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation=Text</strong></span></p></li>
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.file=<em class="replaceable"><code>&lt;path
            to the transformation catalog
            file&gt;</code></em></strong></span></p></li>
</ol></div>
</div>
<div class="section" title="4.4.2. Singleline Text based TC (File)">
<div class="titlepage"><div><div><h3 class="title">
<a name="tc-File"></a>4.4.2. Singleline Text based TC (File)</h3></div></div></div>
<div class="warning" title="Warning" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Warning</h3>
<p>This format is now deprecated in favor of the multiline TC. If
        you are still using the single line TC you should convert it to
        multiline using the tc-converter client.</p>
</div>
<p>The format of the this TC is as follows.</p>
<pre class="programlisting">#site  logicaltr   physicaltr   type  system  profiles(NS::KEY="VALUE")

site1 sys::date:1.0 /usr/bin/date  INSTALLED INTEL32::LINUX:FC4.2:3.6 ENV::PATH="/usr/bin";PEGASUS_HOME="/usr/local/pegasus"</pre>
<p>The system and profile entries are optional and will use default
      values if not specified. The entries in the file format have the
      following meaning:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>site</strong></span> - A site
          identifier.</p></li>
<li class="listitem"><p><span class="bold"><strong>logicaltr</strong></span> - The logical
          transformation name. The format is NAMESPACE::NAME:VERSION where
          NAMESPACE and NAME are optional.</p></li>
<li class="listitem">
<p><span class="bold"><strong>physicaltr</strong></span> - The physical
          transformation path or URL.</p>
<p>If the transformation type is INSTALLED then it needs to be an
          absolute path to the executable. If the type is STAGEABLE then the
          path needs to be a HTTP, FTP or gsiftp URL</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>type</strong></span> - The type of
          transformation. Can have on of two values</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p><span class="bold"><strong>INSTALLED</strong></span>: This means
              that the transformation is installed on the remote site</p></li>
<li class="listitem"><p><span class="bold"><strong>STAGEABLE</strong></span>: This means
              that the transformation is available as a static binary and can
              be staged to a remote site.</p></li>
</ul></div>
</li>
<li class="listitem">
<p><span class="bold"><strong>system</strong></span> - The system for which
          the transformation is compiled.</p>
<p>The formation of the sytem is ARCH::OS:OSVERSION:GLIBC where
          the GLIBC and OS VERSION are optional. ARCH can have one of the
          following values INTEL32, INTEL64, SPARCV7, SPARCV9, AIX, AMD64. OS
          can have one of the following values LINUX,SUNOS. The default value
          for system if none specified is INTEL32::LINUX</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>Profiles</strong></span> - The profiles
          associated with the transformation. For indepth information about
          profiles and their priorities read the Profile Guide.</p>
<p>The format for profiles is NS::KEY="VALUE" where NS is the
          namespace of the profile e.g. Pegasus,condor,DAGMan,env,globus. The
          key and value can be any strings. Remember to quote the value with
          double quotes. If you need to specify several profiles you can do it
          in several ways</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<p>NS1::KEY1="VALUE1",KEY2="VALUE2";NS2::KEY3="VALUE3",KEY4="VALUE4"</p>
<p>This is the most optimized form. Multiple key values for
              the same namespace are separated by a comma "," and different
              namespaces are separated by a semicolon ";"</p>
</li>
<li class="listitem">
<p>NS1::KEY1="VALUE1";NS1::KEY2="VALUE2";NS2::KEY3="VALUE3";NS2::KEY4="VALUE4"</p>
<p>You can also just repeat the triple of NS::KEY="VALUE"
              separated by semicolons for a simple format;</p>
</li>
</ul></div>
</li>
</ol></div>
<p>To use this format of the Transformation Catalog you need to set
      the following properties</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation=File</strong></span></p></li>
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.file=<em class="replaceable"><code>&lt;path
            to the transformation catalog
            file&gt;</code></em></strong></span></p></li>
</ol></div>
</div>
<div class="section" title="4.4.3. Database TC (Database)">
<div class="titlepage"><div><div><h3 class="title">
<a name="tc-Database"></a>4.4.3. Database TC (Database)</h3></div></div></div>
<p>The database TC alows you to use a relational database. To use the
      database TC you need to have installed a MySQL or PostgreSQL server. The
      schema for the database is available in $PEGASUS_HOME/sql directory. You
      will have to install the schema into either PostgreSQL or MySQL by
      running the appropriate commands to load the two scheams <span class="bold"><strong>create-XX-init.sql</strong></span> and <span class="bold"><strong>create-XX-tc.sql</strong></span> where XX is either <span class="bold"><strong>my</strong></span> (for MySQL) or <span class="bold"><strong>pg</strong></span> (for PostgreSQL)</p>
<p>To use the Database TC you need to set the following
      properties</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.db.driver=MySQL |
            Postgres</strong></span></p></li>
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.db.url=<em class="replaceable"><code>&lt;jdbc
            url to the databse&gt;</code></em></strong></span></p></li>
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.db.user=<em class="replaceable"><code>&lt;database
            user&gt;</code></em></strong></span></p></li>
<li class="listitem"><p><span class="bold"><strong>pegasus.catalog.transformation.db.password=<em class="replaceable"><code>&lt;database
            password&gt;</code></em></strong></span></p></li>
</ol></div>
</div>
<div class="section" title="4.4.4. TC Client pegasus-tc-client">
<div class="titlepage"><div><div><h3 class="title">
<a name="pegasus-tc-client"></a>4.4.4. TC Client pegasus-tc-client</h3></div></div></div>
<p>We need to map our declared transformations (preprocess,
      findranage, and analyze) from the example DAX above to a simple "mock
      application" name "keg" ("canonical example for the grid") which reads
      input files designated by arguments, writes them back onto output files,
      and produces on STDOUT a summary of where and when it was run. Keg ships
      with Pegasus in the bin directory. Run keg on the command line to see
      how it works.</p>
<pre class="screen"><span class="command"><strong>$ keg -o /dev/fd/1</strong></span>
<code class="computeroutput">
Timestamp Today: 20040624T054607-05:00 (1088073967.418;0.022)
Applicationname: keg @ 10.10.0.11 (VPN)
Current Workdir: /home/unique-name
Systemenvironm.: i686-Linux 2.4.18-3
Processor Info.: 1 x Pentium III (Coppermine) @ 797.425
Output Filename: /dev/fd/1</code></pre>
<p>Now we need to map all 3 transformations onto the "keg"
      executable. We place these mappings in our File transformation catalog
      for site clus1.</p>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>In earlier version of Pegasus users had to define entries for
        Pegasus executables such as transfer, replica client, dirmanager, etc
        on each site as well as site "local". This is no longer required.
        Pegasus versions 2.0 and later automatically pick up the paths for
        these binaries from the environment profile PEGASUS_HOME set in the
        site catalog for each site.</p>
<p>A single entry needs to be on one line. The above example is
        just formatted for convenience.</p>
</div>
<p>Alternatively you can also use the pegasus-tc-client to add
      entries to any implementation of the transformation catalog. The
      following example shows the addiition the last entry in the File based
      transformation catalog.</p>
<pre class="screen"><span class="command"><strong>$ pegasus-tc-client -Dpegasus.catalog.transformation=Text \
-Dpegasus.catalog.transformation.file=$HOME/tc -a -r clus1 -l black::analyze:1.0 \
-p gsiftp://clus1.com/opt/nfs/vdt/pegasus/bin/keg  -t STAGEABLE -s INTEL32::LINUX \
-e ENV::KEY3="VALUE3"</strong></span><code class="computeroutput">

2007.07.11 16:12:03.712 PDT: [INFO] Added tc entry sucessfully</code></pre>
<p>To verify if the entry was correctly added to the transformation
      catalog you can use the pegasus-tc-client to query.</p>
<pre class="screen"><span class="command"><strong>$ pegasus-tc-client -Dpegasus.catalog.transformation=File \
-Dpegasus.catalog.transformation.file=$HOME/tc -q -P -l black::analyze:1.0</strong></span>

<code class="computeroutput">#RESID     LTX          PFN                  TYPE              SYSINFO

clus1    black::analyze:1.0    gsiftp://clus1.com/opt/nfs/vdt/pegasus/bin/keg
                STAGEABLE    INTEL32::LINUX</code></pre>
<p></p>
</div>
<div class="section" title="4.4.5. TC Converter Client pegasus-tc-converter">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp6020304"></a>4.4.5. TC Converter Client pegasus-tc-converter</h3></div></div></div>
<p>Pegasus 3.0 by default now parses a file based multiline textual
      format of a Transformation Catalog. The new Text format is explained in
      detail in the chapter on Catalogs.</p>
<p>Pegasus 3.0 comes with a pegasus-tc-converter that will convert
      users old transformation catalog ( File ) to the Text format. Sample
      usage is given below.</p>
<pre class="programlisting"><span class="bold"><strong>$ pegasus-tc-converter -i sample.tc.data -I File -o sample.tc.text -O Text
</strong></span>
2010.11.22 12:53:16.661 PST:   Successfully converted Transformation Catalog from File to Text 
2010.11.22 12:53:16.666 PST:   The output transfomation catalog is in file  /lfs1/software/install/pegasus/pegasus-3.0.0cvs/etc/sample.tc.text 
</pre>
<p>To use the converted transformation catalog, in the properties do
      the following:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>unset pegasus.catalog.transformation or set
          pegasus.catalog.transformation to Text</p></li>
<li class="listitem"><p>point pegasus.catalog.transformation.file to the converted
          transformation catalog</p></li>
</ol></div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="site.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="creating_workflows.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="running_workflows.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">4.3. Resource Discovery (Site Catalog) </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 5. Running Workflows</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
