<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="submit_directory.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="kickstart_xml_record.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="13.2. Condor DAGMan File">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="condor_dagman_file"></a>13.2. Condor DAGMan File</h2></div></div></div>
<div class="toc"><dl><dt><span class="section"><a href="condor_dagman_file.php#idp21117008">13.2.1. Sample Condor DAG File</a></span></dt></dl></div>
<p>The Condor DAGMan file ( .dag ) is the input to Condor DAGMan ( the
    workflow executor used by Pegasus ) .</p>
<p>Pegasus generated .dag file usually contains the following
    information for each job:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>The job submit file for each job in the DAG.</p></li>
<li class="listitem"><p>The post script that is to be invoked when a job completes. This
        is usually found in <span class="bold"><strong>$PEGASUS_HOME/bin/exitpost</strong></span> and parses the
        kickstart record in the job's .out file and determines the
        exitcode.</p></li>
<li class="listitem"><p>JOB RETRY - the number of times the job is to be retried in case
        of failure. In case of Pegasus, job postscript exits with a non zero
        exitcode if it determines a failure occurred.</p></li>
<li class="listitem"><p>The pre script to be invoked before running a job. This is
        usually for the dax jobs in the DAX. The pre script is pegasus-plan
        invocation for the subdax.</p></li>
</ol></div>
<p>In the last section of the DAG file the relations between the jobs (
    that identify the underlying DAG structure ) are highlighted.</p>
<div class="section" title="13.2.1. Sample Condor DAG File">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp21117008"></a>13.2.1. Sample Condor DAG File</h3></div></div></div>
<pre class="programlisting">#####################################################################
# PEGASUS WMS GENERATED DAG FILE
# DAG blackdiamond
# Index = 0, Count = 1
######################################################################

<span class="bold"><strong>JOB</strong></span> create_dir_blackdiamond_0_isi_viz create_dir_blackdiamond_0_isi_viz.sub
<span class="bold"><strong>SCRIPT POST</strong></span> create_dir_blackdiamond_0_isi_viz /pegasus/bin/pegasus-exitcode   \
                                   /submit-dir/create_dir_blackdiamond_0_isi_viz.out
<span class="bold"><strong>RETRY</strong></span> create_dir_blackdiamond_0_isi_viz 3

JOB create_dir_blackdiamond_0_local create_dir_blackdiamond_0_local.sub
SCRIPT POST create_dir_blackdiamond_0_local /pegasus/bin/pegasus-exitcode   
                                   /submit-dir/create_dir_blackdiamond_0_local.out

JOB pegasus_concat_blackdiamond_0 pegasus_concat_blackdiamond_0.sub

JOB stage_in_local_isi_viz_0 stage_in_local_isi_viz_0.sub
SCRIPT POST stage_in_local_isi_viz_0 /pegasus/bin/pegasus-exitcode   \
                                     /submit-dir/stage_in_local_isi_viz_0.out

JOB chmod_preprocess_ID000001_0 chmod_preprocess_ID000001_0.sub
SCRIPT POST chmod_preprocess_ID000001_0 /pegasus/bin/pegasus-exitcode \
                                        /submit-dir/chmod_preprocess_ID000001_0.out

JOB preprocess_ID000001 preprocess_ID000001.sub
SCRIPT POST preprocess_ID000001 /pegasus/bin/pegasus-exitcode   \
                                         /submit-dir/preprocess_ID000001.out

JOB subdax_black_ID000002 subdax_black_ID000002.sub
<span class="bold"><strong>SCRIPT PRE</strong></span> subdax_black_ID000002 /pegasus/bin/pegasus-plan  \
      -Dpegasus.user.properties=/submit-dir/./dag_1/test_ID000002/pegasus.3862379342822189446.properties\
      -Dpegasus.log.*=/submit-dir/subdax_black_ID000002.pre.log \
      -Dpegasus.dir.exec=app_domain/app -Dpegasus.dir.storage=duncan -Xmx1024 -Xms512\
      --dir /pegasus-features/dax-3.2/dags \
      --relative-dir user/pegasus/blackdiamond/run0005/user/pegasus/blackdiamond/run0005/./dag_1 \
      --relative-submit-dir user/pegasus/blackdiamond/run0005/./dag_1/test_ID000002\
      --basename black --sites dax_site \
      --output local --force  --nocleanup  \
      --verbose  --verbose  --verbose  --verbose  --verbose  --verbose  --verbose \
      --verbose  --monitor  --deferred  --group pegasus --rescue 0 \
      --dax /submit-dir/./dag_1/test_ID000002/dax/blackdiamond_dax.xml 

JOB stage_out_local_isi_viz_0_0 stage_out_local_isi_viz_0_0.sub
SCRIPT POST stage_out_local_isi_viz_0_0 /pegasus/bin/pegasus-exitcode   /submit-dir/stage_out_local_isi_viz_0_0.out

<span class="bold"><strong>SUBDAG EXTERNAL</strong></span> subdag_black_ID000003 /Users/user/Pegasus/work/dax-3.2/black.dag DIR /duncan/test

JOB clean_up_stage_out_local_isi_viz_0_0 clean_up_stage_out_local_isi_viz_0_0.sub
SCRIPT POST clean_up_stage_out_local_isi_viz_0_0 /lfs1/devel/Pegasus/pegasus/bin/pegasus-exitcode  \
                                          /submit-dir/clean_up_stage_out_local_isi_viz_0_0.out

JOB clean_up_preprocess_ID000001 clean_up_preprocess_ID000001.sub
SCRIPT POST clean_up_preprocess_ID000001 /lfs1/devel/Pegasus/pegasus/bin/pegasus-exitcode  \
                                     /submit-dir/clean_up_preprocess_ID000001.out
<span class="bold"><strong>
PARENT create_dir_blackdiamond_0_isi_viz CHILD pegasus_concat_blackdiamond_0</strong></span>
PARENT create_dir_blackdiamond_0_local CHILD pegasus_concat_blackdiamond_0
PARENT stage_out_local_isi_viz_0_0 CHILD clean_up_stage_out_local_isi_viz_0_0
PARENT stage_out_local_isi_viz_0_0 CHILD clean_up_preprocess_ID000001
PARENT preprocess_ID000001 CHILD subdax_black_ID000002
PARENT preprocess_ID000001 CHILD stage_out_local_isi_viz_0_0
PARENT subdax_black_ID000002 CHILD subdag_black_ID000003
PARENT stage_in_local_isi_viz_0 CHILD chmod_preprocess_ID000001_0
PARENT stage_in_local_isi_viz_0 CHILD preprocess_ID000001
PARENT chmod_preprocess_ID000001_0 CHILD preprocess_ID000001
PARENT pegasus_concat_blackdiamond_0 CHILD stage_in_local_isi_viz_0
######################################################################
# End of DAG
######################################################################
</pre>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="submit_directory.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="submit_directory.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="kickstart_xml_record.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 13. Submit Directory Details </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 13.3. Kickstart XML Record</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
