<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="creamce_submission.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="bosco_submission.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="7.6. Local Cluster Using Glite">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="glite"></a>7.6. Local Cluster Using Glite</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="glite.php#glite_pbs">7.6.1. Setting PBS specific parameters for the jobs</a></span></dt>
<dt><span class="section"><a href="glite.php#glite_sge">7.6.2. Setting SGE specific parameters for the jobs</a></span></dt>
<dt><span class="section"><a href="glite.php#idp8714208">7.6.3. Specifying directory for the jobs</a></span></dt>
</dl></div>
<p>This section describes the various changes required in the site
    catalog for Pegasus to generate an executable workflow that uses gLite
    blahp to directly submit to PBS on the local machine. This mode of
    submission should only be used when the HTCondor on the submit host can
    directly talk to scheduler running on the cluster.</p>
<p>For the job submissions to work from HTCondor to underlying PBS
    correctly, you need to use the pbs_local_attributes.sh file distributed
    with the Pegasus distribution in in the share/pegasus/htcondor/glite
    directory. You need to copy this file into the bin directory of the glite
    installation as part of the HTCondor installation on the submit node. The
    HTCondor glite installation can be determined by running the command
    HTCondor_config_val GLITE_LOCATION. The Pegasus team currently only
    provides a local attributes file for PBS.</p>
<pre class="programlisting">$ HTCondor_config_val GLITE_LOCATION
/usr/libexec/condor/glite

$ ls  /usr/libexec/condor/glite/bin/pbs_local_submit_attributes.sh
-rwxrwxr-x 1 vahi isi-ar 1.8K May 29 17:34 /usr/libexec/condor/glite/bin/pbs_local_submit_attributes.sh</pre>
<p>It is recommended that the cluster that gLite talks to is designated
    as a separate compute site in the Pegasus site catalog. To tag a site as a
    gLite site the following two profiles need to be specified for the site in
    the site catalog.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus</strong></span> profile <span class="bold"><strong>style</strong></span> with value set to <span class="bold"><strong>glite</strong></span>.</p></li>
<li class="listitem"><p><span class="bold"><strong>condor</strong></span> profile <span class="bold"><strong>grid_resource</strong></span> with value set to <span class="bold"><strong>pbs|sge</strong></span></p></li>
</ol></div>
<p>Additonally, if you are planning to run workflows on the cluster in
    the shared filesystem environment , you need to set</p>
<div class="orderedlist"><ol class="orderedlist" type="1"><li class="listitem"><p><span class="bold"><strong>pegasus</strong></span> profile <span class="bold"><strong>change.dir</strong></span> with value set to <span class="bold"><strong>true</strong></span>.</p></li></ol></div>
<p>An example site catalog entry for a glite site looks as follows in
    the site catalog</p>
<pre class="programlisting">
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;
    
    &lt;site  handle="local" arch="x86" os="LINUX"&gt;
        &lt;directory type="shared-scratch" path="/lfs/shared-scratch/glite-sharedfs-example/work"&gt;
            &lt;file-server operation="all" url="file:///lfs/local-scratch/glite-sharedfs-example/work"/&gt;
        &lt;/directory&gt;
        &lt;directory type="local-storage" path="/shared-scratch//glite-sharedfs-example/outputs"&gt;
            &lt;file-server operation="all" url="file:///lfs/local-scratch/glite-sharedfs-example/outputs"/&gt;
        &lt;/directory&gt;
    &lt;/site&gt;

    &lt;site  handle="local-pbs" arch="x86" os="LINUX"&gt;
        
        &lt;!-- the following is a shared directory shared amongst all the nodes in the cluster --&gt;
        &lt;directory type="shared-scratch" path="/lfs/glite-sharedfs-example/local-pbs/shared-scratch"&gt;
            &lt;file-server operation="all" url="file:///lfs/glite-sharedfs-example/local-pbs/shared-scratch"/&gt;
        &lt;/directory&gt;

        &lt;profile namespace="env" key="PEGASUS_HOME"&gt;/lfs/software/pegasus/pegasus-4.2.0&lt;/profile&gt;

        &lt;profile namespace="pegasus" key="style" &gt;glite&lt;/profile&gt;

        &lt;!-- change.dir needs to be set, if you are running workflows in shared filesystem setup --&gt;
        &lt;profile namespace="pegasus" key="change.dir"&gt;true&lt;/profile&gt;

        &lt;profile namespace="condor" key="grid_resource"&gt;pbs&lt;/profile&gt;
        &lt;profile namespace="condor" key="batch_queue"&gt;batch&lt;/profile&gt;
        &lt;profile namespace="globus" key="maxwalltime"&gt;30000&lt;/profile&gt;
    &lt;/site&gt;


&lt;/sitecatalog&gt;

</pre>
<div class="tip" title="Tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>Starting 4.2.1 , in the examples directory you can find a glite
      shared filesystem example that you can use to test out this
      configuration</p>
</div>
<div class="section" title="7.6.1. Setting PBS specific parameters for the jobs">
<div class="titlepage"><div><div><h3 class="title">
<a name="glite_pbs"></a>7.6.1. Setting PBS specific parameters for the jobs</h3></div></div></div>
<p>In order to pass resource requirements of the job to local PBS,
      Pegasus generates a +remote_cerequirements classad in the job's HTCondor
      submit file. The remote CE requirements are constructed from the
      following profiles associated with the job. The profiles for a job are
      derived from various sources</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>transformation catalog</p></li>
<li class="listitem"><p>site catalog</p></li>
<li class="listitem"><p>DAX</p></li>
<li class="listitem"><p>user properties</p></li>
</ol></div>
<p>The following globus profiles if associated with the job are
      picked up and translated to corresponding key in +remote_cerequirements
      picked up by pbs_local_attributes.sh file that then is translated to
      appropriate PBS parameters</p>
<div class="table">
<a name="idp6407536"></a><p class="title"><b>Table 7.1. Table mapping translation of profiles to corresponding PBS
        parameters</b></p>
<div class="table-contents"><table summary="Table mapping translation of profiles to corresponding PBS
        parameters" border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Globus Profile Key<p>(Set by User in
              Pegasus Configuration)</p>
</th>
<th align="center">KEY in +remote_cerequirements
              classad<p>(Generated by Pegasus in the Condor Submit
              File)</p>
</th>
<th>Corresponding PBS Parameter in qsub file<p>(Generated
              by pbs_local_attributes.sh)</p>
</th>
<th>Description</th>
</tr></thead>
<tbody>
<tr>
<td>queue</td>
<td>value batch_queue key in the submit file.</td>
<td>-q</td>
<td>This specifies the queue on which to run the job.</td>
</tr>
<tr>
<td>hostcount</td>
<td>NODES</td>
<td>nodes</td>
<td>This specifies the number of nodes that the job should
              use.</td>
</tr>
<tr>
<td>xcount</td>
<td>PROCS</td>
<td>ppn</td>
<td>This specifies the number of processors per node (ppn=M)
              that the job should use. PBS treats a processor core as a
              processor, so a system with eight cores per compute node can
              have ppn=8 as its maximum ppn request. If you want to explicitly
              use the Myrinet network, this value should be 8:myri . For
              infiniband, it will be 8:IB .</td>
</tr>
<tr>
<td>maxwalltime</td>
<td>WALLTIME</td>
<td>walltime</td>
<td>The maximum runtime for the job in minutes. should be an
              integer value. Pegasus converts it to hh:mm:ss format</td>
</tr>
<tr>
<td>totalmemory</td>
<td>TOTAL_MEMORY</td>
<td>mem</td>
<td>The total memory that your job requires. usually, better
              to just specify the maxmemory profile.</td>
</tr>
<tr>
<td>maxmemory</td>
<td>PER_PROCESS_MEMORY</td>
<td>pmem</td>
<td>This specifies the maximum amount of physical memory used
              by any process in the job. For example, if the job would run
              four processes and each would use up to 2 GB (gigabytes) of
              memory, then this value should be set to 2gb. The corresponding
              PBS directive would be #PBS -l pmem=2gb.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="tip" title="Tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>The above key mappings are supported in Pegasus 4.4 or
        later.</p>
</div>
<p>The following HTCondor profiles if associated with the job are
      picked up and translated to corresponding glite key</p>
<div class="orderedlist"><ol class="orderedlist" type="1"><li class="listitem"><p>priority -&gt; PRIORITY</p></li></ol></div>
<p>All the env profiles are translated to MYENV</p>
<div class="table">
<a name="idp12293216"></a><p class="title"><b>Table 7.2. Table mapping translation of Pegasus profiles to corresponding
        PBS parameters</b></p>
<div class="table-contents"><table summary="Table mapping translation of Pegasus profiles to corresponding
        PBS parameters" border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Pegasus Profile Key</th>
<th align="center">KEY in +remote_cerequirements
              classad</th>
<th>Corresponding PBS Parameter in qsub file</th>
<th>Description</th>
</tr></thead>
<tbody><tr>
<td>glite.arguments</td>
<td>EXTRA_ARGUMENTS</td>
<td>the value is passed through and added to the qsub file
              prefixed only by #PBS</td>
<td>This specifies the extra arguments that must appear in
              the local PBS generated script for a job, when running workflows
              on a local cluster with submissions through Glite. This is
              useful when you want to pass through special options to
              underlying LRMS such as PBS e.g. you can set value -l
              walltime=01:23:45 -l nodes=2 to specify your job's resource
              requirements.</td>
</tr></tbody>
</table></div>
</div>
<br class="table-break"><p>The remote_cerequirements expression is constructed on the basis
      of the profiles associated with job . An example +remote_cerequirements
      classad expression in the submit file is listed below</p>
<pre class="programlisting"><span class="bold"><strong>+remote_cerequirements = JOBNAME=="preprocessj1" &amp;&amp; PASSENV==1 &amp;&amp; WALLTIME=="01:00:00" &amp;&amp; PRIORITY==20 &amp;&amp; \
 EXTRA_ARGUMENTS=="-N testjob -l walltime=01:23:45 -l nodes=2" &amp;&amp; \
 MYENV=="CONDOR_JOBID=$(cluster).$(process),PEGASUS_DAG_JOB_ID=preprocess_j1,PEGASUS_HOME=/usr,PEGASUS_WF_UUID=aae14bc4-b2d1-4189-89ca-ccd99e30464f"</strong></span></pre>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The above translation only works if you use the
        pbs_local_attributes.sh file from the Pegasus distribution. The values
        specified for glite.arguments overrides what are constructed on basis
        of globus profiles, when the job is actually submitted.</p>
</div>
</div>
<div class="section" title="7.6.2. Setting SGE specific parameters for the jobs">
<div class="titlepage"><div><div><h3 class="title">
<a name="glite_sge"></a>7.6.2. Setting SGE specific parameters for the jobs</h3></div></div></div>
<p>In order to pass resource requirements of the job to local SGE,
      Pegasus generates a +remote_cerequirements classad in the job's HTCondor
      submit file. The remote CE requirements are constructed from the
      following profiles associated with the job. The profiles for a job are
      derived from various sources</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>transformation catalog</p></li>
<li class="listitem"><p>site catalog</p></li>
<li class="listitem"><p>DAX</p></li>
<li class="listitem"><p>user properties</p></li>
</ol></div>
<p>The following globus profiles if associated with the job are
      picked up and translated to corresponding key in +remote_cerequirements
      picked up by pbs_local_attributes.sh file that then is translated to
      appropriate PBS parameters</p>
<div class="table">
<a name="idp12311552"></a><p class="title"><b>Table 7.3. Table mapping translation of profiles to corresponding SGE
        parameters</b></p>
<div class="table-contents"><table summary="Table mapping translation of profiles to corresponding SGE
        parameters" border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Globus Profile Key<p>(Set by User in
              Pegasus Configuration)</p>
</th>
<th align="center">KEY in +remote_cerequirements
              classad<p>(Generated by Pegasus in the Condor Submit
              File)</p>
</th>
<th>Corresponding SGE Parameter in qsub file<p>(Generated
              by sge_local_submit_attributes.sh )</p>
</th>
<th>Description</th>
</tr></thead>
<tbody>
<tr>
<td>queue</td>
<td>value batch_queue key in the submit file.</td>
<td>-q</td>
<td>This specifies the queue on which to run the job.</td>
</tr>
<tr>
<td>count</td>
<td>CORES</td>
<td>value passed to the parallel environment defined to be
              used . By default, our script has parallel environment set to
              -pe ompi</td>
<td>The number of processors requried. How, the processors
              are distributed over nodes is dependant on how the parallel
              environment has been configured in SGE.</td>
</tr>
<tr>
<td>maxwalltime</td>
<td>WALLTIME</td>
<td>h_rt</td>
<td>The maximum runtime for the job in minutes. should be an
              integer value. Pegasus converts it to hh:mm:ss format. From SGE
              documentation: h_rt is hard runtime hh::min::ss (i.e. 12:00:00)
              . Requests a queue with a hard runtime in excess of the time
              specified.</td>
</tr>
<tr>
<td>maxmemory</td>
<td>PER_PROCESS_MEMORY</td>
<td>h_vmem</td>
<td>This specifies the maximum amount of physical memory used
              by any process in the job. From SGE documentation: specify the
              amount of memory required (e.g. 3G or 3500M) # (NOTE: This is
              memory per processor slot. So if you ask for 2 processors total
              memory will be 2 X hvmem_value) # hard limit of the maximum
              amount of virtual memory available on every host assigned to the
              job.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="tip" title="Tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>The above key mappings are supported in Pegasus 4.5.1 or
        later.</p>
</div>
<p>The following HTCondor profiles if associated with the job are
      picked up and translated to corresponding glite key</p>
<div class="orderedlist"><ol class="orderedlist" type="1"><li class="listitem"><p>priority -&gt; PRIORITY</p></li></ol></div>
<p>All the env profiles are translated to MYENV</p>
<div class="table">
<a name="idp8703136"></a><p class="title"><b>Table 7.4. Table mapping translation of Pegasus profiles to corresponding
        SGE parameters</b></p>
<div class="table-contents"><table summary="Table mapping translation of Pegasus profiles to corresponding
        SGE parameters" border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Pegasus Profile Key</th>
<th align="center">KEY in +remote_cerequirements
              classad</th>
<th>Corresponding SGE Parameter in qsub file</th>
<th>Description</th>
</tr></thead>
<tbody><tr>
<td>glite.arguments</td>
<td>EXTRA_ARGUMENTS</td>
<td>the value is passed through and added to the qsub file
              prefixed only by #?</td>
<td>This specifies the extra arguments that must appear in
              the local SGE generated script for a job, when running workflows
              on a local cluster with submissions through Glite. </td>
</tr></tbody>
</table></div>
</div>
<br class="table-break"><p>The remote_cerequirements expression is constructed on the basis
      of the profiles associated with job . An example +remote_cerequirements
      classad expression in the submit file is listed below</p>
<pre class="programlisting"><span class="bold"><strong>+remote_cerequirements = JOBNAME=="preprocessj1" &amp;&amp; PASSENV==1 &amp;&amp; WALLTIME=="01:00:00" &amp;&amp; PRIORITY==20 &amp;&amp; \
 EXTRA_ARGUMENTS=="-N testjob -l walltime=01:23:45 -l nodes=2" &amp;&amp; \
 MYENV=="CONDOR_JOBID=$(cluster).$(process),PEGASUS_DAG_JOB_ID=preprocess_j1,PEGASUS_HOME=/usr,PEGASUS_WF_UUID=aae14bc4-b2d1-4189-89ca-ccd99e30464f"</strong></span></pre>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The above translation only works if you use the
        sge_local_attributes.sh file from the Pegasus distribution. The values
        specified for glite.arguments overrides what are constructed on basis
        of globus profiles, when the job is actually submitted.</p>
</div>
</div>
<div class="section" title="7.6.3. Specifying directory for the jobs">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp8714208"></a>7.6.3. Specifying directory for the jobs</h3></div></div></div>
<p>gLite blahp does not follow the remote_initialdir or initialdir
      classad directives. Hence, all the jobs that have this style applied
      don't have a remote directory specified in the submit directory.
      Instead, Pegasus relies on kickstart to change to the working directory
      when the job is launched on the remote node.</p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="creamce_submission.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="bosco_submission.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.5. Remote Cluster using CREAMCE </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.7. Remote Cluster using BOSCO and SSH submissions</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
