<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="notifications_example.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="data_management.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="workflow_of_workflows"></a>8.5. Workflow of Workflows</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="workflow_of_workflows.php#idp57769408">8.5.1. Galactic Plane</a></span></dt></dl></div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp57769408"></a>8.5.1. Galactic Plane</h3></div></div></div>
<p>The <a class="ulink" href="http://en.wikipedia.org/wiki/Galactic_plane" target="_top">Galactic Plane</a>
      workflow is a workflow of many Montage workflows. The output is a set of
      tiles which can be used in software which takes the tiles and produces a
      seamless image which can be scrolled and zoomed into. As this is more of
      a production workflow than an example one, it can be a little bit harder
      to get running in your environment.</p>
<p>Highlights of the example are:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>The subworkflow DAXes are generated as jobs in the parent
          workflow - this is an example on how to make more dynamic workflows.
          For example, if you need a job in your workflow to determine the
          number of jobs in the next level, you can have the first job create
          a subworkflow with the right number of jobs.</p></li>
<li class="listitem"><p>DAGMan job categories are used to limit the number of
          concurrant jobs in certain places. This is used to limit the number
          of concurrant connections to the data find service, as well limit
          the number of concurrant subworkflows to manage disk usage on the
          compute cluster.</p></li>
<li class="listitem"><p>Job priorities are used to make sure we overlap staging and
          computation. Pegasus sets default priorities, which for most jobs
          are fine, but the priority of the data find job is set explicitly to
          a higher priority.</p></li>
<li class="listitem"><p>A specific output site is defined the the site catalog and
          specified with the --output option of subworkflows.</p></li>
</ul></div>
<p>The DAX API has support for sub workflows:</p>
<pre class="programlisting">    remote_tile_setup = Job(namespace="gp", name="remote_tile_setup", version="1.0")
    remote_tile_setup.addArguments("%05d" % (tile_id))
    remote_tile_setup.addProfile(Profile("dagman", "CATEGORY", "remote_tile_setup"))
    remote_tile_setup.uses(params, link=Link.INPUT, register=False)
    remote_tile_setup.uses(mdagtar, link=Link.OUTPUT, register=False, transfer=True)
    uberdax.addJob(remote_tile_setup)
...
    subwf = DAX("%05d.dax" % (tile_id), "ID%05d" % (tile_id))
    subwf.addArguments("-Dpegasus.schema.dax=%s/etc/dax-2.1.xsd" %(os.environ["PEGASUS_HOME"]),
                       "-Dpegasus.catalog.replica.file=%s/rc.data" % (tile_work_dir),
                       "-Dpegasus.catalog.site.file=%s/sites.xml" % (work_dir),
                       "-Dpegasus.transfer.links=true",
                       "--sites", cluster_name,
                       "--cluster", "horizontal",
                       "--basename", "tile-%05d" % (tile_id),
                       "--force",
                       "--output", output_name)
    subwf.addProfile(Profile("dagman", "CATEGORY", "subworkflow"))
    subwf.uses(subdax_file, link=Link.INPUT, register=False)
    uberdax.addDAX(subwf)

</pre>
<p></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="notifications_example.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="example_workflows.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="data_management.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">8.4. Notifications Example </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 9. Data Management</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
