<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="portable_code.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="funding_citing_usage.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="cpu_affinity_condor"></a>16.5. Slot Partitioning and CPU Affinity in Condor</h2></div></div></div>
<p>By default, Condor will evenly divide the resources in a machine (such as
        RAM, swap space and disk space) among all the CPUs, and advertise each CPU
        as its own slot with an even share of the system resources. If you want to
        have your custom configuration, you can use the following setting to define
        the maximum number of different slot types:</p>
<pre class="programlisting">
MAX_SLOT_TYPES = 2
    </pre>
<p>For each slot type, you can divide system resources unevenly among your
        CPUs. The <span class="bold"><strong>N</strong></span> in the name of the macro listed
        below must be an integer from 1 to <span class="bold"><strong>MAX_SLOT_TYPES</strong></span>
        (defined above).</p>
<pre class="programlisting">
SLOT_TYPE_1 = cpus=2, ram=50%, swap=1/4, disk=1/4
SLOT_TYPE_N = cpus=1, ram=20%, swap=1/4, disk=1/8
    </pre>
<p>Slots can also be partitioned to accommodate actual needs by accepted jobs.
        A partitionable slot is always unclaimed and dynamically splitted when jobs
        are started. Slot partitioning can be enable as follows:</p>
<pre class="programlisting">
SLOT_TYPE_1_PARTITIONABLE = True
SLOT_TYPE_N_PARTITIONABLE = True
    </pre>
<p>Condor can also bind cores to each slot through CPU affinity:</p>
<pre class="programlisting">
ENFORCE_CPU_AFFINITY = True
SLOT1_CPU_AFFINITY=0,2
SLOT2_CPU_AFFINITY=1,3
    </pre>
<p>Note that CPU numbers may vary from machines. Thus you need to verify what is
        the association for your machine. One way to accomplish this is by using the
        <span class="bold"><strong>lscpu</strong></span> command line tool. For instance, the
        output provided from this tool may look like:</p>
<pre class="programlisting">
NUMA node0 CPU(s):     0,2,4,6,8,10
NUMA node1 CPU(s):     1,3,5,7,9,11
    </pre>
<p>The following example assumes a machine with 2 sockets and 6 cores per
        socket, where even cores belong to socket 1 and odd cores to socket
        2:</p>
<pre class="programlisting">
NUM_SLOTS_TYPE_1 = 1
NUM_SLOTS_TYPE_2 = 1
SLOT_TYPE_1_PARTITIONABLE = True
SLOT_TYPE_2_PARTITIONABLE = True

SLOT_TYPE_1 = cpus=6
SLOT_TYPE_2 = cpus=6

ENFORCE_CPU_AFFINITY = True

SLOT1_CPU_AFFINITY=0,2,4,6,8,10
SLOT2_CPU_AFFINITY=1,3,5,7,9,11
    </pre>
<p>Please read the section on "Configuring The Startd for SMP Machines" in
        the Condor Administrator's Manual for full details.</p>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="portable_code.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="useful_tips.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="funding_citing_usage.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">16.4. Best Practices For Developing Portable Code </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 17. Funding, citing, and anonymous usage statistics</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
