<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="ch02s09.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="ch02s11.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="idp51033216"></a>2.10. Collecting Statistics</h2></div></div></div>
<p>The <code class="literal">pegasus-statistics</code> command can be used to
    gather statistics about the runtime of the workflow and its jobs. The
    <code class="literal">-s all</code> argument tells the program to generate all
    statistics it knows how to calculate:</p>
<pre class="programlisting">$ <span class="bold"><strong>pegasus-statistics –s all submit/tutorial/pegasus/diamond/run0001</strong></span>

#
# Pegasus Workflow Management System - http://pegasus.isi.edu
#
# Workflow summary:
#   Summary of the workflow execution. It shows total
#   tasks/jobs/sub workflows run, how many succeeded/failed etc.
#   In case of hierarchical workflow the calculation shows the
#   statistics across all the sub workflows.It shows the following
#   statistics about tasks, jobs and sub workflows.
#     * Succeeded - total count of succeeded tasks/jobs/sub workflows.
#     * Failed - total count of failed tasks/jobs/sub workflows.
#     * Incomplete - total count of tasks/jobs/sub workflows that are
#       not in succeeded or failed state. This includes all the jobs
#       that are not submitted, submitted but not completed etc. This
#       is calculated as  difference between 'total' count and sum of
#       'succeeded' and 'failed' count.
#     * Total - total count of tasks/jobs/sub workflows.
#     * Retries - total retry count of tasks/jobs/sub workflows.
#     * Total+Retries - total count of tasks/jobs/sub workflows executed
#       during workflow run. This is the cumulative of retries,
#       succeeded and failed count.
# Workflow wall time:
#   The wall time from the start of the workflow execution to the end as
#   reported by the DAGMAN.In case of rescue dag the value is the
#   cumulative of all retries.
# Workflow cumulative job wall time:
#   The sum of the wall time of all jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job wall time as seen from submit side:
#   The sum of the wall time of all jobs as reported by DAGMan.
#   This is similar to the regular cumulative job wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.
# Cumulative job wall time as seen from submit side:
#   The sum of the wall time of all jobs as reported by DAGMan.
#   This is similar to the regular cumulative job wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.
# Workflow cumulative job badput wall time:
#   The sum of the wall time of all failed jobs as reported by kickstart.
#   In case of job retries the value is the cumulative of all retries.
#   For workflows having sub workflow jobs (i.e SUBDAG and SUBDAX jobs),
#   the wall time value includes jobs from the sub workflows as well.
# Cumulative job badput wall time as seen from submit side:
#   The sum of the wall time of all failed jobs as reported by DAGMan.
#   This is similar to the regular cumulative job badput wall time, but includes
#   job management overhead and delays. In case of job retries the value
#   is the cumulative of all retries. For workflows having sub workflow
#   jobs (i.e SUBDAG and SUBDAX jobs), the wall time value includes jobs
#   from the sub workflows as well.

-----------------------------------------------------------------------
Type            Succeeded  Failed  Incomplete  Total     Retries  Total Run
Tasks           4          0       0           4     ||  0        4
Jobs            7          0       0           7     ||  0        7
Sub Workflows   0          0       0           0     ||  0        0
-----------------------------------------------------------------------

Workflow wall time                                       : 3 mins, 25 secs
Workflow cumulative job wall time                        : 2 mins, 0 secs
Cumulative job wall time as seen from submit side        : 2 mins, 0 secs
Workflow cumulative job badput wall time                 : 0
Cumulative job badput wall time as seen from submit side : 0

Summary: submit/tutorial/pegasus/diamond/run0001/statistics/summary.txt

</pre>
<p>The output of <code class="literal">pegasus-statistics</code> contains many
    definitions to help users understand what all of the values reported mean.
    Among these are the total wall time of the workflow, which is the time
    from when the workflow was submitted until it finished, and the total
    cumulative job wall time, which is the sum of the runtimes of all the
    jobs.</p>
<p>The <code class="literal">pegasus-statistics</code> command also writes out
    several reports in the <code class="filename">statistics</code> subdirectory of the
    workflow submit directory:</p>
<pre class="programlisting">$ <span class="bold"><strong>ls submit/tutorial/pegasus/diamond/run0001/statistics/</strong></span>
breakdown.csv  jobs.txt          summary.txt         time.txt
breakdown.txt  summary-time.csv  time-per-host.csv   workflow.csv
jobs.csv       summary.csv       time.csv            workflow.txt</pre>
<p>The file <code class="filename">breakdown.txt</code>, for example, has min,
    max, and mean runtimes for each transformation:</p>
<pre class="programlisting">$ <span class="bold"><strong>more submit/tutorial/pegasus/diamond/run0001/statistics/breakdown.txt</strong></span>
# legends
# Transformation - name of the transformation.
# Count          - the number of times the invocations corresponding to
#                  the transformation was executed.
# Succeeded      - the count of the succeeded invocations corresponding
#                  to the transformation.
# Failed         - the count of the failed invocations corresponding to
#                  the transformation.
# Min(sec)       - the minimum invocation runtime value corresponding to
#                  the transformation.
# Max(sec)       - the maximum invocation runtime value corresponding to
#                  the transformation.
# Mean(sec)      - the mean of the invocation runtime corresponding to
#                  the transformation.
# Total(sec)     - the cumulative of invocation runtime corresponding to
#                  the transformation.

# a1f5ba03-a827-4d0a-8d59-9941cbfbd83d (diamond)
Transformation   Count  Succeeded  Failed  Min     Max     Mean     Total
analyze          1      1          0       30.008  30.008  30.008   30.008
dagman::post     7      7          0       5.0     6.0     5.143    36.0
findrange        2      2          0       30.009  30.014  30.011   60.023
pegasus::dirmanager 1   1          0       0.194   0.194   0.194    0.194
pegasus::transfer 2     2          0       0.248   0.411   0.33     0.659
preprocess       1      1          0       30.025  30.025  30.025   30.025

# All
Transformation   Count  Succeeded  Failed  Min     Max     Mean     Total
analyze          1      1          0       30.008  30.008  30.008   30.008
dagman::post     7      7          0       5.0     6.0     5.143    36.0
findrange        2      2          0       30.009  30.014  30.011   60.023
pegasus::dirmanager 1   1          0       0.194   0.194   0.194    0.194
pegasus::transfer 2     2          0       0.248   0.411   0.33     0.659
preprocess       1      1          0       30.025  30.025  30.025   30.025
</pre>
<p>In this case, because the example transformation sleeps for 30
    seconds, the min, mean, and max runtimes for each of the analyze,
    findrange, and preprocess transformations are all close to 30.</p>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="ch02s09.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="tutorial.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="ch02s11.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">2.9. Debugging the Workflow </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 2.11. Workflow Dashboard</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
